(function($, Lego) {
    Lego.block['b-api-sandbox'] = function(params) {

        var $this = $(this),

            role = params.role,
            currency = params.currency || 'YND_FIXED',

            $intro = $this.find('.b-api-sandbox__intro'),
            $content = $this.find('.b-api-sandbox__content'),

            $init = $this.find('.b-api-sandbox__init'),
            $popup = $this.find('.b-popupa'),
            $popup_init = $this.find('.b-api-sandbox__popup-init'),
            $popup_cancel = $this.find('.b-api-sandbox__popup-cancel'),
            $popup_test_data = $this.find('.b-api-sandbox__popup-test-data'),
            $popup_shared_acc = $this.find('.b-api-sandbox__popup-shared-acc'),
            $popup_radios = $this.find('.b-api-sandbox__popup-radio'),

            $radios = $this.find('.b-api-sandbox__radio'),
            $token = $this.find('.b-api-sandbox__token'),
            $sharedAccount = $this.find('.b-api-sandbox__shared-acc'),
            $sharedAccountRow = $this.find('.b-api-sandbox__shared-acc-row'),

            $paranja = $this.find('.b-api-sandbox__paranja'),
            $wait = $this.find('.b-api-sandbox__wait'),
            $result = $this.find('.b-api-sandbox__result'),

            $action_camp = $this.find('.b-api-sandbox__camp'),
            $action_clear = $this.find('.b-api-sandbox__clear'),
            $action_counter = $this.find('.b-api-sandbox__counter'),
            $action_drop = $this.find('.b-api-sandbox__drop')

            $currency = $this.find('.b-api-sandbox__currency');
            $activateCurrencySelect = $this.find('.b-api-sandbox__activate-choose-currency'),
            updateTestDataPopup = function() {
                if ($activateCurrencySelect.val() != 'YND_FIXED' || $popup_shared_acc.prop('checked')) {
                    $popup_test_data
                        .prop('checked', true)
                        .prop('disabled', 'disabled')
                } else {
                    $popup_test_data
                        .prop('disabled', '')
                }
            };

        //состояние счета не имеет смысла для агенства
        $sharedAccountRow.toggle(role == 'client');

        //Общий счет не имеет смысла для агенства
        $popup_radios.click(function(e) {
            $popup_shared_acc
                .prop('checked', false)
                .prop('disabled', $(e.target).val() == 'client' ? '' : 'disabled');

            updateTestDataPopup();
        });

        //создание общего счета и валюты не имеет смысла без тестовых кампаний
        $popup_shared_acc.on('change', updateTestDataPopup);
        $activateCurrencySelect.on('change', updateTestDataPopup);

        $init.click(function(e) {
            e.preventDefault();
            $popup_radios.filter('.b-api-sandbox__popup-radio:first').prop('checked', true);
            $popup_shared_acc.prop('disabled', '');
            $popup.bem('b-popupa').show($(this));
        });

        $popup_init.click(function(e) {
            e.preventDefault();
            var radio_val = $popup_radios.filter(':checked').val(),
                init_data_val = +$popup_test_data.prop('checked'),
                currency_val = $activateCurrencySelect.val(),
                shared_acc_val = $popup_shared_acc.prop('disabled') == 'disabled' ? 0 : +$popup_shared_acc.prop('checked');

            go_ajax(
                {
                    cmd: 'ajaxInitSandboxUser',
                    sandbox_client_type: radio_val,
                    init_test_data: init_data_val,
                    initial_currency: currency_val,
                    enable_shared_account: shared_acc_val
                },
                iget('Песочница успешно создана.'),
                function() {
                    $intro.addClass('g-hidden');
                    $content.removeClass('g-hidden');
                    $radios.filter('[value="' + radio_val + '"]').prop('checked', true);
                    $currency.html(get_currency(currency_val).full_name);
                }
            );
            $popup.bem('b-popupa').hide();
        });

        $popup_cancel.click(function(e) {
            e.preventDefault();
            $popup.bem('b-popupa').hide();
        });

        $radios.click(function(e) {
            if ($(this).val() != role) {
                if ( confirm(iget('При изменении роли тестового логина будет удалена вся созданная Вами информация в Песочнице. Вы действительно хотите изменить роль?')) ) {
                    go_ajax({
                        cmd: 'ajaxInitSandboxUser',
                        sandbox_client_type: $radios.filter(':checked').val(),
                        init_test_data: 0
                    }, iget('Роль успешно изменена. Создан новый мастер-токен.'));
                } else {
                    e.preventDefault();
                }
            }
        });

        $action_camp.click(function(e) {
            e.preventDefault();
            if ( confirm(iget('При создании тестовых данных будет удалена вся созданная Вами информация в Песочнице.')) ) {
                go_ajax({
                    cmd: 'ajaxInitSandboxUser',
                    sandbox_client_type: $radios.filter(':checked').val(),
                    init_test_data: 1
                }, iget('Созданы тестовые данные.'));
            }
        });

        $action_clear.click(function(e) {
            e.preventDefault();
            if ( confirm(iget('Вы действительно хотите удалить все данные из Песочницы?')) ) {
                go_ajax({
                    cmd: 'ajaxInitSandboxUser',
                    sandbox_client_type: $radios.filter(':checked').val(),
                    init_test_data: 0
                }, iget('Из песочницы удалены все данные.'));
            }
        });

        $action_counter.click(function(e) {
            e.preventDefault();
            if ( confirm(iget('Обнулить значение счётчика финансовых операций в Песочнице?')) ) {
                go_ajax({
                    cmd: 'ajaxDropSandboxFinanceOpsCounter'
                }, iget('Значение счётчика обнулено'));
            }
        });

        $action_drop.click(function(e) {
            e.preventDefault();
            if ( confirm(iget('Вы действительно хотите перестать пользоваться Песочницей и удалить всю созданную в ней информацию?')) ) {
                go_ajax(
                    {
                        cmd: 'ajaxDropSandboxUser'
                    },
                    iget('Песочница закрыта'),
                    function() {
                        $content.addClass('g-hidden');
                        $intro.removeClass('g-hidden');
                    }
                );
            }
        });

        function go_ajax(ajax_data, ajax_result, callback) {
            $paranja.removeClass('g-hidden');
            $wait.removeClass('g-hidden');
            $result.hide();
            $.ajax({
                url: '/registered/main.pl',
                type: 'GET',
                data: ajax_data,
                dataType: 'json',
                success: function(data) {
                    $paranja.addClass('g-hidden');
                    $wait.addClass('g-hidden');
                    if (!data.error) {
                        $token.html(data.current_sandbox_state.master_token);
                        $result.html(ajax_result).show();
                        role = data.current_sandbox_state.role,
                        sharedAccEnabled = data.current_sandbox_state.shared_account_enabled;

                        $sharedAccount.html(sharedAccEnabled ? iget('включен') : iget('выключен'));
                        $sharedAccountRow.toggle(role == 'client');

                        setTimeout(function() {
                            $result.fadeOut(1000);
                        }, 2000);
                        callback && callback();
                    } else {
                        alert(data.error);
                    }
                },
                error: function() {
                    alert(iget('Ошибка запроса. Попробуйте ещё раз.'));
                }
            });
        }

    }
})(jQuery, window.Lego);
