/**
 * Оффлайновый конструктор ставок
 */
include("../../block/b-prices-constructor-control/b-prices-constructor-control.js");
include("../../block/b-prices-constructor-popup/b-prices-constructor-popup.js");

(function($){

    BEM.DOM.decl('b-auto-price', {
        onSetMod: {
            'js': function(){
                var cid = this.params.cid,
                    priceConstructor = BEM.blocks['b-prices-constructor'];

                priceConstructor.setValueFunction = this.setValue;
                priceConstructor.getValueFunction = this.getValue;
                priceConstructor.closeFunction = function() { window.close(); };
                this.campModel = BEM.blocks['i-models-manager'].get('campaign:' + this.params.cid, 'b-campaign-view')
                    .initData(this.params.data);
                priceConstructor.setCampaignId(cid)
            }
        },

        getValue: function (callback) {
            var v;
            try {
                v = JSON.parse( direct.CampOptions.get('offline_price_editor') );
            } catch(e) {}

            callback(v);
        },

        setValue: function(v) {
            try {
                direct.CampOptions.set('offline_price_editor', $.stringify(v));
            } catch(e) {}
        }
    });

})(jQuery);
