(function($, Lego) {
    Lego.block['b-auto-select'] = function(params) {

        var $this = $(this),
            $input = $this.find('.b-auto-select__input'),
            $select = $this.find('.b-auto-select__select'),
            $option = $select.find('.b-auto-select__option'),

            textStorage = [];

        $input.bind('keyup', $.debounce(function() {
            var inputValue = this.value.toLowerCase();
            $option.each(function(i) {
                var $this = $(this);

                if (textStorage[i] === undefined) {
                    textStorage[i] = $this.text().toLowerCase();
                }

                if (textStorage[i].indexOf(inputValue) > -1) {
                    $this.show();
                } else {
                    $this.hide();
                }
            });
        }, 350));

        $input.bind('keypress', function(e) {
            if (e.keyCode == 13) return false;
        });

    }
})(jQuery, window.Lego);