(function($){
var iModelsManager = BEM.blocks['i-models-manager'];

BEM.DOM.decl({name:'b-banner-edit-validate', baseBlock: 'i-banner-edit-validate'}, {
    onSetMod: {
        'js': function(){
            this.enableValidation = !this.params.disableValidation || this.params.disableValidation == '0';
            this.__base();



            this.bindTo('submit', 'click', this.onSubmit);
            this.bindTo('back', 'click', this.onBack);
        }
    },

    compareAddress: function() {
        if ( !this.params.common_ci_set ) return true;
        var changed = false,
            _this = this;

        iModelsManager.eachModel(function(id, model) {
            if (model.get('data_from_server')) return true;
            var vcardModel = model.getChildModel('b-vcard-form');
            if (!model.get('with_ci') || vcardModel.isDataChanged(_this.params.common_ci, 'input')) {
                changed = true;
                return false;
            }
        }, 'campaign&banner:*', 'b-banner-edit');

        if (changed) {
            return confirm(iget("Вы изменили контактную информацию! При сохранении установленная ЕДИНАЯ контактная информация будет ОТМЕНЕНА! Сохранить?"));
        }
        return true;
    },

    validate: function() {
        if (!this.enableValidation) return true;
        var hasErrors = false,
            sitelinksModel;

        iModelsManager.eachModel(function(id, model) {

            // DIRECT-23538: Показываются предупреждения об изменении ЕКИ, хотя изменения не сохранялись.
            if (!model.get('with_ci')) {
                var vcardModel = model.getChildModel('b-vcard-form');

                vcardModel
                    .reset()
                    .clearModelErrors();

                $.each(vcardModel.childModelsHash, function(n, model) {
                    model.clearModelErrors();
                });
            }

            if (!model.get('data_from_server')) {
                hasErrors = !model.validateModel(1) || hasErrors;
            }

        }, 'campaign&banner:*', 'b-banner-edit');


        BEM.blocks['b-banner-edit'].trigger('errors.reset');
        return !hasErrors;

    },


    onBack: function() {
        this.elem('back-input').val(1);
        this.domElem.submit();
    },

    onSubmitDataPrepared: function() {
        if (!this.validate()) return false;
        //ругаемся если поменялся ЕКИ
        if (!this.compareAddress()) return false;

        var isChanged = false,
            params = { cid: this.cid, bids: [], cmd: 'ajaxCheckBannersMinusWords' },
            _this = this;

        iModelsManager.eachModel(function(i, model) {
            if (!model.get('data_from_server') && (model.isFieldChanged('all_phrases') || model.getChildModel('b-minus-words').isFieldChanged('minus_words'))) {
                isChanged = true;
                var bid = model.get('bid');

                params.bids.push(bid);
                params['minus_words-' + bid] = model.getChildModel('b-minus-words').get('minus_words');
                params['key_words-' + bid] = (model.get('all_phrases').split(',')).join(' ');
            }

        }, 'campaign&banner:*', 'b-banner-edit');

        // проверяем пересечения слов
        if (isChanged) {
            params.bids = params.bids.join(',');

            _this.submitDisable(true);
            BEM.blocks['b-minus-words'].ajaxCheck(params,
                function(errors) {
                    if (!errors || !errors.problem || errors.ok || errors.problem && confirm(errors.problem)) {
                        _this.domElem.submit();
                    }
                    _this.submitNotification(false);
                    _this.submitDisable(false);
                });
        } else {
            this.domElem.submit();
        }

        return false;
    },

    onSubmit: function() {

        if (!this.enableValidation) {
            this.domElem.submit();
            return true;
        }

        var deferred,
            _this = this,
            promisesArray = [];

        iModelsManager.eachModel(function(i, model) {
            deferred = $.Deferred();
            promisesArray.push(deferred.promise());
            model.trigger('prepare', { deferred: deferred });
        }, 'campaign&banner:*', 'b-banner-edit');

        $.when(promisesArray).done(function() {
            _this.onSubmitDataPrepared();
        });
    }
});

})(jQuery);
