
(function($, Lego) {
    BEM.DOM.decl({name:'b-banner-edit', baseBlock: 'i-banner-edit'}, {
        onSetMod : {
            js: function() {
                var groupPreview;

                BEM.blocks['b-banners-group-preview'].getInstance(function(instance){
                    groupPreview = instance;
                });

                this.__base();

                this.model
                    .onField('with_href', 'change', function(e, data) {
                        if (data.source == this) return;
                        !this.model.get('with_href') && !this.model.get('ci_checked') && this.model.set('ci_checked', 1, this);
                    }, this)
                    .onField('ci_checked', 'change', function(e, data) {
                        if (data.source == this) return;
                        !this.model.get('with_href') && !this.model.get('ci_checked') && this.model.set('with_href', 1, this);
                    }, this);

                this.bindTo('group-name', 'click', function(e) {
                    groupPreview.showPreview(this.model.get('groupId'), e.data.domElem);
                });

                //DIRECT-22837 отменяем отправку форму по enter в фаерфоксе
                this.domElem.find('input').keypress(function(e) {
                    if (e.which === 13) return false;
                });
            }
        }


    });

    BEM.blocks['b-model'].register('b-banner-edit', {
        fields: {
            'data_from_server': { type: 'flag' },
            'is_mediaplan': { type: 'flag' },
            'ci_hidden': { type: 'flag' },
            //чекбокс "использовать адрес и телефон", только в чайниках и медиапланах
            'ci_checked': { type: 'flag' },
            'with_href': { type: 'flag', fromServer: 1, childModels: ['b-vcard-form', 'b-banner-form-href'] },
            'disableHref': { type: 'flag', fromServer: 1, childModels: ['b-vcard-form', 'b-banner-form-href'] },
            'with_ci': { type: 'flag' , childModels: ['b-vcard-form']},
            'is_lite': { type: 'flag' },
            'with_sitelinks': { type: 'flag' },
            'bid': { type: 'string', fromServer: 1, toServer: 1 },
            'pid': { type: 'string', fromServer: 1, toServer: 1 },
            'groupId': { type: 'string', fromServer: 1, toServer: 1 },
            'all_phrases': { type: 'string', input: 1, fromServer: 1, toServer: 1 },
            'new_phrases': { type: 'string', input: 1 },
            //только для медиапланов - фразы, которые надо разбить
            'phrases_to_split': {type: 'string'},

            'bkBannerId':  { type: 'string', input: 1, fromServer: 1 },

            'image': {type: 'string', input: 1, fromServer: 1, toServer: 1},
            'image_name': {type: 'string', input: 1},


             //поле используется только для валидации
            'sitelinks': {type: 'string', input: 1},

            'geo': {type: 'string', input: 1, fromServer: 1, toServer: 1},
            'geo_text': {type: 'string', input: 1, fromServer: 1, toServer: 1},

            'age': { type: 'integer', 'default': -1 },
            'age_enabled': { type: 'flag', fromServer: 1 },

            'child_age': { type: 'integer', 'default': 11 },
            'baby_food_enabled': { type: 'flag', fromServer: 1 },

            'title': {type: 'string', input: 1, fromServer: 1, toServer: 1},
            'title_extension': {type: 'string', input: 1, fromServer: 1, toServer: 1},
            'body': {type: 'string', input: 1, fromServer: 1, toServer: 1},
            'retargeting_conditions_id': {type: 'string', input: 1, fromServer: 1, toServer: 1},

            //следующие поля перенесены из b-banners-list-banner
            'geo_ids':  {type: 'string', fromServer: 1},
            'status': {type: 'string', fromServer: 1},
            'statusModerate': {type: 'string', fromServer: 1},
            'statusActive': {type: 'string', fromServer: 1},
            'pstatusModerate': {type: 'string', fromServer: 1},
            'pstatusPostModerate': {type: 'string', fromServer: 1},
            'statusShow': {type: 'string', fromServer: 1, 'default': 'Yes'},
            'statusAutobudgetShow': {type: 'string', fromServer: 1},
            'isTemplateBanner': {type: 'string', fromServer: 1},
            'declined_show': {type: 'flag', fromServer: 1}
        },

        validateRules: {
            title: {
                list: [ { name: 'required', id: 'required', text: iget('Заполнены не все требуемые поля: ') + iget('заголовок 1') }],
                condition: function() { return !this.get('is_mediaplan'); }
            },
            body: {
                list: [ { name: 'required', id: 'required', text: iget('Заполнены не все требуемые поля: ') + iget('текст объявления') }],
                condition: function() { return !this.get('is_mediaplan'); }
            },
            all_phrases: {
                condition: function() {
                    return !this.get('is_lite') && !this.get('retargeting_conditions_id');
                },
                list: [
                    { name: 'required', id: 'required', text: function() {
                        return iget('Не заполнено ни одно из полей - ключевые фразы, условия ретаргетинга');
                    } },
                    {
                        id: 'maxlength', name: 'phrases_length',
                        validator: function() {
                            return direct.utils.getKeywordsLength(this.get('all_phrases')) <= 4096;
                        },
                        condition: function() {
                            return !this.get('is_mediaplan');
                        },
                        text: iget('Превышена допустимая длина ключевых фраз в 4096 символов')
                    }
                ]
            },
            sitelinks: {
                list: [
                    {
                        name: 'href-required',
                        id: 'href-required',
                        validator: function() {
                            return (!this.getChildModel('b-banner-form-href').isFieldEmpty('href') || this.getChildModel('b-banner-sitelinks').isModelEmpty('input'));
                        },
                        text: iget('Если заполнены быстрые ссылки, то должна быть заполнена основная ссылка на сайт')
                    }
                ]
            }

        },



        childModels: {
            'b-vcard-form': {
                source: 'vcard',
                condition: function() { return !this.get('is_lite') && this.get('with_ci') && !this.get('is_mediaplan') }
            },
            'b-banner-form-href': {
                condition: function() {
                    return (this.get('with_href') || !this.get('with_ci')) && !this.get('is_mediaplan');
                }
            },
            'b-banner-sitelinks': { source: 'sitelinks' },
            'b-minus-words': {
                source: 'minus_words',
                condition: function() { return !this.get('is_lite') }
            }
        }
    });
})(jQuery, window.Lego);
