(function($){
    var iModelsManager =  BEM.blocks['i-models-manager'];
    BEM.DOM.decl('b-banner-form-errors-header', {
        onSetMod: {
            'js': function(){
                this.__self.liveBindTo('link', 'click', this.onLinkClick);
                BEM.blocks['b-banner-edit'].on('errors.reset', this.onErrorsReset, this);
            }
        },

        onErrorsReset: function() {
            var bidsWithErrors = [], hasErrors = false, errorsElem = [];


            iModelsManager.eachModel(function(id, model) {
                if (!model.get('data_from_server') && model.modelHasErrors(true)) {
                    bidsWithErrors.push(model.get('bid'));
                    hasErrors = true;
                }
            }, 'campaign&banner:*', 'b-banner-edit');

            if (hasErrors) {
                $.each(bidsWithErrors, function(key, bid){
                    errorsElem.push({
                        tag: 'span',
                        block: 'b-banner-form-errors-header',
                        elem: 'link',
                        mods: {id: bid},
                        cls: 'b-pseudo-link',
                        content:  "№ М-" + bid
                    });

                    if (key != bidsWithErrors.length - 1) {
                        errorsElem.push({
                            tag: 'span',
                            content: ',&nbsp'
                        });
                    }

                });
                BEM.DOM.update(this.elem('links-container'),
                    BEM.HTML.build(errorsElem));
            }


            this.setMod('hidden', hasErrors ? 'no' : 'yes');
            hasErrors && $(window).scrollTop(0);
        },

        onLinkClick: function(e) {
            var id = this.getMod(e.data.domElem, 'id'),
                banner = $('#Banner-' + id);
            if (banner.length) {
                $(window).scrollTop((banner.offset()).top);
            }
        }
    });

})(jQuery);

(function($, Lego) {
    var iModelsManager =  BEM.blocks['i-models-manager'];

    Lego.block['b-banner-form__errors__header'] = function(params) {
        var $this = $(this),
            linksContainer = $this.find('.b-banner-form__eh__links-container');
        $this.delegate('.b-banner-form__eh__link', 'click', onLinkClick);

        BEM.blocks['b-banner-edit'].on('errors.reset', onErrorsReset);

        function onErrorsReset() {
            var bidsWithErrors = [], hasErrors = false;


            iModelsManager.eachModel(function(id, model) {
                if (model.hasErrors()) {
                    bidsWithErrors.push(model.get('bid'));
                    hasErrors = true;
                }
            }, 'campaign&banner:*', 'b-banner-edit');


            linksContainer.empty();
            if (hasErrors) {
                $.each(bidsWithErrors, function(key, bid){
                    $("<span/>",
                        {
                            "class": "b-pseudo-link b-banner-form__eh__link",
                            text: "№ М-" + bid,
                            data: {'id': bid}
                        }).appendTo(linksContainer);
                    if (key != bidsWithErrors.length - 1) {
                        $("<span>,&nbsp</span>").appendTo(linksContainer);
                    }

                })
            }
            $this.toggleClass('g-hidden', !hasErrors);
            $(window).scrollTop(0);
        }




    }
})(jQuery, window.Lego);
