(function($){
    var iModelsManager =  BEM.blocks['i-models-manager'];

    BEM.DOM.decl('b-banner-form-errors', {
        onSetMod: {
            'js': function(){
                this.model = iModelsManager.get(this.params.modelPath, this.params.modelName);
                this.cutMod = this.params.cut_mode || 'cut_second';
                this.errorId = this.params.errorId;
                this.validateType = this.params.type;
                this.model.on('error-set error-clear', this.onErrorsChange, this);
                this.bindTo('show hide', 'click', this.toggleText);

                if (this.params.errors) {
                    this.model.validator.setErrorManual(this.errorId, this.params.errors.join('<br>'));
                    BEM.blocks['b-banner-edit'].trigger('errors.reset');
                }
            }
        },

        hasErrors: function() {
            return this.validateType == 'field' ? this.model.hasErrors(this.errorId) || !this.model.isFieldChanged(this.errorId) && this.params.hasError : this.model.hasErrors(this.errorId);
        },

        onErrorsChange: function(e, data) {
            var hasErrors = this.hasErrors();

            this.setMod('show-errors', hasErrors ? 'yes' : 'no');

            if (this.validateType == 'model') {
                 this.elem('first').html(hasErrors ? this.model.getGlobalErrorText() : '');
            } else {
                if (!this.model.isFieldChanged(this.errorId) && this.params.hasError) return this;
                var messages = this.model.getErrorsMessagesForField(this.errorId),
                    showCut = messages.length > 1 || (messages.length == 1 && this.cutMod == 'cut_all');
                this.setMod('show-cut', showCut ? 'yes' : 'no');


                if (messages.length > 0) {
                    if (!showCut) {
                        this.elem('first').html(messages.join('<br/>'));
                    } else {
                        this.elem('full').html(messages.join('<br/>'))
                    }
                }
            }

            return this;

        },

        toggleText: function() {
            this.setMod('cut', this.getMod('cut') == 'close' ? 'open' : 'close');
            this.adjustHeight();
        },

        adjustHeight: function() {
            this.elem('strut').height(this.elem('text').height());
        }
    });
})(jQuery);
