(function($){

BEM.DOM.decl('b-banner-form-href-switcher', {
    onSetMod: {
        'js': function(){
            this.model = BEM.blocks['i-models-manager'].get(this.params.modelPath, 'b-banner-edit')
                .onField('disableHref', 'change', this.onModelChanged, this);

            this.switcher = this.findBlockInside('b-form-checkbox')
                .on('change', this.onCheckboxSwitched, this)

            this.model.set('disableHref', +!this.switcher.isChecked())
        }
    },

    onCheckboxSwitched: function() {
        if (this.switcher.getMod('focused') != 'yes') return;
        this.model.set('disableHref', this.switcher.getMod('checked') == 'yes' ? 0 : 1, this);
    },

    onModelChanged: function(e, data) {
        if (data.source == this) return;
        this.switcher.setMod('checked', this.model.get('disableHref') ? 'no' : 'yes');
    }
});

})(jQuery);
