include('../../js/jq/direct/urlCheck.js');

(function($){

    BEM.blocks['b-model'].register('b-banner-form-href', {
        fields: {
            'href': { type: 'string', input: 1 },
            'domain': { type: 'string', input: 1 },
            'domain_sign': { type: 'string' },
            'domain_redir': { type: 'string' },
            'domain_redir_sign': { type: 'string' },
            'domain_error': { type: 'string' },
            'urlProtocol': { type: 'string', 'default': 'http://' }
        },
        validateRules: {
            href: {
                list: [
                    {name: 'required', id: 'required', text: iget('Не введена ссылка на сайт')}
                ]
            }
        },

        errorText: iget('Не введена ссылка на сайт')

    });

    BEM.DOM.decl('b-banner-form-href', {
        onSetMod: {
            'js': function(){
                var _this = this,
                    formInput = this.findBlockInside('b-form-input'),
                    bannerModel = BEM.blocks['i-models-manager'].get(this.params.modelPath, 'b-banner-edit');

                this.model = BEM.blocks['i-models-manager'].get(this.params.modelPath, 'b-banner-form-href');

                this.limit = this.params.limit;
                this.canEdit = this.elem('domain-input').length;
                this.originalDomain = this.model.get('domain');
                this.lastUrl = this.elem('href').val();
                this.urlProtocol = this.elem('protocol').val();

                this.model.set('urlProtocol', this.urlProtocol);

                var inputOriginalDomain = this.originalDomain && this.originalDomain != direct.utils.extractDomain(this.lastUrl);

                this
                    .bindTo('domain-input', 'keyup click blur', this.onDomainInput)
                    .bindTo('protocol', 'change', this.onProtocolChange)
                    .bindTo('href', 'focus', function() {
                        _this.lastUrl = _this.elem('href').val();
                    })
                    .bindTo('href', 'blur', function() {
                         // по блюру быстро проверяем введенное значение
                        _this.checkUrl();
                        //для b-word-suggestion
                        _this.model.trigger('finishEditing.url')
                    })
                    .bindTo('href', 'change blur input', function(e) {
                        var value = $.trim(_this.elem('href').val());
                        if (_this.lastUrl == value) return;

                        _this.lastUrl = value;

                        var domain = direct.utils.extractDomain(value);

                        if (!inputOriginalDomain || !_this.canEdit) {
                            _this.elem('domain').val(domain);
                            _this.elem('domain-redir').val(domain);
                            _this.elem('domain-sign').val('');
                        }

                        _this.updateProtocol(value);
                        _this.updateModel();
                        _this.updateCounter();
                    });

                this.model
                    .onField('href domain', 'change', function(e, source) {
                        if (source != this) {
                            this.updateView();
                            // если пришла новая ссылка, выполнить проверку
                            if (this.lastUrl != this.model.get('href')) this.checkUrl();
                        }
                    }, this)
                    .onField('urlProtocol', 'change', function(e, source) {
                        (this.model.get('href') || '').length && this.checkUrl();
                        this.updateView();
                    }, this)
                    .onInitData(this.updateView, this);

                bannerModel.onField('disableHref', 'change', function(e, data) {
                    formInput.setMod('disabled', data.value  ? 'yes' : '');
                    bannerModel.set('with_href', !data.value);
                });

            }
        },

        dontUpdateHref: null,

        updateProtocol: function(value) {
            var striped = direct.utils.stripHttp(value),
                protocol = direct.utils.getUrlProtocol(value);

            protocol && this.elem('protocol').val(protocol);

            if (striped != value) {
                this.elem('href').val(striped);
            }
        },

        updateModel: function() {
            this.model.update({
                domain: this.elem('domain').val(),
                domain_sign: this.elem('domain-sign').val(),
                domain_redir: this.elem('domain-redir').val(),
                domain_redir_sign: this.elem('domain-redir-sign').val(),
                domain_error: '',
                href: this.elem('href').val(),
                urlProtocol: this.elem('protocol').val()
            }, this);
        },

        updateView: function() {
            // не трогать значения в редактируемых полях если они не поменялись
            if (this.model.get('href') != this.elem('href').val()) this.elem('href').val(this.model.get('href'));
            if (this.model.get('domain').length && this.model.get('domain') != this.elem('domain').val())
                this.elem('domain').val(this.model.get('domain'));

            this.elem('domain-sign').val(this.model.get('domain_sign'));
            this.elem('domain-redir').val(this.model.get('domain_redir'));
            this.elem('protocol').val(this.model.get('urlProtocol'));
            this.elem('domain-redir-sign').val(this.model.get('domain_redir_sign'));
            this.updateCounter();
        },

        onDomainInput: function() {
            this.elem('domain-sign').val('');

            var domain = this.elem('domain-input').val();

            this.model.update({
                domain: domain,
                domain_sign: ''
            }, this);

            // end proposed fix

            this.originalDomain = domain; // домен поменяли руками, больше не обновляем
        },

        onProtocolChange: function() {
            this.model.update({ urlProtocol: this.elem('protocol').val() }, this);
        },

        updateCounter: function() {
            var length = this.model.get('href').length;

            this.elem('counter')
                .html(this.limit - length);

            this.setMod(this.elem('counter'), 'overflow', this.limit < length ? 'yes' : 'no');
        },

        checkUrl: function() {
            var value = this.elem('href').val(),
                protocol = this.model.get('urlProtocol');

            if (direct.utils.validateHref(value)) {
                // если сслыка хорошая идем на сервер за данными о домене
                this.lastUrl = $.trim(value);

                // the value of domain_error should be reset before as url checking is async process and
                // some logic based on domain_error value may result in unexpected result (see DIRECT-9020 for instance
                this.model.update({domain_error: ""});
                direct.UrlCheck.check(this.lastUrl, $.proxy(this.onUrlCheck, this), protocol);
            }
        },

        onUrlCheck: function(data) {
            data = data || {};
            // если значение поменялось за время запроса, ничего не делать
            if (data.url != this.lastUrl) return;

            if (this.model.get('domain').length) {
                if (data.code == 1) {
                   // если домен провалидирован, проставляем вычисленные значения
                    var domain = data.domain,
                        domain_redir = data.domain_redir;

                    this.model.update({
                        domain: domain,
                        domain_sign: data.domain_sign,
                        domain_redir: domain_redir,
                        domain_redir_sign: data.domain_redir_sign,
                        domain_error: this.canEdit && this.originalDomain && this.originalDomain != domain_redir ? iget('Отображаемая ссылка изменилась. Проверьте правильность.') : ''
                    });

               } else {
                   // если нет, взводим ошибку
                   this.model.update({
                       domain_error: data.text
                   });
               }
            }
        }
    });

})(jQuery);


