(function($, Lego) {
    var iModelsManager = BEM.blocks['i-models-manager'];

    Lego.block['b-banner-form__copy-clear-link'] = function(params) {

        var $this = $(this),
            model = iModelsManager.get(params.modelPath, 'b-banner-edit'),
            prevModel = params.prevModelPath ? iModelsManager.get(params.prevModelPath, 'b-banner-edit') : '';

        var copy_link = $this.find('.copy-link'),
            clear_link = $this.find('.clear-link');

        if (copy_link.length > 0) {
            copy_link.bind('click', onCopyLinkClick);
        }

        if (clear_link.length > 0) {
            clear_link.bind('click', onClearLinkClick);
        }

        function onCopyLinkClick(event) {
            event.preventDefault();

            // заплатка для DIRECT-16205 не копируем ключевики из данных о предыдущем баннере
            var data = prevModel.memento(0, 1);
            delete data.all_phrases;
            delete data.data_from_server;
            delete data.client_allow_retargeting;
            model.update(data, 'copy_global', 1).getChildModel('b-vcard-form').trigger('copy');


            return false;
        }

        function onClearLinkClick(event) {
            event.preventDefault();
            model.clear('copy_global', 1, ['with_ci', 'with_href', 'ci_hidden', 'all_phrases']).getChildModel('b-vcard-form').trigger('clear');

        }
    }
})(jQuery, window.Lego);
