(function($, Lego) {
    var iModelsManager = BEM.blocks['i-models-manager'];

    Lego.block['b-banner-form__validator-easy'] = function(params) {
        var $this = $(this),
            model2 = iModelsManager.get(params.modelPath, 'b-banner-edit'),
            enableValidation = !params.disableValidation || params.disableValidation == '0',
            vcardModel = iModelsManager.get(params.vcardModelPath, 'b-vcard-form'),
            timetargetModel = iModelsManager.get('campaign', 'b-time-targeting'),

            showTimetarget = params.showTimetarget,
            messagesContainer = $this.find('.error_message'),
            $submitBtn = $this.find('.submit-btn'),
            $inProgress = $this.find('.b-banner-form__validator-easy__loading'),

            fieldNames = {
                title:          iget("заголовок объявления"),
                body :          iget("текст объявления"),
                autobudget_sum: iget("недельный бюджет"),
                phrases:        iget("ключевые фразы"),
                href:           iget("адрес сайта"),
                country:        iget("страна"),
                city:           iget("город"),
                country_code:   iget("код страны"),
                city_code:      iget("код города"),
                phone:          iget("телефон"),
                name:           iget("компания/ФИО"),
                email:          iget("электронная почта"),
                fio:            iget("имя и фамилия")
            },

            timeTargetErrorText = iget('Объявления должны быть включены не менее 40 часов в неделю в рабочие дни. Измените расписание показа объявлений.'),

            reqFields = [],
            
            fields = {};


        var strategiesModels = {},
            strategyModel = iModelsManager.get('campaign', 'b-easy-campaign-strategy');

        $.each(['easy-week-bundle', 'fast', 'distributed'], function(i, name) {
            strategiesModels[name.replace(/-/g, '_')] = iModelsManager.get('campaign', 'b-easy-campaign-strategy-' + name)
                .on('error-set', onStrategyErrors)
                .on('error-clear', onStrategyErrors);
        });


        strategyModel
            .onField('strategy', 'change', onStrategyErrors)
            .onField('loading_status', 'change', function() {
                $submitBtn.prop('disabled', strategyModel.get('loading_status') == 'process')
            });


        for (var name in fieldNames) {
            fields[name] = {};
            fields[name].input = $this.find('.validated-' + name);
            fields[name].td = fields[name].input.parents('td.validated-input-value');
        }



        $submitBtn.click(onSubmit);

        function submitProgess(start) {
            $submitBtn.prop('disabled', !!start);
            $inProgress[start ? 'show' : 'hide']();
        }

        function onSubmit() {
            submitProgess(1);
            if (validate()) {
                $($submitBtn.get(0).form).submit();
            } else {
                submitProgess(0);
            }
        }

        function checkFilled(fieldName) {
            if (!fields[fieldName].input[0] || fields[fieldName].input.val()) return true;
            reqFields.push(fieldName);
            return false;
        }

        function getOGRNErrorText() {
            return iget('Введен неверный ОГРН/ОГРНИП');
        }

        function isValidOGRN() {
            return  vcardModel.getChildModel('b-ogrn-input').validateField('ogrn')
        }

        function getErrorText() {
            var text = '';
            if (!model2.get('with_ci') && !model2.get('disableHref') && model2.get('with_href')) {
                text += iget('Заполните ссылку на сайт или контактную информацию') + '<br/>'
            }

            // для DIRECT-13420 проверяем длину фраз
            if (!model2.validateField('all_phrases')) text += model2.getErrorsMessagesForField('all_phrases') + '<br/>';

            text += (showTimetarget && timetargetModel.get('counter') < 40 ? timeTargetErrorText + '<br/>' : '') +
                (!isValidOGRN() ? getOGRNErrorText() + '<br/>' : '') +
                (reqFields.length ?
                    iget('Не заполнены обязательные поля') + ':' +
                    '<ul>' +
                        $.map(reqFields, function(el){ return '<li>' + fieldNames[el] + '</li>' }).join('') +
                    '</ul>' :
                    '');
            return text;
        }

        function onStrategyErrors(e) {
            $submitBtn.prop('disabled', strategiesModels[strategyModel.get('strategy')].hasErrors() || strategyModel.get('loading_status') == 'process');
        }

        function validate() {
            var easyBemBlock = $('.b-strategy-select-easy').bem('b-strategy-select-easy');

            if (!enableValidation) { easyBemBlock && easyBemBlock.updateHiddens(); return true; }

            var strategy = strategyModel.get('strategy');
            //DIRECT-15004
            if (strategyModel.get('loading_status') == 'process') { strategyModel.set('loading_status', 'skip'); }

            if (!strategiesModels[strategy].validateModel()) {
                return false;
            }

            if (strategiesModels[strategy].hasWarnings() && strategy == 'distributed' &&
                !confirm(strategiesModels[strategyModel.get('strategy')].getErrorsMessagesForField('manual_autobudget_sum', 'warnings').join(''))) {
                return false;
            }


            easyBemBlock && easyBemBlock.updateHiddens();

            messagesContainer.html('').addClass('g-hidden');



            reqFields = [];

            // формируем список обязательных полей
            var checkableFields =
                    ['title', 'body', 'autobudget_sum']
                    .concat(
                    //Проверяем заполненность ссылки если поле не скрыто
                        !model2.get('disableHref') && model2.get('with_href') ? ['href'] : [],

                    // чтобы сохранить порядок следования, пункт про контрольные фразы ставим в отдельный concat
                        ['phrases'],

                    //Проверяем заполненность адреса если поле не скрыто
                    //    model2.get('with_ci') ? ['country', 'city', 'country_code', 'city_code', 'phone', 'name'] : [],


                    // Проверяем заполненность конт. инф. для наших уведомлений
                        ['fio', 'email']),
                vcardResult = !model2.get('with_ci') || vcardModel.validate(),
                result =
                    // проверяем поля, результаты проверки конвертируем в 0/1 и записываем в массив, затем джойним его
                    // и если есть хотябы один 0 то result == false
                    $.map(checkableFields, function(el){ return +checkFilled(el) })
                        .concat([+isValidOGRN(), +!(showTimetarget && timetargetModel.get('counter') < 40)])
                        .join('').indexOf('0') == -1;
            if (!vcardResult) {
                var vcardErrors = vcardModel.getErrors();
                $.each(vcardErrors, function(name) {
                    if (name != 'ogrn') {
                        reqFields.push(name);
                    }
                })
            }


            // также для DIRECT-13420 проверяем длину фраз
            result = result && (model2.get('with_ci')  ||
                (model2.get('with_href') && !model2.get('disableHref')) &&
                model2.validateField('all_phrases'));


            if (!result || !vcardResult){
                messagesContainer.html(getErrorText()).removeClass('g-hidden');
                scroll(0,0);
            }

            if ($.browser.msie) {
                document.body.className = document.body.className;
            }


            // Если все заполнено -- проверяем Оферту
            if ( result && $("#agree")[0] != null && !$("#agree").prop('checked')) {
                alert(iget("Вам необходимо подтвердить согласие с условиями размещения, описанными в оферте."));
                return false;
            }
            var strategyBlock = $this.find('.b-strategy-select-easy').bem('b-strategy-select-easy');
            strategyBlock.clearPanes();
            timetargetModel.trigger('refresh');
            return result && vcardResult; //false && (reqFields.length > 0);
        }
    }

})(jQuery, window.Lego);
