(function($, Lego) {
    var MAX_ERROR_MESSAGES = 3,
        iModelsManager =  BEM.blocks['i-models-manager'];

    Lego.block['b-banner-form__validator-multi_lite'] = function(params) {
        var $this = $(this),

        submit = $this.find('.submit'),
        enableValidation = !params.disableValidation || params.disableValidation == '0';

        $this.submit(validate);

        function validate(e) {
            if (!enableValidation) return true;
            var hasErrors = false;


            iModelsManager.eachModel(function(id, model) {
                if (model.get('data_from_server')) return true;

                hasErrors = hasErrors || !model.validateModel();
            }, 'campaign&banner:*', 'b-banner-edit');

            BEM.blocks['b-banner-edit'].trigger('errors.reset');

            if (hasErrors) { e.preventDefault(); return false;}

            return true;
        }
    };
})(jQuery, window.Lego);
