(function($, Lego) {
    var iModelsManager = BEM.blocks['i-models-manager'];

    Lego.block['b-banner-form__multiedit'] = function(params) {
        var $this = $(this),
            phrases = params.phrases,
            modelsName = params.modelsName || 'b-banner-edit',
            wholeCampElem =  $this.find('.b-banner-form__multiedit__whole-camp'),
            wholeCampCheckbox = wholeCampElem.length > 0 ? wholeCampElem.bem('b-form-checkbox') : false,
            banners_array = params.banners_array,
            sitelinks_model = iModelsManager.get('campaign', 'b-banner-sitelinks'),
            popupa = $this.parents('.b-popupa').bem('b-popupa'),
            $switcher = $('#multiedit_functions_link'),
            tabHandlers = {
                'replace-href': replaceHref,
                'update-href': updateHref,
                'replace-domain': replaceDomain,
                'update-text': updateText,
                'add-minus-words': addMinusWords,
                'add-sitelinks': addSitelinks
            },
            tabButtons = {};
        $.map(['replace-href', 'update-href', 'replace-domain', 'update-text', 'add-minus-words', 'add-sitelinks'], function(type) {
            var btnElem = $this.find('.b-bfm__action_type_' + type);
            if (!btnElem.length) { return }
            tabButtons[type] = $this.find('.b-bfm__action_type_' + type).bem('b-form-button')
                .on('click', tabHandlers[type]);
        });

        $('.b-bfm__new-href', $this).on('input', onNewHref);

        sitelinks_model.onField('has_errors', 'change', function() {
            tabButtons['add-sitelinks'].setMod('disabled', sitelinks_model.get('has_errors') ? 'yes' : 'no')
        }, this);

        BEM.blocks['b-popupa'].on('showPopup', function(e, source) {
            if (source !== $this) {
               popupa.hide();
            }
        });

        // methods to open/close the popup window
        $switcher.click(function() {
            BEM.blocks['b-popupa'].trigger('showPopup', $this);
            popupa.show($switcher);
        });

        $('.b-bfm__close', $this).click(function() {
            popupa.hide();
        });
        // end

        // ie needs this to show placeholders
        /*
        $this.bind('b-tabs.changed', function() {
            $('.b-tabs__target__li_active .b-bfm__input,.b-tabs__target__li_active .b-bfm__textarea', $this).focus().blur();
        });
        */

        function onNewHref() {
            var input = $(this),
                value = $.trim(input.val()),
                stripedValue = direct.utils.stripHttp(value),
                protocol = direct.utils.getUrlProtocol(value);

            protocol && $('.b-bfm__new-href-protocol', $this).val(protocol);
            stripedValue != value && input.val(stripedValue);
        }

        function replaceOGRNNumber() {
            var input = $('.b-bfm__new-ogrn', $this),
                newValue = input.val();

            if (!newValue) {
                alert(iget('Введите новый ОГРН/ОГРНИП'));
                return;
            }

            if (!direct.utils.validateOGRN(newValue)) {
                alert(iget('Введенный Вами ОГРН/ОГРНИП не корректен'));
                return;
            }

            iModelsManager.eachModel(function(id, m) {
                m.update({ ogrn: {ogrn: newValue } }, $this, 1);
            }, 'campaign&banner:*', modelsName);


            input.val('');
            popupa.hide();
        }

        function replaceHref () {
            var input = $('.b-bfm__new-href', $this),
                protocol = $('.b-bfm__new-href-protocol', $this).val(),
                newValue = input.val(),
                updateDomain = $('.b-bfm__replace-domain', $this).prop('checked') || $('.b-bfm__replace-domain', $this).length == 0;
            if (!newValue) {
                alert(iget('Введите новую ссылку'));
                return;
            }

            if (!direct.utils.validateHref(newValue)) {
                alert(iget('Введенный Вами URL не работает'));
                return;
            }

            tabButtons['replace-href'].setMod('disabled', 'yes');

            direct.UrlCheck.check(newValue, $.proxy(function(data) {
                data = data || {};

                tabButtons['replace-href'].delMod('disabled');

                if (data.code == 1) {
                    iModelsManager.eachModel(function (id, m) {
                        m.getChildModel('b-banner-form-href').update({
                            href: newValue,
                            domain: updateDomain ? direct.utils.extractDomain(newValue) : undefined,
                            urlProtocol: protocol
                        });
                    }, 'campaign&banner:*', modelsName);

                    input.val('');
                    popupa.hide();

               } else {
                   // если нет, взводим ошибку
                   alert(data.text);
               }
            }, this), protocol);
        }

        function replaceDomain () {

            var input = $('.b-bfm__new-domain', $this),
                newValue = input.val();
            if (!newValue) {
                alert(iget('Введите новый домен'));
                return;
            }

            if (!direct.utils.validateHref(newValue)) {
                alert(iget('Введенный Вами URL не работает'));
                return;
            }



            iModelsManager.eachModel(function(i, m) {
                if (!m.get('with_href')){
                    return true;
                }
                m.update({domain: newValue , with_href: true }, $this, 1);
            }, 'campaign&banner:*', modelsName);


            input.val('');
            wholeCampCheckbox && $('#camp_banners_domain').val(wholeCampCheckbox.isChecked() ? newValue : '');

            popupa.hide();
        }

        function updateHref () {
            var inputFrom = $('.b-bfm__href-from', $this),
                inputTo = $('.b-bfm__href-to', $this),
                hrefFrom = inputFrom.val(),
                hrefTo = inputTo.val(),
                hrefSafe = hrefFrom.replace(/([^a-zА-Я0-9])/gi, "\\$1"),
                regexp = new RegExp( hrefSafe, 'gi'),
                updateDomain = $('.b-bfm__update-domain', $this).prop('checked') || !$('.b-bfm__update-domain', $this).length,
                updateSitelinks = $('.b-bfm__update-sitelinks', $this).prop('checked');

            if (!hrefFrom) {
                alert(iget('Введите строку для поиска'));
                return;
            }

            var replaced = [];
            iModelsManager.eachModel(function(id, m) {
                var hrefModel = m.getChildModel('b-banner-form-href'),
                    sitelinksModel = m.getChildModel('b-banner-sitelinks');
                if (m.get('with_href') && hrefModel.get('href').match(/\S/) && hrefModel.get('href').match(regexp)) {
                    replaced.push(
                        hrefModel.get('href').replace(regexp, hrefTo)
                    );
                }
                if (updateSitelinks && m.get('with_sitelinks')) {

                    for (var i = 0; i < SITELINKS_NUMBER; i++) {
                        if (sitelinksModel.get('href' + i).match(/\S/) && sitelinksModel.get('href' + i).match(regexp)) {
                            replaced.push(
                                sitelinksModel.get('href' + i).replace(regexp, hrefTo)
                            );
                        }
                    }
                }
            }, 'campaign&banner:*', modelsName);

            var invalidDomains = [];
            if (!replaced.length) {
                alert(iget('Не найден фрагмент для замены.'));
                return;
            }

            replaced && replaced.length && $.each(replaced, function(i, r) {
                if (!direct.utils.validateHref(r)) { invalidDomains.push(r); }
            });

            if (invalidDomains.length > 0) {
                if (
                    !confirm(iget('После изменения следующие ссылки не будут работать') + ': ' + invalidDomains.join(', ') + '.\n' + iget('Продолжить?'))
                ) return;
            }


            var domain = updateDomain ? direct.utils.extractDomain(replaced[0]) : undefined;

            iModelsManager.eachModel(function(id, m) {
                if (!m.get('with_href')) return true;

                var hrefModel = m.getChildModel('b-banner-form-href'),
                    sitelinksModel = m.getChildModel('b-banner-sitelinks');

                m.update({
                    href: hrefModel.get('href').replace(regexp, hrefTo),
                    domain: domain,
                    with_href: true
                }, $this, 1);

                if (updateSitelinks && m.get('with_sitelinks')) {

                    var update = {};
                    for (var i=0; i < SITELINKS_NUMBER; i++) {
                        if (sitelinksModel.get('href' + i).match(/\S/)) {
                            update['href' + i] = sitelinksModel.get('href' + i).replace(regexp, hrefTo);
                        }
                    };
                    sitelinksModel.update(update);
                }
            }, 'campaign&banner:*', modelsName);

            inputFrom.val('');
            inputTo.val('');
            popupa.hide();
        }


        function updateText () {
            var inputFrom = $('.b-bfm__text-from', $this),
                inputTo = $('.b-bfm__text-to', $this),
                textFrom = inputFrom.val(),
                textTo = inputTo.val(),
                textSafe = textFrom.replace(/([^a-zА-Я0-9\s])/gi, "\\$1").replace(/\s/gi, '\\s'),
                regexp = new RegExp( textSafe, 'gi');

            if (!textFrom) {
                alert(iget('Введите строку для поиска'));
                return;
            }
            var isTextChanged = false;
            iModelsManager.eachModel(function(id, m) {
                if (!isTextChanged && (regexp.test(m.get('body') || '') || regexp.test(m.get('title') || '') || regexp.test(m.get('title_extension') || ''))){
                    isTextChanged = true;
                }

                m.update( {
                    title: (m.get('title') || '').replace(regexp, textTo),
                    title_extension: (m.get('title_extension') || '').replace(regexp, textTo),
                    body: (m.get('body') || '').replace(regexp, textTo)
                }, 'multiedit');
            }, 'campaign&banner:*', modelsName);


            if (isTextChanged){
                inputFrom.val('');
                inputTo.val('');
                popupa.hide();
            } else {
                alert(iget("Не найден фрагмент для замены."));
            }
        }


        function addMinusWords () {
            var newMinusWordInput = $('.b-bfm__add-minus-words', $this),
                newMinusWord = newMinusWordInput.val().split('\r').join(' ');

            if (!newMinusWord) {
                alert(iget('Введите минус слова'));
                return;
            }

            var errors = {
                spaceFlag: 0
            };

            var newPhrasesTmp = getNewMinusWordsArray(newMinusWord);

            if (banners_array && phrases) {
                //для мультиредактирования
                for (var i = 0; i < banners_array.length; i++) {
                    var phrs = phrases[banners_array[i]];

                    for(var k = 0; k < phrs.length; k++){
                        var field = $('[name = ph-' + banners_array[i] + '_' + phrs[k] + ']');
                        var newPhrases = processMinusWord(field.val(), newPhrasesTmp, errors);
                        if(newPhrases.length){
                            //ко фразам с кавычками минус-слова не вставляем
                            if (!field.val().match(/["']/)) field.val(field.val() + ' -' + newPhrases.join(' -'));
                        }
                    }

                }

            } else {
                iModelsManager.eachModel(function(id, m) {
                    m.onFirst('split-phrases-loaded', function() {
                        iModelsManager.eachModel(function(id, model) {
                            var phrase = model.get('phrase'),
                                newPhrases = processMinusWord(phrase, newPhrasesTmp, errors);
                                if(newPhrases.length){
                                    //ко фразам с кавычками минус-слова не вставляем
                                    if (!phrase.match(/["']/)) model.set('phrase', phrase + ' -' + newPhrases.join(' -'));
                                }
                           }, 'campaign&banner:' + m.get('bid') + '&type:*&phrase:*', 'b-mediaplan-form-phrase-splited')
                    }, this, { one : true });
                    m.trigger('split-phrases');
                }, 'campaign&banner:*', 'b-banner-edit');
            }

            if (errors.spaceFlag){
                alert(iget('Минус-слова не могут состоять из нескольких слов!'));
            } else if (errors.deprecatedWordsHash) {
                var errorText = iget('Нельзя вычитать слова, содержащиеся в исходной ключевой фразе. Например, нельзя вычитать слово "кино", содержащиеся в исходной ключевой фразе "билет в кино"');
                for (var phrase in errors.deprecatedWordsHash) {
                    errorText += "\n";
                    errorText += iget('Минус-слово "%s" есть в следующих ключевых фразах "%s"', phrase, errors.deprecatedWordsHash[phrase].join(', '));
                }
                alert(errorText);
            } else {
                popupa.hide();
                newMinusWordInput.val('');
            }
        }

        function addSitelinks () {
            if (sitelinks_model.isModelEmpty()) {
                if (!confirm(iget('Быстрые ссылки будут удалены на всех баннерах'))) return;

            }

            var update = {
                with_sitelinks: true,
                sitelinks: {}
            };

            for (var i=0; i < SITELINKS_NUMBER; i++) {
                if (sitelinks_model.get('title' + i) != '*') {
                    update.sitelinks['title' + i] = sitelinks_model.get('title' + i);
                }
                if (sitelinks_model.get('href' + i) != '*') {
                    update.sitelinks['href' + i] = sitelinks_model.get('href' + i);
                }
                if (sitelinks_model.get('urlProtocol' + i) != '*') {
                    update.sitelinks['urlProtocol' + i] = sitelinks_model.get('urlProtocol' + i);
                }
                if (sitelinks_model.get('description' + i) != '*') {
                    update.sitelinks['description' + i] = sitelinks_model.get('description' + i);
                }
            }

            iModelsManager.eachModel(function(id, m) {
                m.update(update, 'multiedit', 1);
            }, 'campaign&banner:*', 'b-banner-edit');

            sitelinks_model.fixData();
            popupa.hide();
        }



        function processMinusWord(oldPhrasesString, newPhrasesTmp, errors) {
            var newPhrases = [],
                oldPhrasesArrWithMinus = clearMinusWordsArray(oldPhrasesString.split(' -')),
                oldPhrasesArr = oldPhrasesArrWithMinus[0].split(' ');

            for (var j = 0; j < newPhrasesTmp.length; j++) {
                var str = newPhrasesTmp[j];

                if (str.indexOf(' ') > -1) {
                    errors.spaceFlag = 1;
                }

                if (oldPhrasesArr.indexOf(str) != -1 && (!errors.deprecatedWordsHash || !errors.deprecatedWordsHash[str] || $.inArray(oldPhrasesString, errors.deprecatedWordsHash[str]))) {
                    if (!errors.deprecatedWordsHash) {
                        errors.deprecatedWordsHash = {};
                    }

                    if (!errors.deprecatedWordsHash[str]) {
                        errors.deprecatedWordsHash[str] = [];
                    }

                    errors.deprecatedWordsHash[str].push(oldPhrasesString);

                } else if (oldPhrasesArr.indexOf(str) == -1 && str.indexOf(' ') < 0 && str != '') {
                    newPhrases.push(str);
                }
            }

            return newPhrases;
        }

        function getNewMinusWordsArray(newMinusWord) {
            var newPhrasesT =
                    newMinusWord.indexOf(',') > 0 ?
                    newMinusWord.split(',') :
                    newMinusWord.split(/\s+/);

            return clearMinusWordsArray(newPhrasesT);
        }

        function clearMinusWordsArray(array) {
            return $.map(array, function(w) { if (w) return $.trim(w.toLowerCase()).replace(/^-/, ''); });
        }

    };

})(jQuery, window.Lego);
