(function($, Lego) {

Lego.block['b-banner-form__preview'] = function(params) {
    var $this = $(this),
        model2 = BEM.blocks['i-models-manager'].get(params.modelPath, 'b-banner-edit'),
        hrefDefaultValue = params.href_default_value,
        titleDefaultValue = params.title_default_value,
        bodyDefaultValue = params.body_default_value,
        title = $this.find('.title-link'),
        body  = $this.find('.body'),
        url  = $this.find('.url-container'),
        address  = $this.find('.address-container'),
        domainWarning = $this.find('.domain-warning'),
        formatWarning = $this.find('.format-warning'),
        ukranianWarning = $this.find('.ukranian-warning'),
        lengthWarning = $this.find('.length-warning'),
        kazakhWarning = $this.find('.kazakh-warning');

    updateUrlWarnings();
    updateLangHint();
    updateTitle();
    updateBody();
    updateHref();

    model2
        .onField('title', 'change', updateTitle)
        .onField('body', 'change', updateBody)
        .onField('with_href', 'change', updateUrlWarnings)
        .onField('with_ci', 'change', onAddressBlockVisibilityChanging)
        .getChildModel('b-banner-form-href')
            .on('change', updateHref);




    function getPreparedString(string) {
        string = string || '';
        return string.replace(/[\s\xA0]{2,}/g, " ");
    }


    function onAddressBlockVisibilityChanging() {
        address.toggleClass('g-hidden', !model2.get('with_ci'))
    }

    function updateTitle() {
        setFormatedText(title, model2.get('title') || titleDefaultValue);
        updateLangHint()
    }

    function updateBody() {
        setFormatedText(body, model2.get('body') || bodyDefaultValue);
        updateLangHint()
    }

    function updateHref() {
        var hrefModel = model2.getChildModel('b-banner-form-href'),
            text = hrefModel.get('domain') || hrefModel.get('domain_input') || hrefModel.get('href') || hrefDefaultValue;
        
        if (text.length > 35) {
            text = '...' + text.substr(text.length - 35, text.length)
        }
        setFormatedText(url, text);
        updateUrlWarnings();
    }

    function setFormatedText(container, text) {
        if (text.length > 25) {
            text = getFormatedText(text)
            container.html(text);
        } else {
            container.text(text);
        }
    }

    function getFormatedText(text) {
        var chunkSize = 25,
        parts = text.replace(/([\s\.\-\/])/g, "$1\u0001").split('\u0001'),
        splitParts = [], i, l, part, tmp;

        text = getPreparedString(text);
        
        for (i=0, l = parts.length; i < l; i++) {
            part = parts[i];
            while(part.length > chunkSize) {
                tmp = Math.min(chunkSize, part.length / 2);
                splitParts.push(part.substring(0, tmp));
                part = part.substring(tmp);
            }
            splitParts.push(part);
        }
        splitParts = $.map(splitParts, function(n){
            return direct.utils.escapeHTML(n);
        });
        return splitParts.join('<wbr />');
    }

    function updateLangHint() {
        var text = title.val() + body.val();
        var lang = textLang(text);
        if (ukranianWarning) {
            ukranianWarning.toggleClass('g-hidden', lang != 'uk');
        }

		if (kazakhWarning) {
            kazakhWarning.toggleClass('g-hidden', lang != 'kk');
        }
    }

    function textLang(text) {
        // perl -ME -e 'print join ", ", map {ord($_)} split //, $Settings::KAZ_LETTERS;'
        if (text.match('[' + String.fromCharCode(1200, 1170, 1171, 1256, 1186, 1178, 1210, 1198, 1201, 1257, 1187, 1179, 1211, 1199, 1174, 1202, 1203, 1175, 1240, 1241) + ']')) {
            return 'kk';
        } else if (text.match('[' + String.fromCharCode(1028, 1030, 1031, 1108, 1110, 1111, 1168, 1169) + ']')) {
            return 'uk';
        } else {
            return '';
        }
    }

    function compareDomains(domain_calc, domain) {
        if (!domain_calc || !domain) return false;
        var re = /(www\.)?(.*)/
        var extractedDomainCalc = domain_calc.match(re)[2];
        var extractedDomain = domain.match(re)[2];
        return (extractedDomainCalc == extractedDomain)
    }


    function updateUrlWarnings() {
        var hrefModel = model2.getChildModel('b-banner-form-href'),
            href = hrefModel.get('href'),
            hrefDomainCalc = hrefModel.get('domain_calc'),
            domain_calc = hrefDomainCalc ? hrefDomainCalc : direct.utils.extractDomain(href),
            domain = hrefModel.get('domain'),
            hideDomainWarning = domain ? (compareDomains(domain_calc, domain) || (hrefModel.get('domain_ascii') != '' && compareDomains(hrefModel.get('domain_ascii'), domain_calc))) : true,
            hideFormatWarning = domain ? direct.utils.validateHref(domain) != null : true,
            withHref = model2.get('with_href');

        formatWarning.toggleClass('g-hidden', hideFormatWarning || !withHref);
        domainWarning.toggleClass('g-hidden', hideDomainWarning || !withHref);
        
        var text = domain || hrefModel.get('domain_input') || href || hrefDefaultValue;
        lengthWarning.toggleClass('g-hidden', text.length <= 35 || !withHref);
        url.toggleClass('g-hidden', !withHref)
    }
};
})(jQuery, window.Lego);
