(function($, Lego) {

Lego.block['b-banner-form__text'] = function(params) {
    var $this = $(this),
        model = BEM.blocks['i-models-manager'].get(params.modelPath, 'b-banner-edit'),
        fieldName =  params.fieldName,
        textField = $this.find('.b-banner-form__text__'+ fieldName + ''),
        textFieldPretty = $this.find('.b-banner-form__text__'+ fieldName + '_pretty'),
        counter = $('.b-input-counter__counter', $this),
        limit = params.limit || 0,
        updating = false;

    textField.bind('keyup', function() {
        model.set(fieldName, prettify(textField.val()), 'keyup');
    });

    textField.bind('blur', function() {
        var a = prettify(textField.val()).replace(/[<>]/g, ''); // Старая логика из b-spell-checker.js
        textField.val(a);
        textField.trigger('custom-change');
        model.set(fieldName, a, 'blur');
    });

    model
        .onField(fieldName, 'change', updateView)
        .onInitData(updateView);

    textField.trigger('change'); // при инициализации тригерим change ( DIRECT-12357 )


    function updateView(e, source) {
        var text = model.get(fieldName),
            narrowSymbolsRegExp = new RegExp('([' + NARROW_SYMBOLS + '])', 'g'),
            strWithoutNarrowLength = text.replace(/\#([^\#]*?)\#/g, '$1').replace(narrowSymbolsRegExp, '').length;

        if (source == 'blur' || source == 'multiedit' || source == 'copy_global')  {
            textField.val(text);
        }

        textFieldPretty.val(text);
        counter
            .html(limit - strWithoutNarrowLength)
            .toggleClass('b-input-counter__counter_overflow_yes', limit < strWithoutNarrowLength);

        textField.trigger('change');
    }

    function prettify(text) {
        // проверка на укр. буквы
        if (/[\u0404\u0406\u0407\u0454\u0456\u0457\u0490\u0491]/.test(text)) return text;

        var rusLetters = '\u0430-\u043F\u0440-\u044F\u0410-\u042F\u0451\u0401',
            rusLatLetters = 'a-zA-Z' + rusLetters,
            dashRegexp = new RegExp( '([' + rusLatLetters + ']) \- ([' + rusLatLetters + '])', 'g'),
            // [Аа]|[Бб]ез|[Вв](?:|ы|ас|ам|се|сё)|[Гг]де|[Дд](?:о|ля)|[Зз]а|[Ии](?:|з)|[Кк](?:|о|ак)|[Мм]ы|[Нн](?:а|ам|ас|е|и|о)|[Оо](?:|б|т)|[Пп](?:о|ро)|[Сс](?:|о)|[Тт](?:о|ут|ы)|[Уу]|[Чч]то|[Ээ]то
            rusParts = '[\u0410\u0430]|[\u0411\u0431]\u0435\u0437|[\u0412\u0432](?:|\u044B|\u0430\u0441|\u0430\u043C|\u0441\u0435|\u0441\u0451)|[\u0413\u0433]\u0434\u0435|[\u0414\u0434](?:\u043E|\u043B\u044F)|[\u0417\u0437]\u0430|[\u0418\u0438](?:|\u0437)|[\u041A\u043A](?:|\u043E|\u0430\u043A)|[\u041C\u043C]\u044B|[\u041D\u043D](?:\u0430|\u0430\u043C|\u0430\u0441|\u0435|\u0438|\u043E)|[\u041E\u043E](?:|\u0431|\u0442)|[\u041F\u043F](?:\u043E|\u0440\u043E)|[\u0421\u0441](?:|\u043E)|[\u0422\u0442](?:\u043E|\u0443\u0442|\u044B)|[\u0423\u0443]|[\u0427\u0447]\u0442\u043E|[\u042D\u044D]\u0442\u043E',
            nbsp = '\u00A0',
            dash = '\u2013'; // &ndash;, если надо &mdash;, то будет \u2014

        return text
            // больше одного пробела подряд
            .replace(/([\s\u00A0]){2,}/g, '$1')
            // убираем висячие короткие союзы/частицы (склеиваем через nbsp)
            .replace(new RegExp('(^|\\(|\\s)(' + rusParts + ')\\s([\u00AB"$\\d' + rusLatLetters + '])', 'g'), '$1$2' + nbsp + '$3')
            // убираем пробелы перед некоторыми знаками препинания
            .replace(/[\s\u00A0]+([.,!?])/g, '$1')
            // заменяем на ndash, потому что mdash обычно слишком широкий
            .replace(dashRegexp, '$1' + nbsp + dash + ' $2')
            // заменяем в инфе о скидках вида:
            //    Скидка -50%
            // дефис на нормальный минус (критично в шрифтах типа Arial)
            .replace(/ \-(\d\d?)%/g, ' \u2212$1%')
            // висячие слова в конце объявления длиной 1-2 символа склеиваем с основной строкой
            .replace(/ ([^\s]{1,2})$/, nbsp + '$1')
            // неразрываемый пробел в годах, вида 2012 г.
            .replace(/(19\d\d|20[012]\d)[\s\u00A0]*(\u0433\.?)/g, '$1' + nbsp + '$2')
            // неразрываемый пробел в ценах в рублях, вида 5 000 руб
            .replace(/(\d+ (\d{3} ){0,2})\u0440\u0443\u0431([.,?!:;\s]|$)/g, function(str, p1, p2, p3) {
                return p1.replace(/ /g, nbsp) + '\u0440\u0443\u0431' + p3;
            });
    }

};
})(jQuery, window.Lego);
