


include('jquery.color.js');
include('jquery.Jcrop.js');

BEM.DOM.decl(
    'b-banner-pic',
    {
        onSetMod: {
            js: function() {
                var _this = this;
                _this.models = BEM.blocks['i-models-manager'].getGroup(_this.params.modelsPath, 'b-banner-edit');
                this._ulogin = this.params.ulogin;
                $.each(_this.models, function(i, model) {
                    model
                        .on('change reset init', _this._onModelExternalChange, _this);
                });

                _this._gallery = _this.params.gallery || [];

                // сколько картинок показываем в 1 секции Галереи?
                _this._picsPerGallery = _this.elem('piclist-cell').size();
                _this.bindTo('piclist-frame', 'click', function(e) {
                    var $frame = $(e.currentTarget);

                    if ($frame.attr('data-gallery-id') === '') return true;

                    _this
                        .delMod(_this.elem('piclist-frame'), 'selected')
                        .setMod($frame, 'selected', 'yes');
                });

                // обработка галереи
                _this
                    ._showGallerySection(0)
                    ._disableButtons({gallery: !(_this._gallery.length > 0)})
                    .setMod(_this.elem('gallery-btns'), 'visible', _this._gallery.length > _this._picsPerGallery ? 'yes' : 'no');

                // источник картинки
                _this
                    .channel('b-banner-pic')
                    .on('picsource-updated', function(e, data) {
                        _this._updatePicSource(data.picSource);
                    });

                // превьюшка баннера
                _this._preview = _this.findBlockInside({
                    blockName: 'b-banner-preview',
                    modName: 'type',
                    modVal: 'image'
                });

                // контрол выбора картинки для загрузки
                // при использовании загрузки через iframe он клонируется и пропадает из формы, поэтому нельзя
                // постоянно использовать .elem('file-input-element'), проще иметь отдельную ссылку, которую надо
                // обновлять по необходимости (после клонирования)
                _this._$fileInput = _this.elem('file-input-element');
                // нам не нужно подхватывать изначальное значение картинки, если мы работаем в режиме мультизамены
                if (! _this.hasMod('multi', 'yes')) {
                    _this._imageId = _this.elem('result').val();
                    _this._imageName = _this.elem('result-name').val();
                }

                _this._popupa = _this.findBlockOutside('b-popupa');
                BEM.blocks['b-popupa'].on('showPopup', function(e, source) {
                    if (source !== _this) {
                        _this._popupa.hide();
                    }
                });

                _this._popupa.on('outside-click', function(e) {
                    e.preventDefault();
                });

                if (_this.elem('switcher').size() > 0) {
                    _this._switcher = _this.findBlockOn(_this.elem('switcher'), 'b-form-button')
                        .on('click', function() {
                            BEM.blocks['b-popupa'].trigger('showPopup', _this);
                            if (_this._popupa.isShowed()) {
                                _this._popupa.hide();
                            } else {
                                _this._popupa.show(_this.elem('switcher'));
                            }
                        }, this);
                }

                _this
                    .setMod('editor', 'init')
                    .setMod('html5', (_this._$fileInput.get(0).files && window.FormData) ? 'yes' : 'no')
                    //.setMod('html5', 'no')
                    .bindTo('action', 'click', function(e) {
                        var buttonBEM = $(e.currentTarget).bem('b-form-button');
                        if (buttonBEM.hasMod('disabled', 'yes')) return true;

                        _this._doAction(_this.getMod($(e.currentTarget), 'type'));  // all links and buttons will be handled by this helper func
                    })
                    .bindToDomElem(_this.elem('url-input'), 'keypress', function(e) {
                        if (e.keyCode == 13) {
                            _this._fetchURL();
                        }
                    });
            },

            editor: {
                init: function() {
                    var _this = this;
                    _this
                        ._updateImg(_this._imageId, _this._imageName)
                        .delMod('editor')
                        .delMod('from')
                        .setMod('interactive', 'yes')
                        ._setThumb(_this._imageId)
                        ._killAsync()
                        ._hideErrors();

                    // чистим файловое поле
                    // в Opera 12 не работает :-(
                    _this._cleanupFileInput();
                    _this.elem('url-input').val('');

                    // этот хак решает проблему, при которой картинка таинственно появляется в IE независимо от стилей
                    _this._jcropAPI && _this._jcropAPI.destroy();
                    _this.findElem('userimg').css('display', 'none');
                },
                file: function() {
                    var _this = this;

                    _this._cleanupFileInput();

                    _this
                        ._hideErrors()
                        ._disableButtons({back: false, save: true, cancel: false});

                    if (_this._initByClick && _this.hasMod('html5', 'yes')) {
                        _this._initByClick = false;
                        // File API allows a file input to be hidden
                        // and activated with .click()
                        try {
                            _this._$fileInput
                                .get(0)
                                .click();
                        } catch(err) {}
                    }

                    _this._pollingTimeout = setTimeout(function() {
                        if (_this._$fileInput.val() != '') {
                            var success = _this._startFileUpload();
                            if (!success) {
                                _this._pollingTimeout = setTimeout(arguments.callee, 1000);
                            }
                        } else {
                            _this._pollingTimeout = setTimeout(arguments.callee, 1000);
                        }
                    }, 1000);
                },
                url: function() {
                    var _this = this;
                    _this
                        ._hideErrors()
                        ._disableButtons({back: false, save: true, cancel: false});
                },
                gallery: function() {
                    var _this = this;

                    _this
                        .delMod(_this.elem('piclist-frame'), 'selected')
                        ._disableButtons({back: false, save: true, cancel: false});
                },
                loading: function() {
                    var _this = this;

                    _this
                        .setMod('interactive', 'no')
                        ._imgUpload()
                        ._disableButtons({back: false, save: true, cancel: false});
                },
                loaded: function() {
                    var _this = this;

                    _this
                        ._jcropInit()
                        ._disableButtons({back: false, save: false, cancel: false});

                    _this.elem('canvas').css('margin-top', _this._previewHeight < 150 ? Math.floor((_this.elem('box').height() - _this._previewHeight) / 2) : 0);

                    // включение интерактивного режима делается в callback'е инициализации jcrop,
                    // а если делать здесь, то оно надёжнее, но сначала включится интерактивный режим,
                    // и только потом загрузится картинка
                    // _this.setMod('interactive', 'yes');
                },
                '*': function(modName, modVal) {
                    if (modVal !== 'file') {
                        var _this = this;

                        clearTimeout(_this._pollingTimeout);
                    }
                }
            },

            interactive: function(modName, modVal) {
                if (modVal === 'no') {
                    this.elem('paranja').show();
                } else {
                    this.elem('paranja').hide();
                }
            }
        },

        onElemSetMod: {
            'piclist-frame' : {
                selected: {
                    yes: function($elem) {
                        var _this = this,
                            id = parseInt($elem.attr('data-gallery-id'), 10);

                        if (!isNaN(id) && _this._gallery[id]) {
                            _this
                                ._setThumb(_this._gallery[id].image)
                                ._disableButtons({save: false});
                        } else {
                            _this
                                ._setThumb('')
                                ._disableButtons({save: true});
                        }
                    }
                }
            }
        },

        _xhr: null,
        _killIFrame: function() {return this},
        _$fileInput: null,
        _jcropAPI: null,
        _gallery: [],
        _postParams: {},
        _maxFileSize: 10 * 1024 * 1024,  // bytes
        _previewId: '',
        _picsPerGallery: 0, // сколько картинок в 1 секции Галереи
        _currentGallerySection: 0, // текущая секция Галереи
        _uploadId: '',  // идентификатор загруженного файла, для сервера
        _imageId: '',  // изначально прописанный id картинки (при загрузке страницы)
        _imageName: '', // имя картинки или её url
        _previewWidth: 0,  // ширина уменьшенной картинки для редактора
        _previewHeight: 0,  // её высота
        _origWidth: 0,  // исходная ширина картинки
        _origHeight: 0,  // исходная высота
        _picWidth: 90, // до какой высоты обрезать картинку
        _picHeight: 90, // до какой ширины
        _crop: [],  // x1, x2, y1, y2 вырезанной картинки
        _sizeValidationStatus: true,
        _minSizeValidationStatus: true,
        _pollingTimeout: null,
        _fileUploadTimeout: 180000,



        _updateModels: function(imageId, imageName, picSource) {
            var _this = this;

            if (_this.hasMod('multi', 'yes')) {
                _this
                    .channel('b-banner-pic')
                    .trigger('picsource-updated', {picSource: picSource});
            } else {
                _this._updatePicSource(picSource);
            }

            $.each(_this.models, function(i, m) {
                m.update({
                    image: imageId,
                    image_name: imageName
                }, _this);
            });

            return _this;

        },
        
        _onModelExternalChange: function(e, data) {
            if (e.type == 'change' && (!data.changed || $.inArray('image', data.changed) == -1)) return;
            // если это событие инициировали не мы сами, т.е. не текущий блок
            if (data.source && data.source !== this) {
                if (!this.hasMod('multi', 'yes')) {
                    this._imageId = this.models[0].get('image');
                    this._imageName = this.models[0].get('image_name');
                } else {
                    this._imageId = '';
                    this._imageName = '';
                }
                this
                    .setMod('editor', 'dummy')
                    .setMod('editor', 'init');
            }
        },

        _cleanupFileInput: function() {
            var _this = this;

            _this._$fileInput.val('');

            if (_this._$fileInput.val() !== '') {
                var $newInput = $('<input type="file" />');

                $newInput.name = _this._$fileInput.attr('name');
                $newInput.className = _this._$fileInput.className;
                _this._$fileInput
                    .hide()
                    .before($newInput)
                    .remove();

                _this._$fileInput = $newInput;
            }
        },

        _updatePicSource: function(picSource) {
            var _this = this;
            _this.elem('source').val(picSource || '');
            if (picSource === 'url') {
                _this.elem('img-source-url').val(_this.elem('url-input').val());
            } else {
                _this.elem('img-source-url').val('');
            }

            return _this;
        },

        _showError: function(errname, txt) {
            var _this = this;

            _this.setMod('interactive', 'yes');

            if (errname === 'textual') {
                if (txt) {
                    _this.elem('err', 'type', 'textual').text(txt);

                    _this
                        .setMod(_this.elem('err', 'type', errname), 'visible', 'yes')
                        .setMod(_this.elem('errcontainer'), 'visible', 'yes');
                }
            } else {
                _this
                    .setMod(_this.elem('err', 'type', errname), 'visible', 'yes')
                    .setMod(_this.elem('errcontainer'), 'visible', 'yes');
            }

            return _this;
        },

        _hideErrors: function() {
            var _this = this;

            // TODO: хак про отображение текстовых ошибок
            _this
                .elem('err', 'type', 'textual')
                .html('');
            // end hack

            return _this
                .delMod(_this.elem('scale-err'), 'show')
                .delMod(_this.elem('size-err'), 'show')  // нестандартная ошибка
                .delMod(_this.elem('err'), 'visible')
                .delMod(_this.elem('errcontainer'), 'visible');
        },

        _updateImg: function(imageId, imageName) {
            var _this = this,
                imgExists = !!imageId;

            _this._imageId =   imgExists? imageId   : '';
            _this._imageName = imgExists? imageName : '';  // если imageId пуст, надо сбросить imgName

            _this.setMod('img', imgExists? 'yes' : 'no');

            _this.elem('result').val(_this._imageId);
            _this._switcher && _this._switcher.elem('text').text(imgExists? iget('изменить') : iget('добавить'));
            _this.elem('imagename').text(direct.utils.hellipCut((_this._imageName || '').split('').reverse().join(''), 47).split('').reverse().join(''));
            _this.elem('imagename').attr('title', _this._imageName);
            _this.elem('result-name').val(_this._imageName);
            _this._setThumb(_this._imageId);

            if (! imgExists) {
                // обнуляем файловый инпут
                _this._cleanupFileInput();
                // обнуляем поле ввода урла
                _this.elem('url-input').val('');
            }

            if (_this.hasMod('multi', 'yes')) {
                var withImage = 0,
                    totalNum = 0;

                $.each(_this.models, function(i, m) {
                    totalNum++;
                    m.get('image') && withImage++;
                });



                if (withImage == 0) {
                    _this.elem('action', 'type', 'multidel').bem('b-form-button').setMod('disabled', 'yes');
                    _this.elem('header-howmany').hide();
                } else {
                    _this.elem('action', 'type', 'multidel').bem('b-form-button').delMod('disabled');
                    _this
                        .elem('header-howmany')
                        .show()
                        .text(common.inflector.pluralForms(iget("%s из %s {объявления|объявлений|объявлений} {имеет|имеют|имеют} изображение", withImage, totalNum), totalNum, withImage));
                }
            } else {
                // обновляем модель, но для замены в мультиредактировании у нас в этом месте используется модель первого
                // по счёту баннера, поэтому обновлять её не нужно
                $.each(_this.models, function(i, m) {
                    m.update({image: imageId, image_name: imageName}, _this);
                });
            }

            return _this;
        },

        _disableButtons: function(btns) {
            var _this = this;

            for (var el in btns) {
                _this.elem('action', 'type', el).each(function() {
                    var btnBlock = _this.findBlockOn($(this), 'b-form-button');
                    !!btns[el] ? btnBlock.setMod('disabled', 'yes') : btnBlock.delMod('disabled');
                });
            }

            return _this;
        },

        _doAction: function(type) {
            var _this = this;

            switch(type) {
                case 'back':
                    // любое нажатие кнопки Назад останавливает любой запрос, висящий в фоне
                    _this._killAsync();
                    switch (_this.getMod('editor')) {
                        case 'file':
                        case 'url':
                        case 'gallery':
                            _this.setMod('editor', 'init');
                            break;

                        case 'loaded':
                            _this
                                ._updateImg(_this._imageId, _this._imageName)
                                .setMod('editor', _this.getMod('from') || 'file');

                            _this._cleanupFileInput();
                            break;
                    }

                    break;

                case 'local':
                    _this._initByClick = true;
                    _this.setMod('editor', 'file');
                    break;

                case 'www':
                    _this.setMod('editor', 'url');
                    break;

                case 'gallery':
                    _this.setMod('editor', 'gallery');
                    break;

                case 'gallery-back':
                case 'gallery-fwd':
                    _this
                        .delMod(_this.elem('piclist-frame'), 'selected')
                        ._setThumb('')
                        ._disableButtons({save: true})
                        ._showGallerySection(_this._currentGallerySection + (type == 'gallery-fwd' ? 1 : -1));
                    break;

                case 'fetch-url':
                    _this._fetchURL();
                    break;

                case 'cancel':
                    _this.setMod('editor', 'init');
                    _this._popupa.hide();
                    break;

                case 'save':
                    switch (_this.getMod('editor')) {
                        case 'loaded':
                            _this._preview.elem('image')
                                .css({
                                    display: 'inline',
                                    position: 'static',  // важно сбросить: динамическая превьюшка работает с position!
                                    width: '',
                                    height: ''
                                });
                            _this._saveCrop();
                            break;

                        case 'gallery':
                            var galleryIndex = parseInt(_this.findElem('piclist-frame', 'selected', 'yes').attr('data-gallery-id'), 10);

                            if (!isNaN(galleryIndex)) {
                                _this._imageId = _this._gallery[galleryIndex].image;
                                _this._imageName = _this._gallery[galleryIndex].name;

                                _this._updateModels(_this._imageId, _this._imageName, 'gallery')  // для мультиредактирования
                                    .setMod('editor', 'init');

                                _this._popupa.hide();
                            }
                            break;
                    }
                    break;

                case 'remove':
                    _this._updateImg('', '');
                    // возможно, надо чистить что-то ещё
                    _this._crop = [];
                    break;

                case 'multidel':
                    _this.hasMod('multi', 'yes') && _this.channel('b-banner-pic').trigger('picsource-updated', {picSource: null});
                    _this._updateModels('', '')
                        ._updateImg('', '')
                        .setMod('editor', 'init');
                    break;
            }
        },

        _makeThumbURL: function(id) { return id === '' ? '' : '/images/'+ id +'/x' + this._picWidth },
        _makePreviewURL: function(id) { return id === '' ? '' : '/image-files/?type=banner_images_uploads&image=' + id },

        _getImgRef: function() {
            var f = this._$fileInput.get(0);
            return (f && f.files) ? (f.files[0] || null) : null;
        },

        _setThumb: function(src) {
            var _this = this;

            _this._preview && _this._preview._setThumb(src);

            _this.elem('existing')
                .attr('src', _this._makeThumbURL(src));

            return _this;
        },

        _validateSelectionSize: function() {
            var _this = this;

            if (_this._jcropAPI) {
                var sel = _this._jcropAPI.tellSelect(),
                    scale = 4/3,
                    w = sel.x2 - sel.x,
                    h = sel.y2 - sel.y,
                    scaleError = false,
                    sizeError = false;

                scaleError = (h > 0 && w > 0 && ((h / w) > scale || (w / h) > scale));

                if (scaleError) {
                    return {
                        error: true,
                        type: 'scale'
                    }
                }

                sizeError = !(h >= 150 && w >= 150);

                if (sizeError) {
                    return {
                        error: true,
                        type: 'size'
                    }
                }
            }

            return {
                error: false
            };
        },

        _killAsync: function() {
            var _this = this;

            _this._xhr && _this._xhr.readyState != 4 && _this._xhr.abort && _this._xhr.abort();
            _this
                ._killIFrame()
                ._setPostParams();

            return _this;
        },

        _jcropInit: function() {
            var _this = this,
                selSide = Math.min(_this._previewWidth, _this._previewHeight),
                selCoords = [
                    (_this._previewWidth - selSide) / 2,
                    (_this._previewHeight - selSide) / 2,
                    (_this._previewWidth - selSide) / 2 + selSide,
                    (_this._previewHeight - selSide) / 2 + selSide
                ],
                onSelectionUpdate = function(coords) {
                    if (coords.w == 0 && coords.h == 0) {
                        return false;
                    }

                    var check = _this._validateSelectionSize();

                    _this._sizeValidationStatus = !check.error;

                    _this
                        .delMod(_this.elem('scale-err'), 'show')
                        .delMod(_this.elem('size-err'), 'show');

                    if (!check.error) {
                        _this._disableButtons({ save: false });
                    } else {
                        _this._disableButtons({save: true})
                            .setMod(_this.elem(check.type + '-err'), 'show', 'yes');
                    }

                    _this
                        ._showPreview(coords)
                        ._saveCoords(coords);
                };

            // используем findElem, т.к. плагин jCrop активно работает с DOM и кеширование опасно
            _this
                .findElem('userimg')
                .css('display', 'block')  // чтоб не прыгала картинка, иначе в процессе .show() в плагине ставит display:inline и к нему снизу -- отступ, и layout прыгает
                .css('visibility', 'hidden')
                .attr('src', _this._makePreviewURL(_this._previewId))
                .attr('width', _this._previewWidth)
                .attr('height', _this._previewHeight);

            _this._jcropAPI && _this._jcropAPI.destroy();

            _this._preview && _this._preview
                                 .elem('image')
                                 .css({position: 'absolute', width: this._picWidth + 'px', height: this._picHeight + 'px'})
                                 .attr('src', _this.findElem('userimg').attr('src'));

            $.Jcrop.defaults.bgColor = 'transparent';
            _this
                .findElem('userimg')
                .Jcrop({
                    trueSize: [_this._origWidth, _this._origHeight],
                    //aspectRatio: _this._picWidth / _this._picHeight,
                    setSelect: selCoords,
                    // не вынесено в константы, т.к. ограничение искусственное
                    minSize: [150, 150],
                    onChange: onSelectionUpdate,
                    onSelect: onSelectionUpdate
                }, function() {
                    _this._jcropAPI = this;
                    _this._sizeValidationStatus = true;

                    // убираем "прыжки" картинки
                    _this
                        .findElem('userimg')
                        .css('visibility', 'visible');

                    // включаем интерактивность обратно
                    _this.setMod('interactive', 'yes');
                });

            return _this;
        },

        _fetchURL: function() {
            var _this = this,
                allOk = true,
                val = $.trim(_this.elem('url-input').val());

            // обрезанные пробелы выкинули, значение записали обратно в поле
            _this.elem('url-input').val(val);

            _this._hideErrors();

            if (val === '') {
                allOk = false;
                _this._showError('url-empty');
            } else if ( ! /^\s*https?\:\/\//i.test(val)) {
                allOk = false;
                _this._showError('url-invalid');
            }

            if (allOk) {
                _this
                    .setMod('from', 'url')
                    .setMod('editor', 'loading');

                // спорно
                _this.hasMod('multi', 'yes') && _this.elem('url-input').val('');
            } else {
                // otherwise, just clear the field...
                _this.elem('url-input').val('').focus();
            }

        },

        // обязан возвращать статус попытки загрузки -- true/false
        _startFileUpload: function() {
            var _this = this,
                isAllOk = true,
                file = _this._getImgRef();  // get a reference to a file

            // nothing to do for an empty field
            if (! _this._$fileInput.val()) {
                _this._showError('image-invalid');
                isAllOk = false;

                return isAllOk;
            }

            _this._hideErrors();

            if (file) {
                //  size, type
                if (file.size > _this._maxFileSize) {
                    isAllOk = false;
                    _this._showError('toobig');
                }

                if (file.type !== '' && ! /^image\//.test(file.type)) {
                    isAllOk = false;
                    _this._showError('format');
                }
            }

            // as soon as a file is chosen, load it
            if (isAllOk) {
                _this
                    .setMod('from', 'file')
                    .setMod('editor', 'loading');
            } else {
                // otherwise, just clear the field...
                _this._cleanupFileInput();
            }

            return isAllOk;
        },

        _imgUpload: function() {
            var _this = this;

            if (_this.hasMod('from', 'url')) {
                _this._postParams.url = _this.elem('url-input').val();
                // можно обойтись обычным ajax
                _this._xhr = $.ajax({
                    method: 'post',
                    url: _this.params.script,
                    data: $.extend({}, _this._postParams),
                    dataType: 'json',
                    timeout: _this._fileUploadTimeout,
                    success: function(data) {
                        _this._getThumbnailData(data);
                    },
                    error: function() {
                        _this._getThumbnailData(null);
                    }
                });

            } else if (_this.hasMod('html5', 'yes')) {
                // достаём ссылку на файл через File API
                _this._postParams.image = _this._getImgRef();

                var fData = new FormData();

                for (var f in _this._postParams) {
                    if (_this._postParams.hasOwnProperty(f)) {
                        fData.append(f, _this._postParams[f]);
                    }
                }

                _this._xhr = $.ajax({
                    url: _this.params.script,
                    type: 'POST',
                    data: fData,
                    processData: false,  // tell jQuery not to process the data
                    contentType: 'multipart/form-data',

                    dataType: 'json',
                    timeout: _this._fileUploadTimeout,

                    success: function(data) {
                        _this._getThumbnailData(data);
                    },

                    error: function() {
                        _this
                            ._updateImg('', '')
                            .setMod('editor', 'file')
                            ._showError('generic')
                            ._showError('textual', arguments[2]);
                    }
                });

            } else {

                // работаем через iframe
                var timeoutId,
                    uniqName = 'bbannerpic' + (+new Date),
                    $iframe = $('<iframe name="' + uniqName +
                              '" src="' + 'javascript:false' +
                              '" style="position:absolute; top:-9999px; left:-9999px"></iframe>'),
                    $form = $('<form target="' +
                            uniqName + '" method="POST" enctype="multipart/form-data"></form>');

                $iframe.appendTo(document.body);
                $form.attr('action', _this.params.script);

                var rqData = $.extend({}, _this._postParams, {callback: uniqName});

                for (var i in rqData) {
                    if (rqData.hasOwnProperty(i)) {
                        $('<input type="hidden" name="' + i + '" />')
                            .val(rqData[i])
                            .appendTo($form);
                    }
                }

                var $newInput = _this._$fileInput.clone();
                _this._$fileInput.before($newInput);
                _this._$fileInput.appendTo($form);

                _this._$fileInput.attr('name', 'image');
                _this._$fileInput = $newInput;

                $form
                    .addClass('b-banner-pic__hidden-form')
                    .appendTo(document.body)
                    .submit();

                setTimeout(function() {
                    $form.remove();
                }, 1000);

                window[uniqName] = function(data) {
                    clearTimeout(timeoutId);
                    _this._getThumbnailData(data);

                    try {
                        window[uniqName] = null;
                        delete window[uniqName];
                    } catch(e) {}

                    $iframe.remove();
                };

                // общий таймаут
                timeoutId = setTimeout(function() {
                    try {
                        window[uniqName] = null;
                        delete window[uniqName];
                    } catch(e) {}

                    $iframe.remove();

                    _this
                        ._updateImg('', '')
                        .setMod('editor', 'file')
                        ._showError('generic');
                }, _this._fileUploadTimeout);

                // callback для обрыва работы с iframe в случае _killAsync()
                _this._killIFrame = function() {
                    try {
                        window[uniqName] = null;
                        delete window[uniqName];
                    } catch(e) {}

                    clearTimeout(timeoutId);
                    $iframe.remove();

                    return _this;
                };
            }

            return _this;
        },

        _getThumbnailData: function(data) {
            var _this = this;

            if (!data) {
                return _this
                    .setMod('editor', _this.getMod('from') || 'file')
                    ._showError('generic');
            } else if (data.error) {
                // в этом случае ошибки отдаются ТЕКСТОМ, поэтому показываем всегда textual-ошибку
                return _this
                    .setMod('editor', _this.getMod('from') || 'file')
                    ._showError('textual', data.error);
            } else {
                $.extend(_this, {
                    _previewWidth: data.width,
                    _previewHeight: data.height,
                    _previewId: data.image,
                    _origWidth: data.orig_width,
                    _origHeight: data.orig_height,
                    _uploadId: data.upload_id
                });

                _this.setMod('editor', 'loaded');

                return _this;
            }

        },

        _saveCrop: function() {
            var _this = this;

            _this.setMod('interactive', 'no');

            if (_this._jcropAPI) {
                _this._jcropAPI.release();
                _this._jcropAPI.disable();
            }

            _this._xhr = $.ajax({
                url: _this.params.script,
                method: 'get',
                dataType: 'json',
                timeout: 60000,
                data: {
                    cid: _this.params.cid,
                    cmd: 'ajaxResizeBannerImage',
                    ulogin: _this._ulogin,
                    image: _this._previewId,
                    upload_id: _this._uploadId,
                    ulogin: _this._ulogin,
                    x1: _this._crop[0],
                    // Math.min нужен, т.к. плагин иногда отдаёт координаты с ошибкой +1 пиксель
                    x2: Math.min(_this._crop[1], _this._origWidth),
                    y1: _this._crop[2],
                    y2: Math.min(_this._crop[3], _this._origHeight)
                },
                success: function(data) {
                    if (!data || data.image === undefined || data.error) {
                        // непонятно, в какое состояние возвращать!
                        _this
                            ._updateImg('', '')
                            .setMod('editor', _this.getMod('from') || 'file');

                        if (data && data.error) {
                            _this._showError('textual', data.error);
                        } else {
                            _this._showError('generic');
                        }
                    } else {
                        _this._imageId = data.image;
                        _this._imageName = data.name;
                        _this._updateModels(_this._imageId,
                                           _this._imageName,
                                           _this.getMod('from'))  // для мультиредактирования
                        _this.setMod('editor', 'init');

                        _this._popupa.hide();
                    }
                },
                error: function() {
                    _this
                        ._updateImg('', '')
                        .setMod('editor', _this.getMod('from') || 'file')
                        ._showError('generic')
                        ._showError('textual', arguments[2]);
                },
                complete: function() {
                    _this.setMod('interactive', 'yes');
                }
            });
        },

        _saveCoords: function(coords) {
            this._crop = [coords.x, coords.x2, coords.y, coords.y2];
            return this;
        },

        _showPreview: function(coords) {
            var _this = this,
                rateW = _this._origWidth / _this._previewWidth,
                coefW = this._picWidth / coords.w * rateW,
                rateH = _this._origHeight / _this._previewHeight,
                coefH = this._picHeight / coords.h * rateH,
                x, y, x2, y2;

            if (!_this._preview) return _this;

            if (coords.w >= coords.h) {
                x = Math.round(coefW * coords.x / rateW);
                y = Math.round(coefW * coords.y / rateW);
                x2 = Math.round(coefW * coords.x2 / rateW);
                y2 = Math.round(coefW * coords.y2 / rateW);

                _this._preview.elem('image').css({
                    position: 'absolute',
                    width:  Math.round(_this._previewWidth * coefW) + 'px',
                    height: Math.round(_this._previewHeight * coefW) + 'px',

                    clip: 'rect(' + y + 'px ' + x2 + 'px ' + y2 + 'px ' + x + 'px)',
                    //top: (-1 * Math.round(y - ((100 - y2 + y) / 2))) + 'px',
                    top:  '-' + y + 'px',
                    left: '-' + x + 'px'
                });
                _this._preview.elem('thumb').css({
                    width:  Math.round(x2 - x) + 'px',
                    height:  Math.round(y2 - y) + 'px'
                });
            } else {
                x = Math.round(coefH * coords.x / rateH);
                y = Math.round(coefH * coords.y / rateH);
                x2 = Math.round(coefH * coords.x2 / rateH);
                y2 = Math.round(coefH * coords.y2 / rateH);

                _this._preview.elem('image').css({
                    position: 'absolute',
                    display: 'block',
                    width:  Math.round(_this._previewWidth * coefH) + 'px',
                    height: Math.round(_this._previewHeight * coefH) + 'px',

                    clip: 'rect(' + y + 'px ' + x2 + 'px ' + y2 + 'px ' + x + 'px)',
                    top:  '-' + y + 'px',
                    left: '-' + x + 'px'  // (-1 * Math.round(x - ((100 - x2 + x) / 2))) + 'px'
                });
                _this._preview.elem('thumb').css({
                    width:  Math.round(x2 - x) + 'px',
                    height:  Math.round(y2 - y) + 'px'
                });
            }

            return _this;
        },

        _setPostParams: function() {
            var _this = this;

            _this._postParams = {
                cid: _this.params.cid,
                csrf_token: _this.params.csrf_token,
                uid: _this.params.uid,
                UID: _this.params.UID,
                ulogin: _this._ulogin,
                cmd: 'uploadBannerImage'
            };

            return _this;
        },

        _showGallerySection: function(n) {
            var _this = this,
                startIndex = _this._picsPerGallery * n,
                picImgSelector = _this.buildSelector('piclist-img'),
                picNameSelector = _this.buildSelector('piclist-name');

            if (startIndex >= 0 && _this._gallery[startIndex]) {
                _this._currentGallerySection = n;
                _this.elem('piclist-frame').each(function(i, el) {
                    var imgData = _this._gallery[startIndex + i],
                        $el = $(el),
                        $imgCell = $el.find(picImgSelector),
                        $nameCell = $el.find(picNameSelector);

                    if (imgData) {
                        $imgCell.show().attr('src', _this._makeThumbURL(imgData.image));
                        $nameCell.text(imgData.name);
                        $el
                            .attr('title', imgData.name)
                            .attr('data-gallery-id', startIndex + i)
                            .show();
                    } else {
                        // простое прописывание .attr('src', '') не помогает в Chrome
                        $imgCell.hide().attr('src', '');
                        $nameCell.text('');
                        $el
                            .hide()
                            .removeAttr('title')
                            .attr('data-gallery-id', '');
                    }
                });
                _this
                    .elem('gallery-text')
                    .text(iget('Страница %s из %s', n + 1, Math.ceil(_this._gallery.length / _this._picsPerGallery)));
            }

            _this
                ._disableButtons({
                    'gallery-back': _this._currentGallerySection - 1 < 0,
                    'gallery-fwd': (_this._currentGallerySection + 1) * _this._picsPerGallery >= _this._gallery.length
                })
                .elem('piclist')
                    .scrollTop(0);

            return _this;
        }
    },
    {}
);
