(function($){
    var kzRegExp = new RegExp('[' + KAZ_LETTERS + ']'),
        uaRegExp = new RegExp('[' + UKR_NATIVE_LETTERS + ']'),
        trRegExp = new RegExp('[' + TR_NATIVE_LETTERS + ']'),
        beRegExp = new RegExp('[' + BEL_NATIVE_LETTERS + ']'),
        domainRegExp = /(www\.)?(.*)/,

        warningTexts = {
            domainWarning:   iget("Ссылка с заголовка ведёт на другой домен"),
            paramsWarning: iget("Ссылка на сайт содержит параметры. Кириллические символы при подстановке в URL будут кодированы в utf-8. Убедитесь, что ваш сайт поддерживает эту кодировку."),
            formatWarning:   iget("Неправильный формат ссылки"),
            ukranianWarning: iget("Пожалуйста, убедитесь, что географический таргетинг настроен на Украину."),
            turkeyWarning: iget("Пожалуйста, убедитесь, что географический таргетинг настроен на Турцию."),
            lengthWarning:   iget("При показе на поиске Яндекса домен будет отображен в сокращенном виде (только 35 символов)"),
            kazakhWarning:   iget("Пожалуйста, убедитесь, что выбран только один регион - «Казахстан»."),
            belarusianWarning: iget("Пожалуйста, убедитесь, что географический таргетинг настроен на Беларусь.")
        };

BEM.DOM.decl({ block: 'b-banner-preview', modName: 'updatable', modVal: 'yes' }, {
    onSetMod: {
        'js': function(){
            this.__base();


            this.lastWarnings = [];

            this.hrefDefaultValue = this.params.href_default_value || iget('домен');
            this.titleDefaultValue = this.params.title_default_value || iget('Заголовок объявления');
            this.bodyDefaultValue = this.params.body_default_value || iget('Текст вашего объявления о рекламе услуги или товара.');

            this.sitelinksModel = this.model.getChildModel('b-banner-sitelinks')
                .on('quick-change init rollback change', this.updateSitelinks, this);

            this.hrefModel = this.model.getChildModel('b-banner-form-href')
                .on('change',  this.updateHref, this);

            this.__self.liveBindTo('sitelink', 'click', this.onSitelinkClick);

            this.model
                .onField('with_href with_ci', 'change', this.updateFooter, this)
                .onField('with_sitelinks', 'change', this.updateWithSitelinks, this)
                .onField('title', 'change', this.updateTitle, this)
                .onField('title_extension', 'change', this.updateTitle, this)
                .onField('body', 'change', this.updateBody, this);

            this.updateWarningsDebounce = $.debounce(this.updateWarnings, 1000, this);

            this
                .updateWithSitelinks()
                .updateTitle()
                .updateFooter()
                .updateBody()
                .updateSitelinks();

        }
    },

    updateFooter: function() {
        BEM.DOM.update(
            this.elem('footer'),
            BEM.HTML.build([
                this.model.get('with_ci') && {
                    block: 'b-banner-preview',
                    elem: 'vcard',
                    vcard: this.hrefModel.get('href')
                } || undefined, //чтобы не сгенерировался  '0'
                {
                    block: 'b-banner-preview',
                    elem: 'domain',
                    domain: this.hrefModel.get('domain') || this.hrefDefaultValue,
                    href: this.hrefModel.get('href')
                }
            ])
        );
        //DIRECT-23788
        this.bindTo(this.findElem('vcard'), 'click', this._onVCardClick);

        return this;
    },

    updateWithHref: function() {
        this.setMod(this.elem('domain'), 'hidden', this.model.get('with_href') ? 'no' : 'yes');
        this.updateWithSitelinks();
        this.updateTitleHref();

        this.updateWarningsDebounce();

        return this;
    },

    textLang: function(text) {
        if (text.match(kzRegExp)) {
            return 'kz';
        } else if (text.match(uaRegExp)) {
            return 'ua';
        } else if (text.match(beRegExp)) {
            return 'be';
        } else if (text.match(trRegExp)) {
            return 'tr'
        } else {
            return '';
        }
    },

    compareDomains: function(a, b) {
        if (!a || !b) return true;

        return a.match(domainRegExp)[2].toLowerCase() == b.match(domainRegExp)[2].toLowerCase();
    },

    updateWarnings: function() {
        var href = this.hrefModel.get('href'),
            hrefDomain = this.hrefModel.get('domain'),
            domainError = this.hrefModel.get('domain_error'),
            curWarnigns = [],
            haveParams = !!href.match(/\#([^\#]*?)\#/) || !!href.match(/{(param1|param2|source|source_type|position_type|position|keyword|addphrases)}/i),
            lang = this.textLang(
                this.model.get('body') + this.model.get('title') + this.model.get('title_extension') +
                    (this.model.get('with_sitelinks') ? this.sitelinksModel.get('title0') + this.sitelinksModel.get('title') + this.sitelinksModel.get('title_extension') : '')
            ),
            withHref = this.model.get('with_href');

        this.elem('domain-params-warning').toggle(haveParams);
        haveParams && curWarnigns.push('paramsWarning');


        if (lang == 'ua') curWarnigns.push('ukranianWarning');
        if (lang == 'be') curWarnigns.push('belarusianWarning');
        if (lang == 'kz') curWarnigns.push('kazakhWarning');
        if (lang == 'tr') curWarnigns.push('turkeyWarning');
        if (withHref && hrefDomain && !direct.utils.validateHref(hrefDomain)) curWarnigns.push('formatWarning');
        if (withHref && hrefDomain && direct.utils.validateHref(hrefDomain) && !this.compareDomains(this.hrefModel.get('domain_redir'), hrefDomain)) curWarnigns.push('domainWarning');
        if (withHref && this.getDomainText().length > 35) curWarnigns.push('lengthWarning');

        if (withHref && domainError) curWarnigns.push(domainError);

        // если есть новые варнинги
        if (this.lastWarnings.length != curWarnigns.length || $.grep(this.lastWarnings, function(w, i) {
            return curWarnigns[i] != w;
        }).length) {
            this.setMod(this.elem('warnings'), 'show', curWarnigns.length ? 'yes' : 'no');
            BEM.DOM.update(
                this.elem('warnings'),
                BEM.HTML.build(
                    $.map(curWarnigns, function(w) {
                        return {
                            block: 'b-banner-preview',
                            elem: 'warning',
                            mods: { type: w == 'paramsWarning' ? 'info' : '' },
                            content: warningTexts[w] || w
                        };
                    })
                )
            );
        }

        this.lastWarnings = curWarnigns;

        return this;
    },

    isHrefValid: function(href) {
        return this.model.get('with_href') && href && direct.utils.validateHref(href);
    },

    updateTitleHref: function() {
        var href = this.hrefModel.get('href'),
            urlProtocol = this.hrefModel.get('urlProtocol');

        if (this.isHrefValid(href)) {
            if ($.browser.msie && parseInt($.browser.version, 10) < 7) {
                this.elem('title-link')
                    .attr('href',
                        "/registered/redirect_idn.pl?url=" + encodeURIComponent(urlProtocol + href) + '&yauid=' + yagetCookie('yandexuid'));
            } else {
                this.elem('title-link').attr('href',  urlProtocol + href);
            }
        } else {
            this.elem('title-link').attr('href',  '#');
        }

        return this;
    },

    updateTitle: function() {
        var model = this.model,
            title = model.get('title'),
            titleExtension = model.get('title_extension');

        this.setFormatedText(this.elem('title-link'), title || this.titleDefaultValue, titleExtension);

        this.updateWarningsDebounce();

        return this;
    },

    updateWithCi: function() {
        //this.setMod(this.elem('vcard'), 'hidden', this.model.get('with_ci') ? 'no' : 'yes');

        BEM.DOM.update(
            this.elem('footer'),
            BEM.HTML.build([
                this.model.get('with_ci') && {
                    block: 'b-banner-preview',
                    elem: 'vcard',
                    vcard: this.model.get('href')
                } || undefined, //чтобы не сгенерировался  '0'
                this.hrefModel.get('domain') && {
                    block: 'b-banner-preview',
                    elem: 'domain',
                    domain: this.hrefModel.get('domain')
                }
            ]),
            function() {
                this.updateWithSitelinks();
            },
            this
        );

        if (this.model.get('with_ci')) {
            BEM.DOM.update(
                this.elem('footer'),
                BEM.HTML.build({
                    block: 'b-banner-preview',
                    elem: 'vcard',
                    number: this.model.get('bid'),
                    href: this.model.get('href'),
                    vcard: this.model.get('vcard_id'),
                    id: this.model.get('bid')
                })
            );
        }

        return this;
    },

    updateWithSitelinks: function() {
        var show = (this.model.get('with_sitelinks') || !this.sitelinksModel.isModelEmpty());

        this.setMod('with-sitelinks', !!show ? 'yes' : 'no');
        this.elem('sitelinks').toggle(!!show);

        if (show) this.updateSitelinks();

        this.updateWarningsDebounce();

        return this;
    },

    updateBody: function() {
        this.setFormatedText(this.elem('body'), this.model.get('body') || this.bodyDefaultValue);

        this.updateWarningsDebounce();

        return this;
    },

    _onTitleClick: function(e) {
        e.preventDefault();

        if (this.model.get('with_href')) {
            var href = this.hrefModel.get('href');
            if ( !this.isHrefValid(href) )
                alert(iget('Адрес сайта не указан или указан неверно'));
            else
                window.open(this.hrefModel.get('urlProtocol') + href);
        } else
            this._onVCardClick(e);
    },

    updateSitelinks: function() {
        if (this.getMod('with-sitelinks') !== 'yes') return;

        var elems = this.elem('sitelink');

        for (var i = 0; i < SITELINKS_NUMBER; i++) {
            var title = this.sitelinksModel.get('title' + i),
                href = this.sitelinksModel.get('href' + i) || '#',
                protocol = this.sitelinksModel.get('urlProtocol' + i) || 'http://',
                empty = !title.match(/\S/),
                //this.elem('sitelink', 'num', i) не работает - понять почему
                elem = elems.eq(i);

            title = empty ? iget('Текст ссылки № ') + (i + 1) : title;

            this.setMod(elem, 'empty', empty ? 'yes' : '');

            elem.attr('href', href == '#' ? '#' : (protocol + direct.utils.escapeHTML(href)));
            elem.html(this._evaluateHTMLEntity(title));
        }

        this.updateWarningsDebounce();

        return this;
    },

    onSitelinkClick: function (e, data) {
        e.preventDefault();

        var protocol = this.sitelinksModel.get('urlProtocol' + this.getMod(e.data.domElem, 'num')),
            href = this.sitelinksModel.get('href' + this.getMod(e.data.domElem, 'num'));

        if (!direct.utils.validateHref(href)) {
            alert(iget('Адрес сайта не указан или указан неверно'));
            return false;
        }

        window.open(protocol + href);
    },

    getDomainText: function() {
        return this.hrefModel.get('domain') || this.hrefModel.get('domain_redir') || this.hrefDefaultValue;
    },

    setFormatedText: function(container, text, extText) {
        if ((extText || '').length) {
            container.html([
                this._evaluateHTMLEntity(text).replace(/#(.*?)#/, '<span class="b-banner-preview__template">$1</span>'),
                this._evaluateHTMLEntity(extText).replace(/#(.*?)#/, '<span class="b-banner-preview__template">$1</span>')
            ].join(' - '));
        } else {
            container.html(this._evaluateHTMLEntity(text).replace(/#(.*?)#/, '<span class="b-banner-preview__template">$1</span>'));
        }
    },

    updateHref: function() {
        var text = this.getDomainText();
        if (text.length > 35) {
            text = '...' + text.substr(text.length - 35, text.length);
        }
        this.updateFooter();
        this.updateTitleHref();
        this.updateWarningsDebounce();

        return this;
    },

    /**
     * Преобразование html сущностей из юникод значений в безопасный для вставки текст
     * @param {String} html
     * @returns {String}
     * @private
     */
    _evaluateHTMLEntity: function(html) {
        return $('<div>').html(direct.utils.escapeHTML(html)).html();
    }

});

})(jQuery);
