(function($){
    /**
     * Блок с превью баннера
     */

    var request,
        AJAX_URL = '/registered/main.pl',
        ADMIN_STATUSES = {
            'previous': iget('Идут показы предыдущей версии объявления!'),
            'moderation': iget('Отклонено модератором'),
            'budget-stop': iget('Недельный бюджет временно приостановил показ объявления')
        };

    BEM.DOM.decl('b-banner-preview', {
        onSetMod: {
            'js': function() {
                var toFill = this.params.toFill;

                this.model = BEM.blocks['i-models-manager']
                    .get(this.params.modelPath, 'b-banner-edit');

                if (toFill)
                    this.model.update(toFill, this, true);

                if (this.model.get('bkBannerId') != 0 && this.model.get('statusAutobudgetShow') == 'Yes')
                    this.addAdminStatus('budget-stop');

                if (this.model.get('bkBannerId') != 0 &&
                    this.model.get('statusActive') == 'Yes' &&
                    (this.model.get('statusModerate') != 'Yes' || this.model.get('pstatusModerate') != 'Yes'))
                        this.addAdminStatus('previous');

                if (this.getMod('destination') == 'group') {
                    this.model.onField(
                        'statusShow',
                        'change',
                        { src: this },
                        this._onChangeStatus
                    );

                    if (this.model.get('status')) {
                        var statusText = this.model.get('status');

                        if (this.model.get('declined_show')) {
                            statusText += " (<a href=\"#\" onclick=\"openWnd('?cmd=showDiag&bid=" + this.model.get('bid') + "', 'reason', 700, 330); return false;\">" + iget('Подробнее') + "</a>)";
                        }

                        this.addAdminStatus('main', statusText);
                    }
                }

                request = BEM.create('i-request_type_ajax', {
                    cache: true,
                    url: AJAX_URL,
                    dataType: 'json',
                    callbackCtx: this
                });

                this
                    .bindTo('delete', 'click', this.deleteSelf)
                    .bindTo('title', 'click', this._onTitleClick)
                    .bindTo('vcard', 'click', this._onVCardClick)
                    .bindTo('addition-link', 'click', this._onAddLinkClick);
            }
        },

        /**
         * Обработчик события клика на ссылке дополнения
         * @param {Object} e Событие клика
         * @private
         */
        _onAddLinkClick: function(e) {
            var elem = e.data.domElem,
                modValue = this.getMod(elem, 'for'),
                popup;

            if (modValue == 'image' || modValue == 'sitelinks') {
                popup = this.findBlockOn(this.elem('popup', 'for', modValue), 'b-popupa')
                this.params.isMediaplanEdit && popup._getUnder().domElem.addClass('i-popup-media')
                popup.show(elem);

            }
        },

        /**
         * Обработчик события смены статуса
         * @param {Object} e Событие клика
         * @private
         */
        _onChangeStatus: function(e) {
            var block = e.data.src,
                status = this.params.name,
                value = this.get(status);

            switch (status) {
                case 'status':
                    block.addAdminStatus('main', value);
                    break;

                case 'statusShow':
                    if (block.getMod('destination') == 'group')
                        block.setMod('show', value);
                    break;
            }

            block.getMod('destination') == 'group' && block.trigger(
                'status-change',
                {
                    id: block.params.id,
                    name: status,
                    value: value,
                    writable: block.params.writable
                }
            );
        },

        /**
         * Генерирует url к превью изобржения (дополнения)
         * @param {string} id Идентификатор дополнения
         * @returns {string}
         * @private
         */
        _makeThumbURL: function(id) {
            return id === '' ?
                '/block/b-banner-preview/b-banner-preview__image_type_default.png' :
                '/images/' + id + '/x90'
        },

        /**
         *
         * @param src
         * @returns {BEM}
         * @private
         */
        _setThumb: function(src) {
            this.elem('image')
                .css({
                    display: 'inline',
                    position: 'static',  // важно сбросить: динамическая превьюшка работает с position!
                    width: '',
                    height: ''
                })
                .attr('src', this._makeThumbURL(src));

            return this;
        },

        /**
         * Событие клика на заголовке
         * Переходим по ссылке или отображаем визитку
         * @param {Object} e
         * @private
         */
        _onTitleClick: function(e) {
            if (!this.elem('title-link').attr('href')) {
                this._onVCardClick(e);

                e.preventDefault();
                //return false;
            }
        },

        //см showVCard
        appendData: function(data, submitForm) {
            var _this = this;

            $.each(data, function(fieldName, value) {
                if (typeof value !== 'object')  {
                    submitForm.append($('<input type="hidden" name="' + fieldName + '" value="' + direct.utils.escapeHTML(value) + '"></input>'));
                } else {
                    _this.appendData(value, submitForm);
                }
            })
        },

        /**
         * Удаление баннера из БД
         */
        deleteSelf: function() {
            request.get(
                {
                    cmd: 'ajaxDeleteBanner',
                    id: this.params.id
                },
                function(data) {
                    data.success && this.destruct();

                    this.trigger('deleted', { id: this.params.id });
                },
                this
            );
        },

        /**
         * Уничтожение инстанса баннера (в том числе из DOM)
         */
        destruct: function() {
            //отвязываем события модели (иначе она не удалится корректно)
            this.model && this.model.unField(
                'statusShow',
                'change',
                this._onChangeStatus
            );

            //удаляем модель (иначе инстанс "зависнет")
            //BEM.blocks['i-models-manager'].deleteModel(this.params.modelPath, 'b-banner-edit');
            //delete this.model;

            //триггерим событие для внешних блоков (например, b-banners-group-preview)
            this.trigger('destruct', { id: this.params.id, fromPreview: true });

            this.__base();
        },

        /**
         * Клик на визитке (ссылка Адрес)
         * @param {Object} e
         * @private
         */
        _onVCardClick: function(e) {
            e.preventDefault();
            this.showVCard();
        },

        /**
         * Добавление статуса при просмотре кампании администратором
         * @param {String} type Тип статуса
         * @param {String} [text] Текст статуса
         */
        addAdminStatus: function(type, text) {
            if (this.findElem('admin-status', 'type', type).length) return;

            this.elem('statuses').append(BEM.HTML.build({
                block: 'b-banner-preview',
                elem: 'admin-status',
                mods: { type: type },
                content: text || ADMIN_STATUSES[type]
            }));
        },

        /**
         * Показываем визитку
         */
        showVCard: function() {
            var bid = this.params.bid || this.model.get('bid'),
                url = '/registered/main.pl?cmd=showContactInfo&bid=' + bid + '&cid=' + this.params.cid,
                cmd = window.Direct_cmd;

            if (this.model.get('is_mediaplan') == 1) url += '&media=1';

            if (cmd.match(/multieditMediaplan|editBannerEasy|addBannerMultiEdit|gobackMultiEdit|bannersMultiEdit|processBannerStep2|showCampMultiEdit|multieditMediaplanStep2/)) {
                //покопавшись не удалось найти относительно быстрого решения для устранения следующего кода
                //оставляю до итогового рефакторинга баннеров
                var submitForm = $(
                   '<form action="/registered/main.pl" method="POST" target="ContactInfoPopup">' +
                       '<input type="hidden" name="cmd" value="showContactInfo">' +
                       '<input type="hidden" name="from" value="edit">' +
                       '<input type="hidden" name="bid" value="' + (bid || 0) + '">' +
                       '<input type="hidden" name="cid" value="' + this.params.cid + '">' +
                       '</form>');
               this.appendData(this.model.memento(1, 1, 'input'), submitForm);
               submitForm
                   .appendTo($('body'));

               OpenWindow("", '800', '600', "ContactInfoPopup");
               submitForm
                   .submit()
                   .remove();
            } else
                OpenWindow(url, '800', '600', 'ContactInfoPopup');
        }
    });

    BEM.HTML.decl('b-banner-preview', {

        onBlock: function(ctx) {
            var bid = ctx.param('id'),
                age = ctx.param('age'),
                modelPath = ctx.param('modelPath') || 'campaign&banner:' + bid,
                canToggle = !!ctx.param('canEdit'),

                alertsBlock = {
                    block: 'b-adv-alerts',
                    content: []
                },
                warnings = ctx.param('warnings') || [],
                hashFlags = ctx.param('hash_flags') || {},
                adWarnings = ctx.param('ad-warnings') || {},
                alertsChangeBlock = {
                    block: 'b-adv-alert-change',
                    bid: bid,
                    warnings: warnings,
                    'ad-warnings': adWarnings,
                    hash_flags: hashFlags
                },
                showAlert = hashFlags && Object.keys(hashFlags).some(function(key) {
                    return key in adWarnings;
                });

            if (typeof age == 'undefined')
                age = -1;

            /*
                Так как b-adv-alert сейчас сделан неправильно, внутри b-adv-alerts будут блоки b-adv-alert
                Нужно будет отрефакторить к виду b-adv-alerts > b-adv-alerts__item
            */
            if (showAlert) {
                alertsBlock.content.push({
                    block: 'b-adv-alert',
                    cls: 'b-adv-alert_afterlink',
                    content: {
                        elem: 'text',
                        cls: 'ad_text-' + bid,
                        content: $.map(hashFlags, function(value, key) {
                            if (key == 'age' || key == 'tragic' || key == 'telecom') return undefined;
                            if (key == 'baby_food') {
                                return {
                                    block: 'b-child-food-label',
                                    age: value || 11,
                                    bid: bid
                                };
                            } else {
                                if (adWarnings[key]) {
                                    return adWarnings[key].long_text
                                }
                                else {
                                    return undefined;
                                }
                            }
                        })
                    }
                });
            }

            ctx
                .js(true)
                .tag('div')
                .content([
                    {
                        elem: 'header',
                        number: ctx.param('number'),
                        withBrand: ctx.param('inner') && ctx.param('image'),
                        deletable: ctx.param('deletable'),
                        writable: ctx.param('writable'),
                        isTemplateBanner: ctx.param('isTemplateBanner')
                    },
                    ctx.param('inner') && ctx.param('image') && {
                        elem: 'thumb',
                        content: {
                            elem: 'image',
                            image: ctx.param('image')
                        }
                    },
                    {
                        elem: 'title',
                        content: ctx.param('title').replace(/#(.*)#/, '<span class="b-banner-preview__template">$1</span>'),
                        mix: [{
                            block: 'b-banner-preview',
                            elem: 'title-link'
                        }],
                        href: ctx.param('href'),
                        attrs: { target: '_blank' }
                    },
                    ctx.param('inner') && ctx.param('sitelinks') && {
                        elem: 'sitelinks',
                        sitelinks: ctx.param('sitelinks')
                    },
                    {
                        elem: 'body',
                        content: ctx.param('text')
                    },
                    ( ctx.param('href') || ctx.param('vcard') ) && {
                        elem: 'footer',
                        vcard: ctx.param('vcard'),
                        href: ctx.param('href'),
                        domain: ctx.param('domain')
                    },
                    !ctx.param('inner') && ( ctx.param('sitelinks') || ctx.param('image') ) && {
                        elem: 'additions',
                        allParams: ctx.params(),
                        modelPath: modelPath
                    },
                    //ниже возвращается блок предупреждений, если они есть
                    !ctx.param('inner') && showAlert && alertsBlock,
                    canToggle && !ctx.param('inner') && showAlert && alertsChangeBlock,
                    !ctx.param('inner') && {
                        block: 'b-age-label',
                        mix: [{ block: 'b-banner-preview', elem: 'age-label' }],
                        js: { age: ctx.param('age'), bid : bid, canToggle: canToggle, modelPath: modelPath },
                        age: age,
                        canToggle: canToggle,
                        mods: age < 0 && { installed: 'no' }
                    },
                    {
                        elem: 'warnings',
                        mods: { show: !(ctx.param('warnings') && ctx.param('warnings').length) ? 'no' : '' },
                        content: !!ctx.param('warnings') && $.map(ctx.param('warnings'), function(warning) {
                            return {
                                elem: 'warning',
                                content: [warning, '. ']
                            }
                        })
                    },
                    !ctx.param('inner') && {
                        elem: 'statuses'
                    }
                ]);
        },

        onElem: {

            'header': function(ctx) {
                var content = [];

                ctx.param('number') && content.push({
                    elem: 'number',
                    content: '&#8470;&nbsp;M-' + ctx.param('number')
                });

                ctx.param('isTemplateBanner') && content.push({
                    elem: 'status',
                    mods: { type: 'template' },
                    mix: [{ block: 'b-icon-text' }],
                    content: [
                        {
                            block: 'b-icon',
                            mods: { 'size-13': 'notice' },
                            mix: [{ block: 'b-icon-text', elem: 'icon' }]
                        },
                        iget('Объявление содержит шаблон')
                    ]
                });

                ctx.param('brand') && content.push({ elem: 'brand' });

                ctx.param('deletable') && ctx.param('writable') && content.push({ elem: 'delete' });

                ctx
                    .tag('div')
                    .content(content);

            },

            'number': function(ctx) {
                ctx.tag('span');
            },

            'title': function(ctx) {
                ctx
                    .tag('a')
                    .attrs({ href: ctx.param('href').match('http') ? ctx.param('href') : 'http://'+ctx.param('href') });
            },

            'body': function(ctx) {
                ctx.tag('div');
            },

            'footer': function(ctx) {
                ctx
                    .tag('div')
                    .content([
                        ctx.param('vcard') && {
                            elem: 'vcard',
                            vcard: ctx.param('vcard')
                        },
                        ctx.param('domain') && {
                            elem: 'domain',
                            href: ctx.param('href'),
                            domain: direct.utils.extractDomain(ctx.param('domain'))
                        }
                    ]);
            },

            'domain': function(ctx) {
                ctx
                    .tag('span')
                    .content([
                        {
                            elem: 'domain-text',
                            content: direct.utils.escapeHTML(ctx.param('domain'))
                        },
                        !!(ctx.param('href').match(/#[^#]*#/) ||
                            ctx.param('href').match(/param1|param2|source|source_type|position_type|position|keyword|addphrases/i)) && {
                                elem: 'domain-params-warning',
                                content: [
                                    '&nbsp;/&nbsp;',
                                    {
                                        tag: 'img',
                                        attrs: { title: iget('Ссылка объявления содержит параметры.'), src: '/i/template_banner.gif' }
                                    }
                                ]
                        }
                    ]);
            },

            'domain-text': function(ctx) {
                ctx.tag('span');
            },

            'domain-params-warning': function(ctx) {
                ctx.tag('span');
            },

            'vcard': function(ctx) {
                ctx
                    .tag('a')
                    .attrs({ href: ctx.param('vcard'), target: '_blank' })
                    .content(iget('Адрес и телефон'));
            },

            'additions': function(ctx) {
                var params = ctx.param('allParams');

                ctx.content([
                    {
                        tag: 'span',
                        content: iget('Дополнения') + ': '
                    },
                    params['image'] && {
                        elem: 'addition-link',
                        tag: 'span',
                        mods: { 'for': 'image' },
                        content: iget('изображение')
                    },
                    params['image'] && {
                        block: 'b-popupa',
                        mix: [{
                            block: 'b-banner-preview',
                            elem: 'popup',
                            mods : { 'for' : 'image' }
                        }],
                        content: [
                            { elem: 'tail' },
                            { elem: 'close' },
                            {
                                elem: 'content',
                                content: {
                                    block: 'b-banner-preview',
                                    mods: { type: 'image', destination: 'popup' },
                                    js: params['js'],
                                    id: params['id'],
                                    inner: true,
                                    title: params['title'],
                                    text: params['text'],
                                    href: params['href'],
                                    vcard: params['vcard'],
                                    image: params['image'],
                                    domain: params['domain']
                                }
                            }
                        ]
                    },
                    params['sitelinks'] && params['image'] && {
                        tag: 'span',
                        content: ', '
                    },
                    params['sitelinks'] && {
                        elem: 'addition-link',
                        tag: 'span',
                        mods: { 'for': 'sitelinks' },
                        content: iget('быстрые ссылки')
                    },
                    params['sitelinks'] && {
                        block: 'b-popupa',
                        mix: [{
                            block: 'b-banner-preview',
                            elem: 'popup',
                            mods : { 'for' : 'sitelinks', destination: 'popup' }
                        }],
                        content: [
                            { elem: 'tail' },
                            { elem: 'close' },
                            {
                                elem: 'content',
                                content: {
                                    block: 'b-banner-preview',
                                    mods: { type: 'sitelinks' },
                                    inner: true,
                                    js: params['js'],
                                    id: params['id'],
                                    title: params['title'],
                                    text: params['text'],
                                    href: params['href'],
                                    vcard: params['vcard'],
                                    sitelinks: params['sitelinks'],
                                    domain: params['domain']
                                }
                            }
                        ]
                    }
                ]);
            },

            'sitelinks': function(ctx) {
                var content = [],
                    s = ctx.param('sitelinks');

                for (var i = 0; i < s.length; i++)
                    content.push({ elem: 'sitelink', data: s[i] });

                ctx.content(content);

            },

            'sitelink': function(ctx) {
                var data = ctx.param('data');

                ctx
                    .tag('a')
                    .attrs({ href: data['href'], target: '_blank' })
                    .content(data['title']);

            },

            'brand': function(ctx) {
                ctx.content([iget('Яндекс.Директ'), { elem: 'all-ads', tag: 'span', content: iget('Все объявления') }]);

            },

            'delete': function(ctx) {
                //TODO заменить после DIRECT-20037
                ctx
                    .tag('img')
                    .attrs({
                        alt: '',
                        src: '/i/easy_phrase_delete_off.gif'
                    });

            },

            'image': function(ctx) {
                ctx
                    .tag('img')
                    .attrs({
                        alt: '',
                        src: '/images/' + ctx.param('image') + '/x90'
                    });

            }

        }

    });

})(jQuery);
