(function($){

    var iModelsManager = BEM.blocks['i-models-manager'];

    BEM.blocks['b-model'].register('b-banner-sitelinks', (function() {
        var sitelinksRules = {
                fields: {
                    'has_errors': { type: 'flag', 'default': '' }
                },
                validateRules: {}
            },
            preprocessText = function(value) {
                return (''+value).replace(/\s\s*/g, ' ');
            };
        for (var i=0; i < SITELINKS_NUMBER; i++) {
            sitelinksRules.fields['title'+i] =  {
                type: 'string',
                input: 1,
                fromServer: 1,
                'default': '',
                toServer: 1,
                preprocess: preprocessText
            };

            sitelinksRules.fields['description'+i] =  {
                type: 'string',
                input: 1,
                fromServer: 1,
                'default': '',
                toServer: 1,
                preprocess: preprocessText
            };

            sitelinksRules.fields['href'+i] =  {type: 'string', input: 1, fromServer: 1, toServer: 1};

            sitelinksRules.fields['urlProtocol' + i] =  { type: 'string', input: 1, fromServer: 1, toServer: 1 };
        }

        return sitelinksRules;
    })());

    BEM.DOM.decl('b-banner-sitelinks', {
            onSetMod: {
                js: function() {
                    if (!this.hasMod('multi')) {
                        this.parentModel = BEM.blocks['i-models-manager'].get(this.params.modelPath, 'b-banner-edit');
                        this.hrefModel = this.parentModel.getChildModel('b-banner-form-href');

                    } else {
                        var _this = this;

                        this._isFirstMultiOpening = true;
                        this.iModelsManager = BEM.blocks['i-models-manager'];

                        this.iModelsManager.onGroup('campaign&banner:*', 'b-banner-sitelinks', {
                            name: 'saved',
                            callback: function() {
                                _this.fillCommonData.call(_this);
                            }
                        });
                    }

                    this.model = BEM.blocks['i-models-manager'].get(this.params.modelPath, this.__self.getName());
                    this.titles = this.elem('title');
                    this.descriptions = this.elem('description');

                    this.titlesHidden = this.elem('title-hidden');
                    this.descriptionsHidden = this.elem('description-hidden');
                    this.hrefs = this.elem('href');
                    this.urlProtocols = this.elem('href-protocol');
                    this.hrefsHidden = this.elem('href-hidden');
                    this.urlProtocolsHidden = this.elem('href-protocol-hidden');
                    this.text = this.elem('text');
                    //счетчик длины одного названия
                    this.titleCounters = this.elem('title-counter');
                    this.descriptionCounters = this.elem('description-counter');
                    //счетчик суммарной длины всех названий
                    this.titleTotalCounters = this.elem('title-total-counter');
                    this.hrefCounters = this.elem('href-counter');

                    this.popupa = this.findBlockOutside('b-popupa');
                    this.exterr = this.elem('exterr');
                    this.submit = this.findBlockOn(this.elem('action', 'type', 'save'), 'b-form-button');

                    this.cancel = this.findBlockOn(this.elem('action', 'type', 'cancel'), 'b-form-button');

                    if (this.submit && this.cancel) {
                        this.submit.on('click', this.onSubmit, this);
                        this.cancel.on('click', this.onCancel, this);
                    }
                    //кэшируем элементы с ошибками
                    this.elem('error');

                    this.errors = {};
                    this.warnings = {};

                    for (var i = 0; i < SITELINKS_NUMBER; i++) {
                        this.errors[i] = {};
                        this.warnings[i] = 0;
                    }

                    this.popupa && this.popupa
                        .on('outside-click', function(e) {
                            e.preventDefault();
                        }, this)

                        .on('show', function(e) {
                            if (this._isFirstMultiOpening) {
                                this.hasMod('multi') && this.fillCommonData();
                                this._isFirstMultiOpening = false;
                            }

                            this.fillPopupFromModel();
                            this.checkAll();
                            this._checkDescriptionVisibility();
                        }, this)
                        .on('hide', function() {
                            this.rollbackModel();
                        }, this);

                    BEM.blocks['b-popupa'].on('showPopup', function(e, source) {
                        if (source !== this) {
                            this.popupa.hide();
                        }
                    }, this);


                    if (this.elem('switcher').length > 0) {
                        this.switcher = this.findBlockOn(this.elem('switcher'), 'b-form-button')
                            .on('click', function() {
                                BEM.blocks['b-popupa'].trigger('showPopup', this);
                                if (this.popupa.isShowed()) {
                                    this.popupa.hide();
                                } else {
                                    this.popupa.show(this.elem('switcher'));
                                }
                            }, this);
                    }

                    this.hrefModel && this.hrefModel.bind('change', $.proxy(function(e) {
                        this.checkAllUrls();
                        if (!this.hrefModel.isFieldEmpty('href')) this.trigger('exterr', {});
                    }, this));


                    // обновление полей из модели
                    this.model
                        .on('quick-change change clear', this.onModelChange, this)
                        .on('exterr', this.updateExternalWarning, this)
                        .onField('has_errors', 'change', this.onModelErrorSet, this);

                    //аналог mod focused yes из bem
                    this.titles.bind('focus blur', { type: 'title' }, $.proxy(this.toggleFocus, this));
                    this.descriptions.bind('focus blur', { type: 'description' }, $.proxy(this.toggleFocus, this));
                    this.hrefs.bind('focus blur', { type: 'href' }, $.proxy(this.toggleFocus, this));


                    // обновление модели из полей
                    this.titles.bind('keyup blur change', $.proxy(this.onTitleChange, this));
                    this.descriptions.bind('keyup change', $.proxy(this.onDescriptionChange, this));
                    this.hrefs.bind('keyup change', $.proxy(this.onHrefChange, this));
                    this.urlProtocols.bind('change', $.proxy(this.onProtocolChange, this));

                    this.hrefs.each(function(i) { $(this).data('index', i); });
                    this.titles.each(function(i) { $(this).data('index', i); });
                    this.descriptions.each(function(i) { $(this).data('index', i); });
                    this.urlProtocols.each(function(i) { $(this).data('index', i); });


                    if (this.params.prev_bid) {
                        var prevModel = BEM.blocks['i-models-manager'].get('campaign&banner:' + this.params.prev_bid, this.__self.getName());

                        this.bindTo('copy', 'click', function() {
                            if (prevModel.isModelEmpty() && !confirm(iget('Будут скопированны пустые данные'))) return false;
                            this.model.update(prevModel.getData(), 'copy');
                        })
                    }

                    this.bindTo('clear', 'click', function() {
                        this.model.clear('clear');
                    });

                    this.bindTo('toggler-link', 'click', function() {
                        this._toggleDescriptions();
                    });

                    this._checkDescriptionVisibility();

                    this.parentModel && this.parentModel.update({ with_sitelinks: true });

                    this.checkAll();
                }
            },


            /**
             * Показывает описание к сайтликам если они есть
             * @private
             */
            _checkDescriptionVisibility: function() {
                var sitelinksWithDescription = false,
                    i = 0;

                for (; i < SITELINKS_NUMBER; i++) {
                    sitelinksWithDescription = sitelinksWithDescription || !!this.model.get('description' + i);
                }

                this._toggleDescriptions(sitelinksWithDescription);
            },

            /**
             * Скрывает/показывает описания к сайтлинкам
             * @param {Boolean} condition
             * @private
             */
            _toggleDescriptions: function(condition) {
                this.toggleMod('description', 'visible', condition);
            },

            toggleFocus: function(e) {
                var isFocus = e.type == 'focus';

                if (this.getMod('multi') == 'yes') {
                    var elem = $(e.target),
                        modelValue = this.model.get(e.data.type +  elem.data('index'));

                    if (modelValue == '*') {
                        this.setMod(elem, 'tooltip', isFocus ? '' : 'yes');
                        elem.val(isFocus ? '' : iget('Разные значения в объявлениях'));
                    }
                }

                this.setMod($(e.target), 'focused', isFocus ? 'yes' : '')
            },

            fillCommonData: function() {
                var data = {},
                    first = true;

                this.iModelsManager.eachModel(function (id, m) {
                    if (first) {
                        for (var i = 0; i < SITELINKS_NUMBER; i++) {
                            data['href' + i] = m.get('href' + i);
                            data['title' + i] = m.get('title' + i);
                            data['description' + i] = m.get('description' + i);
                            data['urlProtocol' + i] = m.get('urlProtocol' + i);
                        }
                    } else {
                        for (var i = 0; i < SITELINKS_NUMBER; i++) {
                            if (data['href' + i] != m.get('href' + i)) data['href' + i] = '*';
                            if (data['title' + i] != m.get('title' + i)) data['title' + i] = '*';
                            if (data['description' + i] != m.get('description' + i)) data['description' + i] = '*';
                            if (data['urlProtocol' + i] != m.get('urlProtocol' + i)) data['urlProtocol' + i] = 'http://';
                        }
                    }
                    first = false;
                }, 'campaign&banner:*', 'b-banner-sitelinks');

                this.model.update(data);
            },

            //измененилось поле has_errors  у модели
            onModelErrorSet: function(e) {
                if (!this.submit) { return this; }

                this.submit
                    .setMod('pressed', 'no')
                    .setMod('disabled', this.model.get('has_errors') ? 'yes' : '');
                this.updateExternalWarning(e, { text: iget('Быстрые ссылки заполнены некорректно') });

                return this;
            },

            onTitleChange: function(e) {
                var $this = $(e.target),
                    up = {},
                    index = $this.data('index');

                if (!this.hasMod($this, 'focused') && this.model.get('title' + index) == '*') return;

                up['title' + index] = $.trim($this.val());

                this.model.update(up, this);

                this.checkTitleErrors(index);
                this.checkDescriptionErrors(index);
            },

            /**
             * Обновляет значение модели вызывает валидацию описаний всех сайтлинков
             * @param {Object} e
             */
            onDescriptionChange: function(e) {
                var $this = $(e.target),
                    updateValue = {},
                    index = $this.data('index');

                if (!this.hasMod($this, 'focused') && this.model.get('description' + index) == '*') return;

                updateValue['description' + index] = $.trim($this.val());

                this.model.update(updateValue, this);

                for (index = 0; index < SITELINKS_NUMBER; index++) {
                    this.checkDescriptionErrors(index);
                }
            },

            dontUpdateHref: null,

            onHrefChange: function(e) {
                if (this.dontUpdateHref) {
                    this.dontUpdateHref = false;

                    return;
                }

                var $this = $(e.target),
                    up = {},
                    index = $this.data('index');

                if (!this.hasMod($this, 'focused') && this.model.get('href' + index) == '*') return;

                var value = $.trim($this.val()),
                    stripedValue = direct.utils.stripHttp(value),
                    protocol = direct.utils.getUrlProtocol(value) || this.urlProtocols.eq(index).val();

                up['href' + index] = stripedValue;
                up['urlProtocol' + index] = protocol;

                this.model.update(up, this);

                protocol && this.urlProtocols.eq(index).val(protocol);

                if (stripedValue != value) {
                    this.hrefs.eq(index).val(stripedValue);

                    this.dontUpdateHref = true;
                }

                this.hideHrefWarning(index);

                this.checkHrefErrors(index);
                this.checkDescriptionErrors(index);
            },

            onProtocolChange: function(e) {
                var $this = $(e.target),
                    up = {},
                    index = $this.data('index');

                if (!this.hasMod($this, 'focused') && this.model.get('urlProtocol' + index) == '*') return;

                up['urlProtocol' + index] = $this.val();

                this.model.update(up, this);

                if((this.model.get('href' + index) || []).length) {
                    this.hideHrefWarning(index);

                    this.checkHrefErrors(index);
                }
            },

            onSubmit: function(e) {
                this.saveInitState();
                this.model.trigger('saved');
                this.popupa.hide();
                // my fix
                this.updateExternalWarning(e, { text: iget('Быстрые ссылки заполнены некорректно') });
                this.updateSwitcher();
                this.updateTexts();
                this.fillHiddens();
            },

            onCancel: function() {

                this.popupa.hide();
            },

            checkTotalTitlesLength: function() {
                var totalTitleLength = this.__self.totalTitleLength(this.model),
                    errorTitles = SITELINKS_MAX_LENGTH < totalTitleLength;

                this.errors.titlesLength = errorTitles;

                for (var i = 0; i < SITELINKS_NUMBER; i++) {
                    this.titleTotalCounters.eq(i).html(SITELINKS_MAX_LENGTH - totalTitleLength);
                    this.setMod(this.titleTotalCounters.eq(i), 'overflow', errorTitles ? 'yes' : '');
                }

                this.updateModelErrorState();
            },

            checkAll: function() {
                for (var i = 0; i < SITELINKS_NUMBER; i++) {
                    this.checkTitleErrors(i);
                    this.checkDescriptionErrors(i);
                    this.checkHrefErrors(i);
                }

                this.updateModelErrorState();
            },

            checkTitleErrors: function(index) {
                var elem = this.titles.eq(index),
                    title = this.model.get('title' + index),
                    href = this.model.get('href' + index),
                    titleLength = $.trim(title).length,
                    errorOneTitle = ONE_SITELINK_MAX_LENGTH < titleLength;


                this.errors[index] = this.errors[index] || {};

                if (title == '*') {
                    this.titleCounters.eq(index).html(0);
                    this.setMod(this.titleCounters.eq(index), 'overflow', '');
                    this.updateModelErrorState();

                    return this;
                }

                this.errors[index].empty = href && !title || title && !href;

                this.titleCounters.eq(index).html(titleLength);
                this.errors[index].titleLength = errorOneTitle;
                this.setMod(this.titleCounters.eq(index), 'overflow', errorOneTitle ? 'yes' : '');

                this.checkTotalTitlesLength();

                this.toggleTitleErrors();

                if (!this.hasMod(elem, 'focused')) this.checkAllTitles();

                this.updateModelErrorState();

                return this;
            },

            /**
             * Валидирует описание сайтлика
             * @param {Number} index индекс текущего сайтлика
             * @returns {BEM} this
             */
            checkDescriptionErrors: function(index) {
                var model = this.model,
                    allDescriptions = [],
                    currentDescription = model.get('description' + index),
                    descriptionLength = $.trim(currentDescription).length,
                    errorDescription = ONE_SITELINK_DESC_MAX_LENGTH < descriptionLength,
                    errors = this.errors[index] || (this.errors[index] = {}),
                    description;

                errors.errorDescriptionLength = false;
                errors.haveSameDescriptions = false;

                if (currentDescription == '*') {
                    this.descriptionCounters.eq(index).html(ONE_SITELINK_DESC_MAX_LENGTH);
                    this.setMod(this.descriptionCounters.eq(index), 'overflow', '');

                    this.updateModelErrorState();
                    return this;
                }

                this.descriptionCounters.eq(index).html(ONE_SITELINK_DESC_MAX_LENGTH - descriptionLength);
                this.setMod(this.descriptionCounters.eq(index), 'overflow', errorDescription ? 'yes' : '');

                for (var i = 0; i < SITELINKS_NUMBER; i++) {
                    description = model.get('description' + i);
                    if (!errors.haveSameDescriptions && description != '*' && !!description &&
                        allDescriptions.indexOf(model.get('description' + i)) > -1) {

                        errors.haveSameDescriptions = true;
                    }

                    ONE_SITELINK_DESC_MAX_LENGTH < description.length && (errors.errorDescriptionLength = true);
                    allDescriptions.push(model.get('description' + i));
                }

                this.toggleMod(
                    this.elem('error', 'type', 'equal-descriptions'), 'visible', 'yes', errors.haveSameDescriptions);
                this.toggleMod(
                    this.elem('error', 'type', 'description-length'), 'visible', 'yes', errors.errorDescriptionLength);

                this.updateModelErrorState();

                return this;
            },

            toggleTitleErrors: function() {
                var hasTitleError = false;

                for (var i = 0; i < SITELINKS_NUMBER; i++) {
                    hasTitleError = hasTitleError || this.errors[i].titleLength;
                }

                this.setMod(this.elem('error', 'type', 'length'), 'visible', hasTitleError ? 'yes' : '');
                this.setMod(this.elem('error', 'type', 'total-length'), 'visible', this.errors.titlesLength ? 'yes' : '');
            },

            checkAllTitles: function() {
                var title;

                this.errors.equalTitles = false;

                for (var i = 0; i < SITELINKS_NUMBER; i++) {
                    this.errors[i] = this.errors[i] || {};

                    if (this._isTitleEqualToOther(i)) this.errors.equalTitles = true;
                }

                this.setMod(this.elem('error', 'type', 'equal-titles'), 'visible', this.errors.equalTitles ? 'yes' : '');

                this.updateModelErrorState();

                return this;
            },

            checkHrefErrors: function(index) {
                var elem = this.hrefs.eq(index),
                    href = this.model.get('href' + index),
                    title = this.model.get('title' + index),
                    hrefLength = $.trim(href).length,
                    errorHref = MAX_URL_LENGTH < hrefLength;
                if (this)

                this.errors[index] = this.errors[index] || {};

                if (href == '*') {
                    this.hrefCounters.eq(index).html(MAX_URL_LENGTH);
                    this.setMod(this.hrefCounters.eq(index), 'overflow', '');

                    this.updateModelErrorState();
                    return this;
                }

                this.errors[index].errorLength = errorHref;

                this.errors[index].empty = href && !title || title && !href;

                this.hrefCounters.eq(index).html(MAX_URL_LENGTH - hrefLength);
                this.setMod(this.hrefCounters.eq(index), 'overflow', errorHref ? 'yes' : '');

                if (!this.hasMod(elem, 'focused')) {
                    this.checkAllHrefs();
                    this.checkUrl(index, href);
                }

                this.updateModelErrorState();

                return this;

            },

            checkAllHrefs: function() {
                for (var i = 0; i < SITELINKS_NUMBER; i++) {
                    this.errors[i] = this.errors[i] || {};
                }

                this.updateModelErrorState();

                return this;
            },

            _isTitleEqualToOther: function(index) {
                var isEqual = false,
                    title = this.model.get('title' + index),
                    isTitleEmpty = direct.utils.isEmpty(title);

                if (isTitleEmpty || title == '*') return false;

                for (var i = 0; i < SITELINKS_NUMBER; i++) {
                    if (i != index) isEqual = isEqual || (title == this.model.get('title' + i) && this.model.get('title' + i) != '*');
                }

                return isEqual;
            },

            _isHrefEqualToOther: function(index) {
                var isEqual = false,
                    href = this.model.get('href' + index),
                    isHrefEmpty = direct.utils.isEmpty(href);

                if (isHrefEmpty || href == '*') return false;

                for (var i = 0; i < SITELINKS_NUMBER; i++) {
                    if (i != index) isEqual = isEqual || this.model.get('href' + i) != '*' && this.isLinksEqual(href, this.model.get('href' + i));
                }

                return isEqual;
            },

            isLinksEqual: function(href1, href2) {
                if (direct.utils.isEmpty(href1) || direct.utils.isEmpty(href2)) return false;

                href1 = direct.utils.stripWww(direct.utils.stripHttp(href1));
                href2 = direct.utils.stripWww(direct.utils.stripHttp(href2));

                return href1 == href2;
            },

            isEqualToCommonHref: function(index, href) {
                if (!this.hrefModel) {
                    var equalFlag = false,
                        _this = this;

                    this.getMod('multi') == 'yes' && iModelsManager.eachModel(function(id, m) {
                        equalFlag || (equalFlag = _this.isLinksEqual(href, m.get('href')));
                    }, 'campaign&banner:*', 'b-banner-form-href');

                    return equalFlag;
                } else {
                    return this.isLinksEqual(href, this.hrefModel.get('href'));
                }
            },

            updateModelErrorState: function() {
                var hasErrors = this.errors.titlesLength || this.errors.equalTitles;

                for (var i = 0; i < SITELINKS_NUMBER; i++) {
                    hasErrors = hasErrors || this.errors[i].format || this.errors[i].empty ||
                        this.errors[i].titleLength || this.errors[i].errorLength ||
                        this.errors[i].errorDescriptionLength || this.errors[i].haveSameDescriptions;
                }

                //магия с '1' : '' нужна чтобы правильно работала функция isModelEmpty
                this.model.set('has_errors', (hasErrors ? '1' : ''), this);

                return this;
            },


            onModelChange: function(e, data) {
                //если это изменения полей в попапе - то уходим, мы все что надо сделали
                if (data && data.source == this) return;

                this.fillPopupFromModel();
                this.checkAll();

                if (!this.popupa.isShowed()) {
                    this.fillHiddens();
                    this.updateTexts();
                    this.updateSwitcher();
                }

                if (data && data.source != 'copy' && data.source != 'clear') {
                    this.saveInitState();
                }
            },

            fillPopupFromModel: function() {
                var data = this.model.memento();

                for (var i = 0; i < SITELINKS_NUMBER; i++) {
                    this.titles.eq(i).val(data['title' + i] === '*' ? iget('Разные значения в объявлениях') : data['title' + i]);
                    this.setMod(this.titles.eq(i), 'tooltip', data['title' + i] === '*' ? 'yes' : '');

                    this.descriptions.eq(i).val(data['description' + i] === '*' ?
                        iget('Разные значения в объявлениях') :
                        data['description' + i]);
                    this.setMod(this.descriptions.eq(i), 'tooltip', data['description' + i] === '*' ? 'yes' : '');

                    this.hrefs.eq(i).val(data['href' + i] === '*' ? iget('Разные значения в объявлениях') : data['href' + i]);
                    this.setMod(this.hrefs.eq(i), 'tooltip', data['href' + i] === '*' ? 'yes' : '');
                    data['urlProtocol' + i] !== '*' && this.urlProtocols.eq(i).val(data['urlProtocol' + i]);
                }
            },

            checkAllUrls: function() {
                for (var i = 0; i < SITELINKS_NUMBER; i++) {
                    this.model.get('href' + i) != '*' && this.checkUrl(i, this.model.get('href' + i));
                }

                this.updateModelErrorState();
            },

            updateSwitcher: function() {
                this.elem('switcher').length && this.switcher.elem('text').html(this.model.isModelEmpty() ? iget('добавить') : iget('изменить'))
            },

            fillHiddens: function() {
                var title,
                    description,
                    href,
                    urlProtocol;

                for (var i = 0; i < SITELINKS_NUMBER; i++) {
                    title = this.model.get('title' + i);
                    description = this.model.get('description' + i);
                    href = this.model.get('href' + i);
                    urlProtocol = this.model.get('urlProtocol' + i);

                    this.titlesHidden.eq(i).val(title).prop('disabled', !title);
                    this.descriptionsHidden.eq(i).val(description).prop('disabled', !description);
                    this.hrefsHidden.eq(i).val(href).prop('disabled', !href);
                    this.urlProtocolsHidden.eq(i).val(urlProtocol).prop('disabled', !urlProtocol);
                }
            },

            updateTexts: function() {
                var textsArray = [];

                for (var i = 0; i < SITELINKS_NUMBER; i++) {
                    var text = this.model.get('title' + i);
                    text && textsArray.push(text);
                }
                this.text.text(textsArray.join(', '));
            },

            hideHrefWarning: function(index) {
                this.warnings[index] = 0;
                this.errors[index].format = 0;
                this.delMod(this.elem('error', 'type', 'href').eq(index), 'visible');
            },

            showHrefWarning: function(index, warnings, type) {
                if (type == 'origin') {
                    this.warnings[index] = 1;
                }  else {
                    this.errors[index].format = 1
                }
                this.warnings[index] = 1;

                var $error = this.elem('error', 'type', 'href').eq(index);

                //fix DIRECT-18765
                this.setMod($error, 'visible', 'yes');

                $error.html(warnings.join('\n'));

            },

            checkUrl: function(index, url) {
                if (!url.match(/\S/)) {
                    this.hideHrefWarning(index);
                    return;
                }

                var protocol = this.model.get('urlProtocol' + index),
                    hrefWarnings = [];

                if (this.getMod('multi') == 'yes' && !this._isProtocolEqualToOther(index, protocol)) {
                    hrefWarnings.push(iget('В выбранных объявлениях разные протоколы.'));
                }

                if (direct.utils.validateHref(url)) {
                    var _this = this,
                        isEqualDomain = true;

                    direct.UrlCheck.check(url, function(data) {
                        data =  data || {};

                        if (data.url == _this.model.get('href' + index) && !data.code) {
                            hrefWarnings.push(data.text);

                            _this.showHrefWarning(index, hrefWarnings, 'noresponce');
                        } else if (_this.hrefModel && data.code) {
                            isEqualDomain = _this._checkUrlDomain(index, data.domain, _this.hrefModel);
                        } else if (_this.getMod('multi') == 'yes' && data.code) {
                            _this.getMod('multi') == 'yes' && iModelsManager.eachModel(function(id, m) {
                                isEqualDomain && (isEqualDomain = _this._checkUrlDomain(index, data.domain,  m));
                            }, 'campaign&banner:*', 'b-banner-form-href');
                        }

                        if (isEqualDomain) {
                            hrefWarnings.length ?
                                _this.showHrefWarning(index, hrefWarnings, 'equal-to-common-protocol') :
                                _this.hideHrefWarning(index);
                        } else {
                            hrefWarnings.push(iget('Ссылка не ведет на страницу основного сайта'));

                            _this.showHrefWarning(index, hrefWarnings, 'origin');
                        }

                    }, protocol);
                } else {
                    hrefWarnings.push(iget('Адрес сайта не указан или указан неверно'));

                    this.showHrefWarning(index, hrefWarnings, 'validity');
                }
            },

            _isProtocolEqualToOther: function(index, protocol) {
                var equalFlag = true;

                iModelsManager.eachModel(function(id, m) {
                    equalFlag && (equalFlag = protocol == m.get('urlProtocol' + index));
                }, 'campaign&banner:*', 'b-banner-sitelinks');

                return equalFlag;
            },

            updateExternalWarning: function(e, data) {
                if (!this.model.isChanged('input') && !this.hrefModel.isFieldChanged('href')) return;

                this.setMod('error', !this.popupa.isShowed() && (e && e.type == 'exterr' || this.model.get('has_errors')) ? 'yes' : '');

                this.exterr.html(data.text);
            },

            _checkUrlDomain: function(index, domain, model) {
                var domainRedir = model.get('domain_redir') || model.get('domain');  //domain_redir не всегда приходит

                return ('.' + domain).indexOf('.' + domainRedir) != -1 ||
                    ('.' + domain).indexOf('.' + model.get('domain')) != -1;
            },

            saveInitState: function() {
                this.model.fixData();
            },

            rollbackModel: function() {
                this.model.rollback('rollback');
            }
        },
        {

            updateModelFromServer: function(model, array) {
                var data = {};
                for (var i=0; i < SITELINKS_NUMBER; i++) {
                    if (array[i] && array[i].title ) {
                        data['title' + i] = array[i].title || '';
                        data['description' + i] = array[i].description || '';
                        data['href'  + i] = array[i].href || '';
                        data['urlProtocol' + i] = array[i].urlProtocol || '';
                    }
                }
                model.initData(data);
            },

            totalTitleLength: function(model) {
                var l = 0;

                for (var i=0; i < SITELINKS_NUMBER; i++) {
                    if (model.get('title' + i) != '*') {
                        l += $.trim(model.get('title' + i)).length;
                    }
                }

                return l;
            }
        }
    );

})(jQuery);


