(function($){

BEM.DOM.decl('b-banner-tags', {
    onSetMod: {
        'js': function() {

            var params = this.params,
                dropdowna = this.findBlockInside({blockName: 'b-dropdowna'}),
                adgroup_id = params.adgroup_id,
                bid = params.bid,
                cid = params.cid;

            this.__self._byBannerIdCache[adgroup_id] = this;

            !params.tags && (params.tags = {});

            // в случае когда "только для чтения" мы не генерируем дропдаун
            if (dropdowna) {
                this.popupa = dropdowna.getPopup();

                this.popupa.camp = this.findBlockOutside('i-campaign-tags');

                this.popupa
                    .setContent(
                        BEM.HTML.build({
                            block: 'b-banners-tags-popup-content',
                            js: {
                                bids: bid,
                                adgroup_ids: adgroup_id,
                                cid: cid,
                                save_camp_tags_only: params.hasHidden,
                                isSwitcherButton: params.isSwitcherButton,
                                ulogin: params.ulogin
                            },
                            bids: bid,
                            adgroup_ids: adgroup_id,
                            cid: cid,
                            forCampForm: params.hasHidden
                        }));

                params.hasHidden &&
                    this.popupa.on('tags_ids', function(e, data){
                        this.elem('tags-ids').val(data);
                    }, this);
            }
        }
    },

    // считаем количество меток на баннере
    tagsCount: function(){
        var res = 0;

        $.each(this.params.tags, function(i, v){ v && res++ });

        return res;
    },

    setBannersTagsLinks: function(campTags){
        var params = this.params,
            url = params.tagUrl;

        BEM.DOM.update(
            this.elem('tags-link-list'),
            $.map(campTags, function(el){
                var isCurr = el.tag_id == params.currentTagId;
                if (params.tags[el.tag_id]) {
                    return BEM.HTML.build({
                        tag: isCurr || !url ? 'span' : 'a',
                        content: direct.utils.escapeHTML(el.value),
                        attrs: isCurr || !url  ? '' : { href: params.tagUrl + '&tag=' + el.tag_id }
                    });
                }
            }).join(' ') || '&nbsp;'
        );
    }

}, {
    live: function() {
        this.liveInitOnBlockInsideInit('b-dropdowna');
    },
    _byBannerIdCache: {},
    getByBannerId: function(bid){
        return this._byBannerIdCache[bid];
    }
});

})(jQuery);
