(function($){

var spin,
    popup,
    pager,
    wrapper,
    request,
    groupId,
    instance,
    spinTimer,
    popupOwner,
    statuses = {},
    curPages = {},
    PER_PAGE = 2,
    AJAX_URL = '/registered/main.pl',
    BLOCK_MIX = [{
        block: 'b-banners-group-preview',
        elem: 'pager'
    }];

BEM.DOM.decl({ name: 'b-banners-group-preview' }, {

    onSetMod: {

        'js': function() {
            instance = this;

            popup = this.findBlockInside('b-popupa')
                .on('outside-click', function(e) {
                    e.preventDefault();
                }, this)
                .on('hide', function() {
                    this.destructBanners();
                }, this);

            wrapper = this.elem('dynamics');
            spin = this.elem('spin');

            request = BEM.create('i-request_type_ajax', {
                cache: false, //убрал кеш, чтобы обновлялись банеры при смене возрастных меток, все равно скоро переедем на bemhtml, а так сейчас решить быстрее всего
                url: AJAX_URL,
                dataType: 'json',
                callbackCtx: this
            });

            //собираем попап, в дальнейшем в нем будут обновляться только элементы
            BEM.DOM.update(
                wrapper,
                BEM.HTML.build([
                    {
                        block: 'b-banners-group-preview',
                        elem: 'banners',
                        content: ''
                    },
                    {
                        block: 'b-pager',
                        mods: { type: 'ajax' },
                        content: { elem : 'wrapper' },
                        mix: BLOCK_MIX
                    }
                ]),
                function() {
                    //кэшируем, учитывая, что элемент в попапе
                    this.elem('banners');

                    pager = this.findBlockInside(wrapper, 'b-pager').on(
                        'change-page',
                        function(e, data) {
                            this._onChangePage(data.page);
                        },
                        this
                    );
                },
                this
            );

            this
                .bindTo('save', 'click', this.save)
                .bindTo('cancel', 'click', function() {
                    //очищаем измененную информацию только при явном желании пользователя
                    statuses = {};
                    popup.hide();
                });

            BEM.blocks['b-banner-preview']
                .on(
                    'destruct',
                    this._onBannerDestruct,
                    this
                ).on(
                    'deleted',
                    this._onBannerDeleted,
                    this
                ).on(
                    'status-change',
                    this._onBannerChangeStatus,
                    this
                );

            BEM.blocks['b-form-switch'].on(
                'change',
                this._onFormSwitchChange,
                this
            );


        }

    },

    /**
     * Загрузка группы
     * @param {Number} id Идентификатор группы
     * @param {Number} count Количество баннеров группы на текущей странице выборки
     * @param {Number} page Страница выборки баннеров текущей группы
     * @param {Function} callback Функция обратного вызова после получения группы
     * @private
     */
    _loadGroup: function(id, count, page, callback) {
        request.get(
            {
                cmd: 'getAdGroup',
                pid: id,
                page: page,
                count: count,
                ulogin: this.params.ulogin
            },
            callback
        );
    },

    /**
     * Событие смены статуса баннера
     * @param {Event} e
     * @param {Object} data
     * @private
     */
    _onBannerChangeStatus: function(e, data, p) {
        if (data.name == 'statusShow') {
            statuses[data.id] = { statusShow: data.value };

            //b-form-switch не существует
            if (!data.writable) return;

            this.findBlockInside(
                this.elem('banners'),
                {
                    blockName: 'b-form-switch',
                    modName: 'bid',
                    modVal: data.id
                }
            ).val(data.value);
        }
    },

    /**
     * Событие удаления баннера
     * @param {Event} e
     * @param {Object} data
     * @private
     */
    _onBannerDeleted: function(e, data) {
        //очищаем кэш, потому что содержание "страниц" смещается
        request.dropCache();

        data.fromPreview && this.showPreview(groupId, popupOwner);
    },

    /**
     * Событие уничтожения баннера со страницы
     * @param e
     * @param data
     * @private
     */
    _onBannerDestruct: function(e, data) {
        var item = this.findElem(this.elem('banners'), 'item', 'bid', data.id),
            bFormSwitch = this.findBlockInside(item, 'b-form-switch');

            bFormSwitch && bFormSwitch.
                un('change', this._onFormSwitchChange, this)
                .destruct();

        item.remove();
    },

    /**
     * Событие переключения свитчера
     * @param e
     * @param data
     * @private
     */
    _onFormSwitchChange: function(e) {
        var blockParams = e.block.params;

        blockParams.inPreview && this.toggleBannerStatus(blockParams.bid, e.block.val());
    },

    /**
     * Событие выбора новой страницы в b-pager_type_ajax
     * @param {Number} page Номер выбранной страницы
     * @private
     */
    _onChangePage: function(page) {
        this.destructBanners();

        this.showPreview(groupId, popupOwner, page);
    },

    /**
     * Возврашает инстанс попапа
     * @returns {Object}
     */
    getPopup: function() {
        return popup;
    },

    /**
     * Сохранение изменений статуса отоюражения баннеров
     */
    save: function() {
        if ($.isEmptyObject(statuses))
            return popup.hide();

        request.get(
            {
                cmd: 'setBannersStatuses',
                pid: groupId,
                ulogin: this.params.ulogin,
                json_statuses: $.stringify(statuses)
            },
            function(result) {
                if (result && result.success)
                    document.location.reload();
                else
                    alert(iget('Произошла ошибка!'));
            },
            function() {
                alert(iget('Произошла ошибка!'));
            },
            { type: 'post' }
        );
    },

    /**
     * Управление отображением прелоадера (спинера)
     * @param {Boolean} visible
     */
    setLoadingStatus: function(visible) {
        if (visible){
            spinTimer = setTimeout(function() {
                instance.setMod(spin, 'hidden', '');
            }, 500);
        } else {
            clearTimeout(spinTimer);
            this.setMod(spin, 'hidden', 'yes');
        }
    },

    /**
     * Отображение текущей страницы баннеров группы
     * @param {Number} id Идентифицатор группы
     * @param {Element} owner Элемент от которого будет позиционироваться попап
     * @param {Number} [page] Страница выборки
     */
    showPreview: function(id, owner, page) {
        var writable = this.getMod('writable') != 'no';

        popup.isShowed() || popup.show(owner);

        //переменные нужны при переключении по страницам в текущей группе
        groupId = id;
        popupOwner = owner;

        //если страницу не передали, пытаемся взять последнюю выбранную при просмотре
        //если и такой нет, то берем первую
        page = page || (groupId ? curPages[groupId] : 1) || 1;

        //показываем спинер
        this.setLoadingStatus(true);

        this._loadGroup(id, PER_PAGE, page, function(result) {
            var data = [],
                wrapperParams,
                banners = result.banners || [];

            curPages[groupId] = page;

            wrapperParams = {
                perPage: PER_PAGE,
                showFirst: true,
                showLast: true,
                pagerRadius: 2,
                currentPage: page,
                bannersCount: result.count
            };

            //собираем данные для генерации html для баннеров
            for (var i = 0, bl = banners.length; i < bl; i++) {
                var b = banners[i],
                    existsModel = BEM.MODEL.models['b-banner-edit'] && BEM.MODEL.models['b-banner-edit'].storage['campaign&banner:' + b.bid],
                    bModel = BEM.blocks['i-models-manager'].get('campaign&banner:' + b.bid, 'b-banner-edit'),
                    age = bModel.raw('age'),
                    switcherOptions = ['id' + direct.utils.generateId(), 'id' + direct.utils.generateId()],
                    disableChange,
                    statusShow;

                if (b.hash_flags && typeof b.hash_flags.age != 'undefined')
                    age = b.hash_flags.age;

                statusShow = statuses[b.bid] ?
                    statuses[b.bid].statusShow :
                    b.statusShow || bModel.getDefault('statusShow');

                if (statusShow != bModel.getModelStartValue().statusShow)
                    statuses[b.bid] = { statusShow: statusShow };

                disableChange = b.statusModerate != 'Yes' && b.pstatusModerate != 'Yes';

                existsModel || bModel.initData({
                    bid: b.bid,
                    pid: b.pid,
                    age: age,
                    image: b.image,
                    statusShow: statusShow,
                    statusModerate: b.statusModerate,
                    pstatusModerate: b.pstatusModerate,
                    status: b.status
                });

                data.push({
                    block: 'b-banners-group-preview',
                    mods: { bid: b.bid },
                    elem: 'item',
                    content: [
                        writable && {
                            block: 'b-form-switch',
                            mods: {
                                type: 'toggle',
                                theme: 'toggle-m',
                                'is-bem': 'yes',
                                bid: b.bid,
                                disabled: disableChange && 'yes'
                            },
                            mix: [{ block: 'b-banners-group-preview', elem: 'switch' }],
                            js: { inPreview: 'yes', bid: b.bid },
                            name: 'Yes-No',
                            tag: 'span',
                            content: {
                                elem: 'body',
                                mods: { position: 'left' },
                                tag: 'span',
                                content: [
                                    {
                                        elem: 'input',
                                        mix: [{ block: 'b-form-switch', elem: 'input-left' }],
                                        tag: 'input',
                                        attrs: {
                                            type: 'radio',
                                            id: switcherOptions[0],
                                            value: 'Yes',
                                            name: 'Yes-No',
                                            checked: 'checked'
                                        }
                                    },
                                    {
                                        elem: 'label',
                                        mix: [{ block: 'b-form-switch', elem: 'label-left' }],
                                        mods: { active: 'yes' },
                                        tag: 'label',
                                        attrs: { hidefocus: true, unselectable: 'Yes', 'for': switcherOptions[0] },
                                        content: {
                                            elem: 'label-inner',
                                            tag: 'span',
                                            content: iget('вкл')
                                        }
                                    },
                                    {
                                        elem: 'button',
                                        tag: 'span'
                                    },
                                    {
                                        elem: 'input',
                                        mix: [{ block: 'b-form-switch', elem: 'input-right' }],
                                        tag: 'input',
                                        attrs: {
                                            type: 'radio',
                                            id: switcherOptions[1],
                                            value: 'No',
                                            name: 'Yes-No'
                                        }
                                    },
                                    {
                                        elem: 'label',
                                        mix: [{ block: 'b-form-switch', elem: 'label-right' }],
                                        tag: 'label',
                                        attrs: { hidefocus: true, unselectable: 'Yes', 'for': switcherOptions[1] },
                                        content: {
                                            elem: 'label-inner',
                                            tag: 'span',
                                            content: iget('выкл')
                                        }
                                    }
                                ]
                            }
                        },
                        {
                            block: 'b-banner-preview',
                            js: {
                                id: b.bid,
                                cid: window.CAMP_OPTIONS_CID,
                                modelPath: 'campaign&banner:' + b.bid,
                                writable: writable,
                                toFill: $.extend({ data_from_server: 1 }, b)
                            },
                            modelPath: 'campaign&banner:' + b.bid,
                            mods: { id: b.bid, destination: 'group' },
                            number: b.bid,
                            deletable: !!b.deletable,
                            title: b.title,
                            text: b.body,
                            href: common.format.href(b.href, b.statusOpenStat == 'Yes'),
                            domain: b.domain,
                            vcard: b.vcard_id,
                            id: b.bid,
                            age: age,
                            canEdit: this.params.canEdit,
                            'ad-warnings': this.params['ad-warnings'],
                            image: !trDomain && b.image,
                            sitelinks: b.sitelinks && $.map(b.sitelinks, function(sitelink) {
                                sitelink.href = common.format.href(sitelink.href, b.statusOpenStat == 'Yes');

                                return sitelink;
                            }),
                            isTemplateBanner: b.is_template_banner,
                            writable: writable,
                            hash_flags: b.hash_flags,
                            warnings: b.warnings
                        }
                    ]
                });
            }

            //обновляем список баннеров
            BEM.DOM.update(
                this.elem('banners'), //закэшировали ранее, проблем не должно быть
                BEM.HTML.build(data),
                function() {
                    //размеры превью поменялись
                    popup.pos();

                    $.each(this.findElem(this.elem('banners'), 'item'), function(i, item) {
                        var item = $(item),
                            bid = instance.getMod(item, 'bid');

                        if (bid && statuses[bid]) {
                            instance.findBlockInside(item, 'b-banner-preview').setMod('show', statuses[bid].statusShow);
                            instance.getMod('writable') != 'no' && instance.findBlockInside(item, 'b-form-switch').val(statuses[bid].statusShow);
                        }
                    });

                    //обновляем список страниц b-pager_type_ajax
                    BEM.DOM.update(
                        pager.domElem,
                        result.count > PER_PAGE ?
                            BEM.HTML.build(
                                $.extend(
                                    {
                                        block: 'b-pager',
                                        mods: { type: 'ajax' },
                                        elem: 'wrapper',
                                        js: wrapperParams
                                    },
                                    wrapperParams
                                )
                            ) :
                            '',
                        function() {
                            this.setLoadingStatus(false);
                        },
                        this
                    );
                },
                this
            );
        });
    },

    /**
     * Деструктор всех баннеров в попапе группы
     */
    destructBanners: function() {
        $.each(this.findBlocksInside(wrapper, 'b-banner-preview'), function(i, b) {
            b.destruct();
        });
    },

    /**
     * Переключение баннера (показывается/не показывается - statusShow)
     * @param {Number} id идентификатор баннера
     * @param {String} status статус баннера
     */
    toggleBannerStatus: function(id, status) {
        BEM.blocks['i-models-manager'].get('campaign&banner:' + id, 'b-banner-edit').set('statusShow', status);
    }

}, {

    live: false,

    getInstance: function (callback) {
        if (!instance)
            BEM.blocks['b-banners-group-preview'].onFirst('init', function() {
                callback && callback(instance);
            }, this);
        else
            callback && callback(instance);
    }

});

})(jQuery);
