/*
 * Превью баннера вместе с чекбоксом выбора на странице кампании/медиаплана
 */
(function($){
    BEM.DOM.decl({name:'b-banners-list-banner'}, {
        onSetMod: {
            js: function() {

                var _this = this,
                    groupPreview;

                BEM.blocks['b-banners-group-preview'].getInstance(function(instance){
                    groupPreview = instance;
                });

                _this.checkbox = _this.findBlockInside('b-form-checkbox');
                _this.checkbox && _this.checkbox.on('change', function() {
                        _this.model.set('selected', +_this.checkbox.isChecked(), _this)
                    }, _this);


                _this.model =
                    BEM.blocks['i-models-manager'].get('campaign&banner:' + this.params.bid, 'b-banners-list-banner')
                        .onField('selected', 'change', function(e, data) {
                            if (data.source == this) return;

                            // тригерим change для инициализации меток объявления соответствующего этому чекбоксу
                            _this.checkbox.setMod('checked', _this.model.get('selected') ? 'yes' : 'no').trigger('change');
                        })

                        .set('bannerId', this.params.bid)
                        .set('groupId', this.params.pid)

                        .on('scrollTo', function() {
                            $(window).scrollTop(_this.domElem.offset().top)
                        })

                        .initData({'geo_ids': this.elem('geo-ids').val()});

                this.bindTo('group-name', 'click', function(e) {
                    groupPreview.getPopup().isShowed() || groupPreview.showPreview(this.model.get('groupId'), e.data.domElem);
                });

            }
        }
    });

    BEM.blocks['b-model'].register('b-banners-list-banner', {
        fields: {
            'selected': { type: 'flag' },
            'bannerId': { type: 'string' },
            'groupId': { type: 'string', fromServer: 1 },
            'geo_ids': { type: 'string', fromServer: 1 }
        }
    });

})(jQuery);
