(function($){

BEM.DOM.decl('b-banners-tags-popup-content', {
    onSetMod: {
        'js': function() {
            var acceptButton = this.findBlockInside(this.elem('accept'), 'b-form-button'),
                newTagsInput = this.findBlockInside(this.elem('new-tags'), 'b-form-input'),
                bBannerTagsCollection = {},
                popupa = this.findBlockOutside('b-popupa'),
                camp = popupa.camp,

                adgroup_ids = (this.params.adgroup_ids + '').split(','),
                bLength = adgroup_ids.length,
                tags;

            this.newTagsInput = newTagsInput;

            this.adgroup_ids = adgroup_ids;

            this.bBannerTagsCollection = bBannerTagsCollection;

            this.params.multiedit ?
                this.setBannersTags(tags = this.agregateTags(bBannerTagsCollection, adgroup_ids, bLength), camp.getTags(), adgroup_ids) :
                popupa
                    .on('show', function(){

                        this.setBannersTags(tags = this.agregateTags(bBannerTagsCollection, adgroup_ids, bLength), camp.getTags(), adgroup_ids);
                        // change приходится триггерить, для того чтобы стирать ошибку
                        // от выбора большого колличества чекбоксов без изменения содержимого инпута DIRECT-16489
                        newTagsInput.val('').trigger('change');
                    }, this);

            this.params.isSwitcherButton && popupa.trigger('show'); // если свитчер не b-tag, то событие show происходит раньше

            newTagsInput
                .on('validateTags', function(e, errors){
                        this.elem('errors').html(errors);

                        acceptButton.setMod('disabled', errors ? 'yes' : '');
                }, this)
                // т. к. из-за глюка в хроме/сафари мы удалили форму, то нужно дополнительно слушать Enter чтобы сабмитить
                .bindTo('keydown', function(e){ e.keyCode == 13 && !acceptButton.hasMod('disabled') && acceptButton.trigger('click') });

            acceptButton
                .on('click', function(){
                    var campTagsAsHash = camp.getTags(1),
                        campTags = camp.getTags(),
                        ajaxData = {
                            cmd: 'saveAdGroupTags',
                            tags_ids: [],
                            new_tags: newTagsInput._getNormalizedVal(),
                            // флаг говорящий о том, что мы шлём этот ajax из формы создания/редактирования баннера
                            save_camp_tags_only: this.params.save_camp_tags_only,
                            ulogin: this.params.ulogin
                        };

                    // DIRECT-14454
                    // из-за того что в хроме и сафари нельзя создать форму внутри формы,
                    // заменили form на div и теперь чтобы сделать serializeArray()
                    // ищем все элементы формы (на всякий случай все, хотя пока есть только инпуты) внутри этого div-а
                    $.map(this.elem('form').find('input,textarea,select').serializeArray(), function(el) {
                        if (el.name.indexOf('tag_') != -1) {
                            var id = el.name.substr(4);
                            ajaxData.tags_ids.push(id);
                        } else {
                            ajaxData[el.name] = el.value;
                        }
                    });

                    // DIRECT-24073
                    // фильтруем новые метки по следующему принципу:
                    // если в campTags уже есть метка с таким значением, добавляем ее в tags_ids
                    // если нет - оставляем в new_tags
                    var campTagsValues = $.map(campTags, function(item) { return (item.value || '').toLowerCase(); });
                    ajaxData.new_tags = ajaxData.new_tags.split(',').filter(function(newTag) {
                        newTag = newTag.toLowerCase();
                        var index = campTagsValues.indexOf(newTag);
                        if (index > -1) {
                            var tagId = campTags[index].tag_id;
                            ajaxData.tags_ids.indexOf(tagId) > -1 || ajaxData.tags_ids.push(tagId);
                            return false;
                        } else {
                            return true;
                        }
                    });

                    ajaxData.new_tags = ajaxData.new_tags.join(',');
                    ajaxData.tags_ids = ajaxData.tags_ids.join(',');

                    acceptButton.setMod('disabled', 'yes');
                    $.ajax({
                        type: 'POST',
                        dataType: 'json',
                        url: '/registered/main.pl',
                        data: ajaxData,
                        success: function(data){
                            acceptButton.setMod('disabled', '');
                            if (data.errors) {
                                alert(data.errors.join('\n'));
                            } else if (data.new_tags_as_hash) {
                                // data.new_tags_as_hash - хэш вида {'<текст метки>': {tag_id: <id метки>}}

                                var newCampTags = [];

                                // если ajax дошёл и всё нормально
                                // закрываем попап
                                popupa.hide();

                                ajaxData.tags_ids = ajaxData.tags_ids.split(',');

                                // увеличиваем/уменьшаем счётчики для существующих меток
                                // в соответствии с тем, включили/выключили чекбокс
                                $.each(campTagsAsHash, function(i, v){
                                    var hasTagNow = $.inArray(v.tag_id, ajaxData.tags_ids) != -1,
                                        hadTagBefore = (tags[v.tag_id] || []).length == bLength;
                                    // т. к. в uses_count может быть строка с числом не используем +=
                                    v.uses_count = +v.uses_count
                                        + (hadTagBefore ?
                                            hasTagNow ? 0 : -1 * bLength : // если был раньше и нету сейчас то -1
                                            hasTagNow ? bLength : 0); // если не был раньше и есть сейчас то +1
                                });

                                // дополняем список меток кампании
                                $.each(data.new_tags_as_hash, function(i, v){
                                    ajaxData.tags_ids.push(v.tag_id);

                                    campTagsAsHash[i] ?
                                        campTagsAsHash[i].uses_count++ :
                                        campTagsAsHash[i] = { tag_id: v.tag_id, uses_count: bLength }
                                });


                                // переводим из хэша в массив
                                $.each(campTagsAsHash, function(i, v){
                                    newCampTags.push({
                                        value: i,
                                        tag_id: v.tag_id,
                                        uses_count: v.uses_count
                                    });
                                });
                                camp.setTags(newCampTags, 1);

                                // проставляем галочки в чекбоксы
                                $.map(adgroup_ids, function(elem){
                                    var bBannerTags = bBannerTagsCollection[elem],
                                        tagsCount = bBannerTags.tagsCount(),
                                        isTaggedBefore = tagsCount == 0,
                                        pTags = bBannerTags.params.tags;

                                    $.map(newCampTags, function(el){
                                        var id = el.tag_id,
                                            hasTagNow = $.inArray(id, ajaxData.tags_ids) != -1,
                                            allHadTagBefore = (tags[id] || []).length == adgroup_ids.length;

                                        pTags[id] =
                                            hasTagNow ?
                                                1 :
                                                allHadTagBefore ?
                                                    0 :
                                                    pTags[id];
                                    });

                                    // важно перевычислять tagCount т. к. он мог измениться
                                    if (isTaggedBefore != (bBannerTags.tagsCount() == 0)) // isTaggedBefore != isTaggedNow
                                        // меняем колличество объявлений, не отмеченных метками
                                        camp.untaggedBannersNum(camp.untaggedBannersNum() + (isTaggedBefore ? -1 : 1));
                                });

                                // дорисовываем надписи меток под баннерами
                                $.map(adgroup_ids, function(el){
                                    bBannerTagsCollection[el].setBannersTagsLinks(newCampTags);
                                });

                                popupa.trigger('tags_ids', ajaxData.tags_ids.join(','));

                            }
                        },
                        error: function(e){
                            alert(iget('Ошибка соединения!'));
                        }
                    })
                }, this);

            this.findBlockInside(this.findElem('cancel'), 'b-form-button')
                .on('click', function(){ popupa.hide() }, this);

        }
    },

    setBannersTags: function(bannerTags, campTags, adgroup_ids){
        // bannerTags: {<id-метки>: [<bid>,<bid>,..,<bid>]}

        var cont = [],
            _this = this,
            separator = 'i';

        // подсчитываем количество выбранных для баннера/баннеров меток
        _this._checkedTagsCounts = {};
        $.map(adgroup_ids, function(adgroup_id){ _this._checkedTagsCounts[adgroup_id] = 0 }); // обнуляем на старте

        _this.adgroup_ids = adgroup_ids;

        $.map(campTags || [], function(el){
            var id = BEM.HTML.Ctx.prototype.generateId(),
                currTag = bannerTags[el.tag_id] || [];

            $.map(adgroup_ids, function(bid){
                _this.bBannerTagsCollection[bid].params.tags[el.tag_id] ?
                    _this._checkedTagsCounts[bid] += 1 :
                    ''
            });

            cont.push(
                {
                    block: 'b-form-checkbox',
                    mods: {
                        checked: currTag.length === adgroup_ids.length ? 'yes' : undefined,
                        // так как bid-ы это точно цифры, используем в качестве разделителя букву
                        'checked-for': currTag && currTag !== 1 ? currTag.join(separator) : undefined
                    },
                    mix: [{ block: 'b-banners-tags-popup-content', elem: 'tag-checkbox' }],
                    id: id,
                    checkboxAttrs: { name: 'tag_' + el.tag_id }
                },
                { tag: 'label', attrs: { 'for': id }, content: el.value },
                { tag: 'br'}
            )
        });

        BEM.DOM.update(this.elem('checkbox-container'), BEM.HTML.build(cont),
            function(){
                _this.dropElemCache('tag-checkbox');
                $.map(_this.findBlocksInside(_this.elem('tag-checkbox'), 'b-form-checkbox'),
                    function(el){
                        el.on('change', function(){
                            var checkedForArr = el.getMod('checked-for').split(separator),
                                checkedFor = checkedForArr.join(','),
                                isChecked = el.isChecked();

                            $.map(adgroup_ids, function(bid){
                                var isCheckedForBid = new RegExp(bid + '\\b').test(checkedFor);

                                // при мультередактировании, в посчёте отмеченных меток,
                                // учитываем что метка может быть поставлена не у всех объявлений из группы
                                // поэтому не даём снять такую метку путём включения+выключения чекбокса в мультиредактировании

                                _this._checkedTagsCounts[bid] +=
                                    isChecked ?
                                        isCheckedForBid ? 0 : 1 :
                                        isCheckedForBid && checkedForArr.length != adgroup_ids.length ? 0 : -1
                            });

                            _this.newTagsInput.trigger('change');
                        }, el)
                    });
            });

    },

    // для мультиредактирования (и сингл редактирования как частного случая) собираем общий список тэгов
    agregateTags: function(bBannerTags, adgroup_ids, bLength){
        var tags = {};
        $.map(adgroup_ids, function(el){
            bBannerTags[el] = BEM.blocks['b-banner-tags'].getByBannerId(el);
            $.each(bBannerTags[el].params.tags, function(i, v){
                // сохраняем bid-ы баннеров, у которых есть данная метка
                !!v ?
                    tags[i] = (tags[i] || []).concat(el) :
                    '';
            });
        });

        return tags;
    }

}, {

});

BEM.HTML.decl('b-banners-tags-popup-content', {

    onBlock: function(ctx){
        ctx
            .js(true)
            .tParam('multiedit', ctx.param('multiedit') || 0)
            .tParam('forCampForm', ctx.param('forCampForm') || 0)
            .content({ elem: 'form', cid: ctx.param('cid'), adgroup_ids: ctx.param('adgroup_ids') });
    },

    onElem: {

        'form': function(ctx){
            var isMulti = !!ctx.tParam('multiedit');
            ctx
                .content(
                    [
                        { tag: 'h2', content: isMulti ? iget('Общие метки для объявлений') : iget('Метки объявления') },
                        isMulti ?
                            {
                                tag: 'div',
                                attrs: { style: 'margin-bottom: 1em;' },
                                content:  iget('Выбрано объявлений') + ': ' + ctx.param('adgroup_ids').length
                            } :
                            ''
                    ]
                    .concat(
                        $.map(['cid', 'adgroup_ids'], function(el){
                            return { tag: 'input', attrs: { type: 'hidden', name: el, value: ctx.param(el) } }
                        }),
                        { elem: 'checkbox-container' },
                        { elem: 'new-tags', cid: ctx.param('cid') },
                        { elem: 'errors' },
                        { elem: 'accept' }, { elem: 'cancel' }
                    )
                )
        },

        'new-tags': function(ctx){
            ctx
                .content({
                    block: 'b-form-input',
                    mods: { 'has-clear': 'yes', 'mode': 'tags' },
                    js: {
                        tagMaxLength: MAX_TAG_LENGTH,
                        tagsMaxCount: MAX_TAGS_FOR_CAMPAIGN,
                        tagsMaxCountForBanner: MAX_TAGS_FOR_BANNER,
                        cid: ctx.param('cid')
                    },
                    content: { elem: 'hint', content: iget('Новые метки (через запятую)'), tag: 'label' }
                })
        },


        'accept': function(ctx){
            ctx
                .tag('span')
                .content({
                    block: 'b-form-button',
                    mods: { valign: 'middle' },
                    type: 'submit',
                    content: ctx.tParam('forCampForm') ? iget('OK') : iget('Сохранить')
                })
        },
        'cancel': function(ctx){
            ctx
                .tag('span')
                .content({
                    block: 'b-form-button',
                    mods: { valign: 'middle' },
                    type: 'button',
                    content: iget('Отмена')
                })
        }
    }

});

})(jQuery);
