(function($) {
    BEM.DOM.decl({ name:'b-campaign-edit-block', modName: 'ajax-content', modVal: 'yes' }, {

        onSetMod : {

            js: function() {
                this.__base.apply(this, arguments);
                this._ajaxLoader = BEM.create('i-request_type_ajax', {
                    cache: true,
                    url: location.toString(),
                    type: 'POST'
                });
            }

        },

        /**
         *  Обработчик события клика по кнопке редактирования параметров модели
         *  (отображение всплывающего окна редактирования)
         *
         * @returns this
         */
        toggle: function() {
            this.__base.apply(this, arguments);

            var inner = this.getInnerBlock();

            if (inner) {
                inner.fillInputsFromModel();

                return this;
            }

            this._showLoadingSpin();
            this.loadContent();

            return this;
        },

        loadContent: function(callback) {
            this._ajaxLoader.get(this.params.requestParams.data || {},
                function (data) {
                    BEM.DOM.update(this.getPopup().elem('center'), $(data), function() {
                        var inner = this.getInnerBlock();

                        inner.start();
                        inner.onShow();
                        inner.fillInputsFromModel();
                        if ($.isFunction(callback)) callback.call(this);
                    }, this);
                },
                {
                    callbackCtx: this,
                    dataType: 'html'
                }
            );

        },


        initInnerBlock: function(callback) {
            this.innerBlock = this.getPopup().findBlockInside(this.innerBlockName);
            this.loadContent(function() {
                if ($.isFunction(callback)) {
                    callback.call(this);
                }
            });


        },

        _showLoadingSpin: function() {
            BEM.DOM.update(this.getPopup().elem('center'), BEM.HTML.build({
                block: 'b-campaign-edit-block',
                elem: 'loading-spin',
                tag: 'img',
                attrs: {
                    src: '/i/ajax-loader.gif'
                }
            }));
        }
    });
 })(jQuery);
