(function($) {
    var iModelsManager = BEM.blocks['i-models-manager'];

    BEM.DOM.decl({name:'b-campaign-edit-block', baseBlock: 'b-model-block'}, {

        onSetMod : {
            js: function() {
                var _this = this;

                this.modifying = false;
                this.initCommon();
                this.campaignModel = iModelsManager.get('campaign', 'b-campaign-edit');
                this.getSubmitFunction = function() {
                    return _this.onSubmit
                };

                this.innerBlockName = this.params.innerBlockName || this._modelName;
                this.initOnShow && this.setText();
             }
         },

        initCommon: function() {
            this.shortText = this.params.shortText;
            this.initOnShow = this.params.initOnShow;
            this.initConsts();
            this.initModel();
            this.initData();

            this.switcher = this.findBlockOn('button', 'b-form-button')
                 .on('click', this.toggle, this);

            this.model.on('change', this.onExternalChange, this);
             
            if (this.innerBlockName == 'b-context-limit') {
                this.strategyModel = BEM.blocks['i-models-manager'].get('campaign', 'campaign-strategy')
                    .onField('name search_strategy', 'change', this.onExternalChange, this)
            }
        },

        toggle: function() {
            if (this.getPopup().isShowed()) this.rollbackModel();

            var inner = this.getInnerBlock(),
                tree = this.getPopup().findBlockInside('b-regions-tree');

            inner && inner.start();

            tree && tree.selectTree();
            this.getPopup().toggle(this.switcher.domElem);
            inner && inner.onShow();
        },

        rollbackModel: function() {
            if (this.innerBlockName == 'b-time-targeting') {
                this.model.rollback(this, ['is_autobudget']);
            } else {
                this.model.rollback(this);
            }
        },


        onSubmit: function() {
            var inner = this.getInnerBlock();

            if (!inner) return;

            var validated = this.model.validate();
            if (!validated) {
                return false;
            }

            inner.finish();
            if (this.params.needToConfirm && $.isFunction(inner.confirm) && !inner.confirm()) {
                this.rollbackModel();

                return false;
            }

            this.fillToServerFromModel();
            this.model.fixData();
            this.getPopup().hide();
            this.setText();
            this.setButtonText()
        },

        setButtonText: function() {
            var block = BEM.blocks[this.innerBlockName];

            if (block) {
                var text = block.getButtonText(this);
                this.switcher.elem('text').html(text);
            }
        },

        setText: function() {
            var block = BEM.blocks[this.innerBlockName];
            if (block) {
                var text = block.getText(this);
                text = this.params.shortText ? direct.utils.hellipCut(text, 50) : text;
                this.elem('content').length > 0 && this.elem('content')[this.params.hasHTML ? 'html' : 'text'](text)
            }
        },

        onCancel: function() {
            this.rollbackModel();
            this.getPopup().hide();
        },

        getPopup: function() {
             if (this.popupa) { return this.popupa; }

            this.popupa = this.findBlockInside('b-popupa')
                   .on('outside-click', function(e) {
                       e.preventDefault();
                   })
                   .bindTo('close', 'click', $.proxy(this.onCancel, this));
            this.submit = this.popupa.findBlockOn(this.popupa.elem('submit'), 'b-form-button')
                .on('click', this.getSubmitFunction(), this);
            this.cancel = this.popupa.findBlockOn(this.popupa.elem('cancel'), 'b-form-button')
                .on('click', this.onCancel, this);

            var _this = this;

            this.__self.on('open', function(e, elem) {
                if (elem != _this && _this.popupa.isShowed()) {
                    _this.popupa.hide();
                }
            }, this);

            var inner = _this.getInnerBlock();

            this.popupa.on('show', function() {
                inner && inner.fillInputsFromModel();
                _this.__self.trigger('open', _this);
            });

            return this.popupa;
        },


         //вот прямо сейчас идут изменения
        isModifying: function() {
            return this.popupa && this.popupa.isShowed() || this.modifying;
        },

        initConsts: function() {
            this._modelPath = 'campaign';
            this._modelName = this.params.modelName;
        },

        getInnerBlock: function() {
            return this.innerBlock || (this.innerBlock = this.getPopup().findBlockInside(this.innerBlockName));
        },

        initInnerBlock: function(callback) {
            this.innerBlock = this.getPopup().findBlockInside(this.innerBlockName)
            if ($.isFunction(callback)) {
                callback.call(this);
            }
        },

        onExternalChange: function(e, data) {
            if (!this.isModifying()) {
                this.modifying = true;
                if (this.innerBlock) {
                    this.innerBlock.onExternalChange(e, data);
                    this.doAfterExternalChange(e, data);
                } else {
                    if (this.getMod('init-on-change') != 'yes') {
                        var block = BEM.blocks[this.innerBlockName];
                        if ($.isFunction(block.onExternalChange)) {
                            block.onExternalChange(this, e);
                        }
                        this.doAfterExternalChange(e, data);
                    } else {
                        this.initInnerBlock(function() {
                            this.innerBlock.onExternalChange(e, data);
                            this.doAfterExternalChange(e, data);
                        })
                    }
                }


            }
        },

        doAfterExternalChange: function(e, data) {
            this.modifying = false;
            this.fillToServerFromModel();
            this.setText();
        }
    });

 })(jQuery);


