(function($, Lego) {

    var CHANGE_VCARD_WARNING = iget('Вы изменили контактную информацию! При сохранении установленная ЕДИНАЯ контактная информация будет у всех объявлений одинаковой, активные объявления будут отправлены на модерацию. Сохранить?');

    BEM.blocks['b-model'].register('b-campaign-edit', {
        fields: {
            'statusMetricaControl': { type: 'flag', fromServer: 1, toServer: 1, input: 1 },
            'statusOpenStat': { type: 'flag', fromServer: 1, input: 1 },
            'notify_metrica_control_sms': { type: 'flag', fromServer: 1, input: 1 },
            'is_media': { type: 'flag', fromServer: 1 },
            'new_camp': { type: 'flag', fromServer: 1 },
            'agency': { type: 'string' },
            'add_to_old_camp': { type: 'flag', fromServer: 1 },
            'cid': { type: 'string', fromServer: 1 },
            'ulogin': { type: 'string', fromServer: 1 },
            'sms_phone': { type: 'string', 'default': '', value: '', fromServer: 1 },
            'campaign_name': { type: 'string', input: 1, fromServer: 1, toServer: 1 },
            'fio': { type: 'string', input: 1, fromServer: 1, toServer: 1 },
            'servicing_request': { type: 'flag', input: 1, fromServer: 1, toServer: 1 },
            'start_date': { type: 'string', input: 1, fromServer: 1, toServer: 1 },
            'finish_date': { type: 'string', input: 1, fromServer: 1, toServer: 1 },
            'autoOptimization': { type: 'flag', input: 1, fromServer: 1, toServer: 1 },
            'AgencyUID': { type: 'string', input: 1, fromServer: 1, toServer: 1 },
            'ManagerUID': { type: 'string', input: 1, fromServer: 1, toServer: 1 },
            'ci_hidden': { type: 'flag', fromServer: 1 },
            'with_ci': { type: 'flag', fromServer: 1, toServer: 1, input: 1 },
            'status_click_track': { type: 'flag', fromServer: 1, toServer: 1, input: 1 },

            //только в баяне
            'rf': { type: 'string', input: 1, fromServer: 1, toServer: 1 },
            'rfReset': { type: 'string', input: 1, fromServer: 1, toServer: 1 },
            'autobudget': { type: 'flag', input: 1, fromServer: 1, toServer: 1 },
            'autobudget_date': { type: 'string', input: 1, fromServer: 1, toServer: 1 },
            'product_type': { type: 'string', input: 1, fromServer: 1, toServer: 1 }


        },

        childModels: {
            'b-vcard-form': {
                condition: function() {
                    return this.get('with_ci') && !this.get('add_to_old_camp')

                }
            }
        },

        validateRules: {
            'campaign_name': { list: [ {name: 'required', id: 'required', text: iget('Не заполнено поле "Название кампании"') } ] },
            'fio': { list: [ {name: 'required', id: 'required', text: iget('Не заполнено поле "ФИО"')}] },
            'start_date': { list: [ {name: 'required', id: 'required', text: iget('Вы должны указать дату старта кампании') } ] }
        }
    });

    BEM.DOM.decl({name:'b-campaign-edit', baseBlock: 'b-model-block'}, {
        onSetMod: {
            js: function() {
                var self = this;
                self.__base();

                self
                    .bindTo('form', 'keypress', function(e) {
                        return e.keyCode != 13;
                    })

                    .bindTo('collapser', 'click', function() {
                        self.setMod('collapsed', 'yes')
                    })

                    .bindTo('expander', 'click', function() {
                        self.setMod('collapsed', 'no')
                    })

                    .bindTo('submit', 'click', self.onSubmit);

                self.vcardModel = BEM.blocks['i-models-manager'].get('campaign', 'b-vcard-form');

                self.getControl('statusOpenStat') && self.getControl('statusOpenStat').bem.on('change', function() {
                    var checked = self.getControl('statusOpenStat').bem.isChecked();
                    self.model.set('statusOpenStat', checked);
                    if (checked) {
                        self.model.set('status_click_track', 1);
                        alert(iget('Пожалуйста, убедитесь в том, что параметр _openstat=... в URL не конфликтует с вашим сайтом, и сервер корректно отображает соответствующие страницы!'));
                    }
                });

                self.model
                    .onField('product_type', 'change', function() {
                        self.setMod('product-type', self.model.get('product_type').replace('_', '-'));
                    })
                    .onField('add_to_old_camp', 'change', function() {
                        self.setMod('to-old-camp', self.model.get('add_to_old_camp') ? 'yes' : 'no');
                        self.elem('server-errors').addClass('g-hidden')
                    })


                BEM.blocks['b-changing-warning'].bindEvents(this.hasChanges);

                if (self.elem('pay-empty-cbx').length) {
                    self.payEmptyCbx = this.findBlockOn(this.elem('pay-empty-cbx'), 'b-form-checkbox')
                    self.payEmptyStatus = self.payEmptyCbx.isChecked();
                }
            },

            'product-type': function(modName, modVal) {
                if (!this.elem('pay-empty-cbx').length) return;

                if (modVal == 'mcb-pkg') this.payEmptyStatus = this.payEmptyCbx.isChecked();
                this.payEmptyCbx
                    && this.payEmptyCbx
                        .setMod('disabled', modVal == 'mcb-pkg' ? 'yes' : 'no')
                        .setMod('checked', modVal == 'mcb-pkg' || !this.payEmptyStatus ? 'no' : 'yes');
            }
        },

        hasChanges: function() {
            var hasChanges = false,
                editModelsGroup = [
                    BEM.blocks['i-models-manager'].get('campaign', 'b-campaign-edit')
                ],
                modelNames = ['b-email-notification', 'b-sms-notification',
                    'b-time-targeting', 'b-regions-tree', 'b-context-limit',
                    'b-dont-show', 'b-disabled-ips', 'b-metrika-counter'

                ];

            if (editModelsGroup[0].get('with_ci')) {
                modelNames.concat(['b-vcard-form', 'b-vcard-form-map', 'b-vcard-form-address', 'b-ogrn-input']);
            }
            $.each(modelNames, function(i, name) {
                editModelsGroup.push(BEM.blocks['i-models-manager'].get('campaign', name))
            });
            editModelsGroup && $.each(editModelsGroup, function(i, model) {
                if (model.isChanged('toServer')) { hasChanges = true; return false; }
            });

            return  hasChanges;
        },

        validate: function() {
            if (this.params.disableValidation && this.params.disableValidation != '0') return true;

            if (this.model.get('add_to_old_camp')) {
                this.model.trigger('add-to-old-camp');
                return false;
            }

            this.elem('server-errors').addClass('g-hidden');
            if (this.model.get('finish_date') && Date.fromString(this.model.get('finish_date'), 'yyyy-mm-dd').getTime() < (new Date()).zeroTime().getTime()) {
                if (!confirm(iget('Установленная дата окончания кампании меньше текущей! Сохранить?'))) return false
            }

            if (!this.model.validateModel(1)) {
                var elemForScroll =
                    !this.model.hasErrors() && this.vcardModel.hasErrors() ?
                        this.elem('vcard') :
                        this.domElem;

                $(window).scrollTop(elemForScroll.offset().top);

                return false;
            }

            // DIRECT-23538: Показываются предупреждения об изменении ЕКИ, хотя изменения не сохранялись.
            this.model.get('with_ci') || this.vcardModel.reset();

            //если редактируется уже созданная кампания
            if (!this.model.get('new_camp')) {
                if (this.vcardModel.isChanged('toServer') || this.model.isFieldChanged('with_ci')) { // если данные визитки изменены
                    return confirm(iget(CHANGE_VCARD_WARNING))
                }
            }

            return true;
        },

        getWarningPopup: function(text) {
            if (this._warningPopup) {
                this._warningPopup.elem('warning-popup-text').text(text);
                return this._warningPopup;
            }

            var popupHtml = $(BEM.HTML.build({
                block: 'b-popupa',
                mix: [{ block: 'b-campaign-edit', elem: 'warning-popup' }],
                mods: { direction: 'fixed', 'has-close': 'yes' },
                content: [{
                    elem: 'content',
                    content: [
                        {
                            elem: 'text',
                            mix: [{ block: 'b-campaign-edit', elem: 'warning-popup-text' }, { block: 'b-icon-text' }],
                            content: [
                                {
                                    block: 'b-icon',
                                    mix: [{ block: 'b-icon-text', elem: 'icon' }],
                                    mods: { 'size-16': 'notice' }
                                },
                                {
                                    block: 'b-popupa',
                                    elem: 'warning-popup-text'
                                }
                            ]
                        },
                        {
                            elem: 'controls',
                            content: {
                                block: 'b-form-button',
                                mix: [{ block: 'b-popupa', elem: 'ok' }],
                                mods: { type: 'button' },
                                content: iget('OK')
                            }
                        }
                    ]
                }]
            })).appendTo(document.body);

            this._warningPopup = this.findBlockOn(popupHtml, 'b-popupa');
            this._warningPopup.elem('warning-popup-text').text(text);
            this._warningPopup.findBlockOn('ok', 'b-form-button')
                .on('click', function() {
                    this.elem('form').submit();
                }, this);

            return this._warningPopup;
        },


        onSubmit: function() {
            if (this.validate()) {
                var switcher = this.findBlockInside('b-vcard-form-switcher');

                switcher && switcher.elem('hidden').val(this.model.get('with_ci'));
                BEM.blocks['b-changing-warning'].unbindEvents();
                if (this.model.get('status_click_track') && this.model.isFieldChanged('status_click_track')) {
                    if (this.model.get('statusOpenStat') && this.model.isFieldChanged('statusOpenStat')) {
                        var text = iget('Внимание! Вместе с внешними системами статистики будет включена настройка разметки ссылок для Метрики. Вы можете отключить настройку в параметрах кампании');
                    } else {
                        var text = iget('Внимание! В ссылки, ведущие с рекламного объявления, будет подставляться дополнительный параметр. Убедитесь в том, что использование параметров в URL не конфликтует с программным обеспечением вашего сайта и сервер корректно отображает соответствующие страницы');
                    }
                    this.getWarningPopup(text).show(this.domElem);
                } else {
                    this.elem('form').submit();
                }
            }
        }
    });

})(jQuery, window.Lego);
