(function($) {
    //формат даты в модели
    var modelDateFormat = 'yyyy-mm-dd',
    //формат даты, который отображается в текстовом инпуте
        viewDateFormat = 'dd mmm yyyy';

    var START_DATE =  Date.fromString('1996-01-01', modelDateFormat),
        END_DATE = Date.fromString('2100-01-01', modelDateFormat),
        CURRENT_DATE = (new Date()).zeroTime();

    BEM.DOM.decl({name:'b-campaign-form-date', baseBlock: 'b-model-block'}, {
        onSetMod : {
            js: function() {
                var self = this;
                self.__base();
                self.startDate = this.findBlockInside('start-date-control', 'b-date-input');
                self.finishDate = this.findBlockInside('finish-date-control', 'b-date-input');
                self.startDate.on('change', function() {
                    var date = this.value();
                    self.model.update({'start_date':  date}, this);
                    self.finishDate && self.finishDate.setFinishBounds(date)
                });
                self.finishDate && self.finishDate.on('change', function() {
                    self.model.update({'finish_date':  this.value()}, this);
                });
                self.init();

                this.updateFromModel('start');
                this.updateFromModel('finish');
            }
        },

        initConsts: function() {
            this._modelPath = 'campaign';
            this._modelName = 'b-campaign-edit';
        },

        bindEvents: function() {
            this.__base();
            this.model.onField('start_date', 'change', function() {
                this.updateFromModel('start');
            }, this);
            this.model.onField('finish_date', 'change', function() {
                this.updateFromModel('finish');
            }, this)

        },

        setFinishBounds: function(startDate) {
            startDate = Date.fromString(startDate, modelDateFormat);

            if (startDate && this.model.get('finish_date') &&
                (startDate.getTime() > Date.fromString(this.model.get('finish_date'), modelDateFormat).getTime())) {
                alert(iget('Дата начала не может быть позже даты окончания.'));
                this.delFinishDate({}, true)
            }
        },

        addFinishDate: function() {
            this.setMod('has-finish', 'yes');
        },

        delFinishDate: function(e, noWarining) {
            if (!!this.model.get('finish_date') && !noWarining) {
                alert(iget('Дата окончания будет сброшена. Показы будут идти до окончания денежных средств на кампании.'));
            }
            this.setMod('has-finish', 'no')
            this.finishDate && this.finishDate.clearDate();
        },

        updateVisibility: function() {
            this.setMod('has-finish', this.model.get('finish_date') ? 'yes' : 'no');
        },



        updateFromModel: function(type) {
            var datestr = this.model.get(type + '_date') || '';
            if (type == 'start' && this.startDate) {
                this.startDate.updateExternal(datestr);
                this.setFinishBounds(datestr);
            }

            if (type == 'finish' && this.finishDate) {
                this.finishDate.updateExternal(datestr);
                this.updateVisibility();
            }
        },


        bindDateEvents: function() {
            var self = this;
            this.startDate.bindTo('hidden', 'change', function() {
                var value = self.startDate.elem('hidden').val();
                if (value) {
                    self.setFinishBounds(value);
                }
            });

            this.finishDate && this.finishDate.bindTo('hidden', 'change', function() {
                 self.updateVisibility();
            })
        },



        init: function() {
            this.bindTo('finish-add', 'click', this.addFinishDate);
            this.bindTo('finish-del', 'click', this.delFinishDate);
            this.createDatePickers();
            this.bindDateEvents();
            if (this.params.mcbPkgActive) {
                this.startDate.setDisabled(true)
            }
        },

        createDatePickers: function() {
            this.startDate.createDatePicker({start: START_DATE, end: END_DATE})
            this.finishDate && this.finishDate.createDatePicker({start: CURRENT_DATE, end: END_DATE})
        }

    });



})(jQuery);


