(function($){

    var campsData = {};

    BEM.DOM.decl('b-campaign-list-price', {
        onSetMod: {
            'js': function(){
                var _this = this;
                this.popup = this.findBlockInside('b-popupa');
                this.bindTo('toggle', 'click', this.toggle);

                BEM.blocks['b-prices-constructor'].setValueFunction = this.setValue;
                BEM.blocks['b-prices-constructor'].getValueFunction = this.getValue;
                BEM.blocks['b-prices-constructor'].closeFunction = function() {
                    _this.popup.toggle();
                };
            }
        },

        openPopup: function(elem) {
            BEM.blocks['b-prices-constructor'].setCampaignId(this.cid);
            this.popup.toggle(elem);
        },

        toggle: function(e) {
            if (!this.popup.isShowed()) {
                var elem = e.data.domElem, _this = this;
                this.cid = this.getMod(elem, 'cid');
                !campsData[this.cid] ? this.getValueAjax(function(){ _this.openPopup(elem); }) : this.openPopup(elem);
            } else {
                this.popup.toggle();
            }

        },

        setValue: function(v) {
            var value = $.stringify(v);
            campsData[this.cid] = value;
            try {
                $.ajax({
                    type: 'POST',
                    url: '/registered/main.pl',
                    data: {
                        cmd: 'ajaxCampOptions',
                        cid: this.cid,
                        offline_price_editor: value
                    },
                    dataType: 'json'
                });
            } catch(e) {}
        },

        getValue: function(callback) {
            var v;
            try {
                v = JSON.parse(campsData[this.cid]);
            } catch(e) {}
            callback(v);
        },

        getValueAjax: function(callback) {
            var _this = this;
            $.ajax({
                type: 'POST',
                url: '/registered/main.pl',
                data: {
                    cmd: 'ajaxCampOptions',
                    cid: this.cid,
                    get_camp_options: 1
                },
                dataType: 'json',
                success: function(data) {
                    campsData[_this.cid] = data['offline_price_editor']
                    callback();
                }
            });
        }
    });

})(jQuery);