include('../../js/jq/common/format.js');

(function($, Lego) {
    
var format = common.format,
    listTable = Lego.block['b-list-table'],
    massActions = Lego.block['b-campaign-list__mass-actions'];
    

Lego.block['b-campaign-list'] = function(params) { 
    var $this = $(this),
        model = params.model,         // searchable
        input = params.input,       // чьи события слушать
        rows = $('.b-campaign-list__searchable', this), // пререндеренные строчки по которым будет вестись поиск
        lastQuery = '',             // предыдущее значение
        hltBlocks = [],
        //приходит строка "false"
        onlyFavorites = direct.UserOptions.get('show_favorite_campaigns_only') == "true" ? 1 : 0,
        onlyManagerFavorites = direct.UserOptions.get('show_my_campaigns_only') == "true" ? 1 : 0;


    // инициализация описаний
    listTable.initDescriptions(this);
    // инициализация массовых действий
    listTable.initMassActions(this, massActions.massActionHelpers);
    model.chunkSize    = 10;
    model.chunkTimeout = 42;

    initSearch();

    model.bind('search.found', function(item, iterator) {
        var row = rows.eq(iterator.iteration);
        row.show();

        if (iterator.empty || iterator.visible.length > 0) {
            $('.b-table__pos', row).html(iterator.visible.length);
            highlight(row, iterator);
        } else {
            row.hide();
        }
    });
    
    model.bind('search.missed', function(item, iterator) {
        var row = rows.eq(iterator.iteration);
        row.hide();
    });
    
    model.bind('search.start', function(iterator) {
        iterator.regexp = new RegExp('(' + iterator.query.text.replace(/(.)/g, '[$1]') + ')', 'i');
        iterator.empty = !iterator.query.text.match(/\S/);
        $(params.eventTarget).trigger('search_start');
    });
    
    model.bind('search.finish', function(iterator) {
        $(params.eventTarget).trigger('search_finish', [iterator]);
    });
    
    input.bind('keyup change', function() {
        startSearch();
    });
    
    function startSearch () {
        var query = {
            text: input.val().toLowerCase(),
            onlyFavorites: onlyFavorites,
            onlyManagerFavorites: onlyManagerFavorites
        };
        if (
            query.text == lastQuery.text && 
            query.onlyFavorites == lastQuery.onlyFavorites &&
            query.onlyManagerFavorites == lastQuery.onlyManagerFavorites
        ) return;
        
        lastQuery = query;
        model.search(query);
    }



    function highlight (row, iterator) {
        var description = model.items[iterator.iteration].description.toLowerCase(),
            originalValues = listTable.getOriginalValues(hltBlocks, row, iterator.iteration),
            descriptionMatched = iterator.query.text != '' && description.indexOf(iterator.query.text) != -1;
            
        listTable.getHltBlocks(hltBlocks, row, iterator.iteration).each(function(index) {
            var html = originalValues[index].replace(iterator.regexp, "<span class=\"hlted\">$1</span>");
            if (this.innerHTML != html) this.innerHTML = html;
        });
        $('.description', row)[descriptionMatched ? 'addClass' : 'removeClass']('hlted');
    }

    function initSearch() {
        if (params.favorites && params.favorites.length > 0) {
            params.favorites.bind('b-tabs.changed', function(e, data) {
                onlyFavorites = data.name == 'favorites';
                if (params.shouldSaveFavorites) { // do not store favorites option for managers
                    direct.UserOptions.set('show_favorite_campaigns_only', onlyFavorites);
                }
                startSearch();
                updateStatLink();
            });
        } else {
            onlyFavorites = 0;
            direct.UserOptions.set('show_favorite_campaigns_only', false);
        }

        if (params.managerFavorites && params.managerFavorites.length > 0) {
            params.managerFavorites.bind('b-tabs.changed', function(e, data) {
                onlyManagerFavorites = data.name == 'favorites';
                direct.UserOptions.set('show_my_campaigns_only', onlyManagerFavorites);
                startSearch();
                updateStatLink();
            });

        } else {
            onlyManagerFavorites = 0;
            direct.UserOptions.set('show_my_campaigns_only', false);
        }

        setTimeout(function() { listTable.fixWidths($this); startSearch(); }, 42);
    }
    function updateStatLink () {
        if (params.allCampaignStatLink && params.allCampaignStatLink.length > 0) {
            var url = params.allCampaignStatLink.attr('href');
            if (onlyFavorites) {
                url += '&show_favorites=1';
            }

            if (onlyManagerFavorites) {
                 url += '&show_for_manager=1';
            }
            params.allCampaignStatLink.attr('href', url)
        }
    } 
    }
   

})(jQuery, window.Lego);
