(function($, Lego) {
    var thisBlock = Lego.block['b-campaign-list__mass-actions'] = function(params){};
    //
    // massActionHelpers: хелперы для массовых операций, дополняют имеющийся
    // у b-list-table "недоделанный" интерфейс.
    //
    // интерфейсы методов зафиксированы в b-list-table, scope нигде явно не фиксируется
    //
    thisBlock.massActionHelpers = {
        notifyItemsWithoutAction: function(withoutAction, params) {
            var campaigns = [],
                camp;

            for (var i = 0; i < withoutAction.length; i++) {
                camp = params.actionsInfo[withoutAction[i]];
                campaigns[i] = camp.name + ' (' + String.fromCharCode(8470) + ' ' + camp.cid + ')';
            }

            var text = iget('Выбранное действие недоступно для кампаний: ')
                + campaigns.join(', ')
                + '\n'
                + iget('Продолжить?');

            return confirm(text);
        },

        checkBeforeSubmit: function(action, withAction) {
            if (action == 'delCamp' && !confirm(iget('Вы уверены, что хотите удалить выбранные кампании?'))) return false;
            if (action == 'remoderateCamp' && !confirm(iget('Вы уверены, что хотите ПЕРЕМОДЕРИРОВАТЬ выбранные кампании?'))) return false;
            return true;
        },

        submitForm: function(action, withAction, params) {
            function appendInput(name, val) {
                $('<input/>')
                    .attr({
                        name: name,
                        value:  val,
                        type: 'hidden'
                    })
                    .appendTo($form);
            }

            var $form = $('<form/>').attr({
                action: location.href.replace(/\?.*/, ''),
                method: action == 'showCampStat' ? 'get' : 'post'
            });

            appendInput('cmd', action);

            for (var i = 0; i < withAction.length; i++) {
                appendInput('cid', params.actionsInfo[withAction[i]].cid);
            }

            if (action == 'showCampStat') {
                appendInput('stat_type', 'campdate');
            }

            if (params.ulogin) {
                appendInput('ulogin', params.ulogin);
            }

            if (window.csrf_token) {
                appendInput('csrf_token', window.csrf_token);
            }

            $form
                .appendTo('body')
                .submit();
        }
    };

})(jQuery, window.Lego);
