(function($, Lego) { 
    
Lego.block['b-campaign-list__selectors'] = function(params) {
    var $this = $(this),
        indexes = params.indexes,
        eventTarget = $(params.eventTarget),
        mainInput = params.mainInput || $('.b-cl__selectors__main', $this),
        inputs = $('.b-cl__selectors__checkbox', $this),
        visibleMap = {};
        
    // treat all as visible by default
    $.each(indexes, function(i, v) {
        visibleMap[v] = true;
    });
    
    mainInput.click(function() {
        for (var i=0; i < indexes.length; i++) {
            if (visibleMap[indexes[i]]) inputs[i].checked = this.checked;
        };
        notifySelectedChanged();
    });
    
    inputs.click(function() {
        var allChecked = true,
            anyChecked = false;
        inputs.each(function(i, input) {
            if (visibleMap[indexes[i]]) {
                if (!input.checked) {
                    allChecked = false;
                    return false;
                }
                anyChecked = true;
            }
        });
        mainInput.prop('checked', allChecked && anyChecked);
        notifySelectedChanged();
    });
    
    function notifySelectedChanged() {
        var selected = [],
            selectedMap = {};
        
        $.each(indexes, function(i, v) {
            if (visibleMap[v] && inputs[i].checked) {
                selected.push(v);
                selectedMap[v] = true;
            }
        });
        var eventObj = { 
            selectedMap: selectedMap, 
            selected: selected, 
            indexes: indexes 
        };
        
        eventTarget.triggerHandler('selection_change', [eventObj]);
    }
    
    eventTarget.bind('search_start', function(e, params) {
        mainInput.prop('disabled', true);
    });
    
    eventTarget.bind('search_finish', function(e, params) {
        mainInput.prop('disabled', false);
        visibleMap = params.visibleMap;
        inputs.eq(0).triggerHandler('click');
    });
    
};
})(jQuery, window.Lego);
