(function($, Lego) { 
    
Lego.block['b-campaign-list__total'] = function(params) {
    var $this = $(this),
        listModel = params.model,
        indexes = params.indexes,
        eventTarget = $(params.eventTarget),
        emptyMessage = $('.b-list-table__empty', $this),
        toHide = $([]);

    if (params.hideOnEmpty) {
        var hideUntil = $this.prevAll('.b-campaign-list__total__hide-until:eq(0)');
        while (hideUntil[0] != $this[0]) {
            toHide.push(hideUntil[0]);
            hideUntil = hideUntil.next();
        }
        toHide.push($this[0]);
    }
    
    var format = common.format;
        
    eventTarget.bind('search_finish', function(e, eParams) {
        updateTotals(listModel.getTotals(indexes, eParams.visibleMap))
        var visible = $.grep(indexes, function(v) {
            return eParams.visibleMap[v];
        });
        if (params.hideOnEmpty) {
            toHide[visible.length ? 'show' : 'hide']();
        }
        emptyMessage[visible.length ? 'hide' : 'show']();
    });
    
    function updateTotals (totals) {
        $('.total_shows', $this).html(format.number(totals.shows, 0, ' '));
        $('.total_shows_left', $this).html(format.number(totals.showsLeft, 0, ' '));
        $('.total_clicks', $this).html(format.number(totals.clicks, 0, ' '));
        $('.total_sum', $this).html(format.number(totals.sum, 2, ' '));
        $('.total_sum_rest', $this).html(format.number(totals.sumRest, 2, ' '));
    }
    
    updateTotals(listModel.getTotals(indexes));
    
};
})(jQuery, window.Lego);