(function($, Lego) {
    BEM.DOM.decl({name:'b-campaign-metrica-control', baseBlock: 'b-model-block'}, {
        onSetMod: {
            js: function() {
                var self = this;
                self.__base();
                self.count = self.params.count || 0;
                self.smsModel = BEM.blocks['i-models-manager'].get('campaign', 'b-sms-notification');
                self.smsModel.onField('notify_metrica_control_sms', 'change', function() {
                    self.getControl('notify_metrica_control_sms').bem.setMod('checked',  self.smsModel.get('notify_metrica_control_sms') ? 'yes' : '')
                });
                self.getControl('statusMetricaControl').bem.on('change', $.proxy(self.onCheckboxClick, self));
                self.getControl('notify_metrica_control_sms').bem.on('change', $.proxy(function() {
                    self.smsModel.set('notify_metrica_control_sms', self.getControl('notify_metrica_control_sms').bem.isChecked(), self)
                }, self));

            },

            'sms-enabled': function(modName, modVal) {
                if (modVal == 'no' && this.smsModel.get('notify_metrica_control_sms')) {
                    this.smsModel.set('notify_metrica_control_sms', '', this);
                }
                this.smsModel.set('notify_metrica_control_sms_disabled',  modVal == 'yes' ? 0 : 1);
                this.getControl('notify_metrica_control_sms').bem.setMod('disabled', modVal == 'yes' ? '' : 'yes')
            }
        },

        checkCounters: function() {
            var checked = this.getControl('statusMetricaControl').bem.isChecked();
            this.elem('help').toggleClass('g-hidden', !checked);
            this.elem('help2').toggleClass('g-hidden', checked);
            if (checked) {
                if (this.count == 0) {
                    alert(iget('Мониторинг требует установки счетчика Метрики. Пожалуйста, заведите счетчик в разделе "Метрика" и установите на сайте.'));
                }
            }
        },

        onCheckboxClick: function() {
            if (this.params.smsPhone) {
                this.setMod('sms-enabled', this.getControl('statusMetricaControl').bem.isChecked() ? 'yes' : 'no')
                this.checkCounters();
            } else {
                this.checkCounters();
            }
        },

        initConsts: function() {
            this._modelPath = 'campaign';
            this._modelName = 'b-campaign-edit';
        }
    });


})(jQuery, window.Lego);

