(function($) {

    BEM.DOM.decl('b-campaign-navigation-panel', {
        onSetMod : {
            'js' : function() {
                var self = this,
                    height = this.elem('panel').outerHeight() + 10,
                    campModel = BEM.blocks['i-models-manager'].get('campaign', 'b-campaign-view');

                this.currentCorrections = {};
                if (!this.isSimpleView()) {
                    this.elem('tabs').waypoint(function(event, direction) {
                        self.elem('panel').toggleClass('g-hidden', direction == 'up')
                    }, {
                        offset: $.waypoints('viewportHeight') -  height
                    });
                } else {
                    self.elem('panel').css({
                        position: 'static'
                    })
                }

                this.onSaveSuccess();
                this.saveBtn = this.findBlockOn('save-prices', 'b-form-button').on('click', this.savePrices, this);

                $.map(['phrase', 'retargeting'], function(type) {
                    BEM.blocks['i-models-manager'].onGroupField('campaign&banner:*&' + type + ':*', 'b-phrases-list-phrase', {
                        name: 'change',
                        fieldName: 'phrase deleted is_suspended autobudgetPriority autobroker price price_context',
                        callback: $.proxy(self.onModelChange, self)
                    });
                });


                campModel
                    .on('save', this.onSaved, this)
                    .on('error', this.onError, this);

                this
                    .bindTo('corrections-close', 'leftclick', this.correctionsClose)
                    .bindTo('errors-close', 'leftclick', this.errorsPanelClose);

                this.phrasesCorrection = this.findBlockInside('b-phrases-correction')
                    .on('toggle-correction', function(e, data){
                        var code = data[0],
                            description = this.correctionsDescription,
                            _this = this;

                        this.setMod(this.elem('corrections-panel'), code + '-accepted', data[1]);

                        BEM.blocks['i-campaign-ajax-edit'].correctPhrases(code, data[1] == 'on');

                        $.each(this.currentCorrections[code], function(bid, banner) {
                            $.each(banner, function(pid, correction) {
                                //скорректироваться могут только фразы - но не категории и условия ретаргетинга
                                var phraseModel = BEM.blocks['i-models-manager'].get('campaign&banner:' + bid + '&phrase:' + pid, 'b-phrases-list-phrase'),
                                    fieldName = description[code],
                                    initValue, reversedFixation = [];
                                if (data[1] == 'on') {
                                    initValue = correction[fieldName];
                                } else {
                                    if (code == 'unglued') initValue = '';
                                    else if (code == 'stopword-fixated') {
                                        $.map(correction[fieldName], function(el){ reversedFixation.push([].concat(el).reverse()) });
                                        initValue = reversedFixation;
                                    }

                                }
                                phraseModel.initField(fieldName, initValue);

                                //DIRECT-16070
                                phraseModel.fixData();
                                phraseModel.fields[fieldName].trigger('change');
                            })
                        })

                    }, this);

                this.__self.liveBindTo('error-link', 'click', function(e) {
                    var bid = this.getMod(e.data.domElem, 'bid'),
                        bannerModel = BEM.blocks['i-models-manager'].get('campaign&banner:' + bid, 'b-banners-list-banner');
                    bannerModel.trigger('scrollTo');
                });

                this.onDebounceModelChange = $.debounce(function() {
                    this.saveBtnStateToggle(!$.isEmptyObject(this.changed));
                    this.correctionsClose();
                }, 100, this)
            }

        },

        isSimpleView: function() {
            return direct.mobile.isMobile();
        },


        onError: function(e, errors) {
            this.elem('errors-list').html(typeof errors == 'string' ? errors : this.buildErrorsText(errors));
            //не разюлокируем кнопку - если изменения были неудачными - они всё равно откатятся
            //this.saveBtn.delMod('disabled');
            this.saveBtn.elem('text').text(iget('Сохранить'));
            this.setMod('errors', 'yes');
        },


        buildErrorsText: function(errors) {
            var content = [];
            $.each(errors, function(bid, errorsArray) {
                content.push({
                    tag: 'div',
                    elem: 'errors-text',
                    block: 'b-campaign-navigation-panel',
                    content: [
                        {
                            tag: 'span',
                            mods: {'bid': bid},
                            cls: 'b-pseudo-link',
                            block: 'b-campaign-navigation-panel',
                            elem: 'error-link',
                            content: 'M-' + bid
                        },
                        {
                            tag: 'span',
                            content: ':&nbsp'
                        },
                        {
                            tag: 'span',
                            content: direct.utils.escapeHTML(errorsArray.toString())
                        }
                    ]
                })
            });
            return BEM.HTML.build(content);
        },

        errorsPanelClose: function() {
            this.delMod('errors');
        },

        correctionsClose: function() {
            this.delMod('corrections');
//            this.setMod(this.elem('auto-minus-panel'), 'accepted', 'yes');
        },

        saveBtnStateToggle: function(state){
            this.saveBtn.setMod('disabled', state ? 'no' : 'yes');
            this.saveBtn.elem('text').text(state ? iget('Сохранить') : iget('Сохранено'));
        },

        onModelChange: function(e, data) {
            var model = e.data ? e.data.model : '';
            if (model && (!data || data.source != BEM.blocks['i-campaign-ajax-edit'])) {
                var id = model.get('bannerId') + '-' + model.get('phraseId'),
                    isChanged = model.isChanged('toServer');

                isChanged && !this.changed[id] && (this.changed[id] = 1);
                !isChanged && this.changed[id] && (delete this.changed[id]);

                this.onDebounceModelChange();
            }
        },

        onSaved: function(e, data) {
            if (data.status == 'success') {
                var _this = this;
                setTimeout(function() {
                    _this.saveBtnStateToggle(0);
                    _this.correctionsDescription = data.description;
                    _this.onSaveSuccess(data.data);
                }, 150);

            }
        },


        getCorrectionText: function(data, code) {
            var content = [];
            $.each(data, function(bid, banner) {
                content.push({
                    tag: 'li',
                    cls: 'b-campaign-navigation-panel__li-bid',
                    content: [
                        {
                            tag: 'span',
                            content: 'M-' + bid
                        }
                    ]
                });
                $.each(banner, function(pid, data) {
                    var phraseTpl;
                    if (code == 'unglued') {
                        phraseTpl = [
                            {tag: 'span', cls: 'g-common__bold', content: data.phrase},
                            {tag: 'span', cls: 'g-common__italic', content: data.phrase_unglued_suffix}
                        ];
                    } else {
                        $.map(data.fixation, function(fix){
                            data.phrase = data.phrase
                                .replace(new RegExp('((\\s|^)' + fix[0].replace(/\+/g, '\\+') + ')'), '$2<b>' + fix[0] + '</b>')
                        });
                        phraseTpl = {tag: 'span', content: data.phrase}
                    }


                    content.push({
                        tag: 'li',
                        cls: 'b-campaign-navigation-panel__li-auto-minus',
                        content: [
                            {
                                tag: 'span',
                                content: phraseTpl
                            }
                        ]
                    })
                })
            });

            return BEM.HTML.build({
                tag: 'ul',
                content: content

            });
        },


        onSaveSuccess: function(data) {
            var _this = this;

            _this.changed = {};
            this.currentCorrections = data;
            this.correctionsDescription &&
                $.each(this.correctionsDescription, function(i, v){
                    var haveData = data[i] && !$.isEmptyObject(data[i]);

                    _this.setMod(_this.elem('corrections-panel'), i, haveData ? 'yes' : 'no');
                    if (haveData) {
                        _this.setMod('corrections', 'yes');
                        BEM.DOM.update(
                            _this.phrasesCorrection
                                .findBlockInside({blockName: 'b-phrases-correction-item', modName: 'code', modVal: i})
                                .init()
                                .setMod('mode', 'on')// DIRECT-17724 после предыдущего сохранения выставляем в положение ВКЛ.
                                .elem('description'),
                            _this.getCorrectionText(data[i], i));
                    }
                });

        },


        onSaveStart: function() {
            this.correctionsClose();
            this.errorsPanelClose();
            this.saveBtn
                .setMod('disabled', 'yes')
                .elem('text').text(iget('Сохраняется...'))
        },

        savePrices: function() {
            var _this = this;
            //прячем открытые попапы
            BEM.blocks['b-popupa'].trigger('open');
            this.onSaveStart();
            BEM.blocks['i-campaign-ajax-edit'].save(function() {
                _this.saveBtn
                    .setMod('disabled', 'no')
                    .elem('text').text(iget('Сохранить'))
            });
        }
    });





})(jQuery);
