(function($) {
    var iModelManager = BEM.blocks['i-models-manager'];

    BEM.DOM.decl({name:'b-campaign-product-select'}, {
        onSetMod : {
            js: function() {
                this.model = iModelManager.get('campaign', 'b-campaign-edit');
                this.regionModel = iModelManager.get('campaign', 'b-regions-tree');

                if (!this.params.newCampSelected) {
                    this.elem('hidden').prop('disabled', false);
                    this.elem('select').prop('disabled', true);
                }

                this.bindTo('select', 'change', this.onSelectChange);

                this.onSelectChange({}, 1);
            }
        },

        onSelectChange: function(e, isInit) {
            var bCampaignEditBlock = BEM.blocks['b-campaign-edit-block'],
                val = this.elem('select').val(),
                data = { product_type: val };

            //закрываем открытые попапы
            bCampaignEditBlock && bCampaignEditBlock.trigger('open');

            this.elem('hidden').val(val);

            if (val == 'mcb_pkg') {
                data.geo = 225;
                data.geo_text = iget('Россия');
            }

            this.regionModel[isInit ? 'initData' : 'update'](data, this);
            this.model[isInit ? 'initData' : 'update'](data, this);

        }
    });
 })(jQuery);


