(function($) {
     BEM.DOM.decl({name:'b-campaign-select'}, {
         onSetMod : {
             js: function() {
                 var self = this;
                 this.model = BEM.blocks['i-models-manager'].get('campaign', 'b-campaign-edit');
                 this.bindTo('old new', 'click', this.onRadioChange)
                 this.model.on('add-to-old-camp', function() {
                     self.elem('cid').val(self.elem('select').val());
                     self.elem('form').submit();
                 })
                 self.model.update({'agency': self.elem('agency-select').val()});
                 this.bindTo('agency-select', 'change', function() {
                     self.model.update({'agency': self.elem('agency-select').val()})
                 })

             }
         },

         onRadioChange: function() {
             var steps = $('.b-steps').bem('b-steps'),
                 oldSelected = this.elem('old').prop('checked');

             this.elem('agency-select').prop('disabled', oldSelected);
             this.elem('select').prop('disabled', !oldSelected);
             this.model.update({'add_to_old_camp': +oldSelected});

             steps.elem('create').toggleClass('g-hidden', oldSelected);
             steps.elem('select').toggleClass('g-hidden', !oldSelected);
         }
     });
 })(jQuery);


