(function($){

BEM.DOM.decl('b-campaign-tags', {
    onSetMod: {
        'js': function() {
            var _this = this,
                params = this.params,
                tagsBlock = this.findBlockOutside('i-campaign-tags');
            if (!tagsBlock || tagsBlock.length == 0) { return }
            this.camp = tagsBlock.__self.getByCampaignId(params.cid);
            (this.dropdowna || (this.dropdowna = this.findBlockInside({blockName: 'b-dropdowna'})))
                .getPopup()
                    .on('show', function(){
                        this.setContent(
                            BEM.HTML.build({
                                block: 'b-campaign-tags',
                                mix: [ { block: 'b-campaign-tags' } ],
                                elem: 'content',
                                js: { uniqId: params.uniqId },
                                cid: params.cid,
                                editCampaignTagsLink: params.editCampaignTagsLink,
                                tagUrl: params.tagUrl,
                                notViewOnly: params.notViewOnly,
                                tags: _this.camp.getTags(),
                                untaggedBannersNum: _this.camp.untaggedBannersNum()
                            }))
                    })
        }
    }
}, {
    live: function() {
        this.liveInitOnBlockInsideInit('b-pseudo-link');
    }
});

BEM.HTML.decl('b-campaign-tags', {

    onElem: {

        'content': function(ctx){
            var tags = ctx.param('tags');
            ctx
                .tParam('tags', tags)
                .tParam('tagUrl', ctx.param('tagUrl'))
                .content([
                    {
                        tag: 'h2',
                        content: [
                            iget('Метки'),
                            {
                                elem: 'help',
                                tag: 'span',
                                content: [
                                    '(',
                                    {
                                        tag: 'a',
                                        content: iget('что это?'),
                                        attrs: { href: get_help_url('ad-tags') , onclick: 'OpenWindow(this.href, 700, 600); return false;'}
                                    },
                                    ')'
                                ]
                            }
                        ]
                    },
                    { elem: 'tags-container' },
                    ctx.param('notViewOnly') ?
                        { elem: 'edit-link', editCampaignTagsLink: ctx.param('editCampaignTagsLink') } :
                        '',
                    +$.map(tags, function(el){ return el.uses_count }).join('') && // хотябы одна метка используется, т. е. поставлена на баннер
                        tags.length && ctx.param('untaggedBannersNum') > 0 ?

                        { elem: 'untagged-link', untaggedBannersNum: ctx.param('untaggedBannersNum') } :
                        '',
                    { elem: 'foot-clear' }
                ])
        },

        'tags-container': function(ctx){
            var maxThird = Math.round(MAX_TAGS_FOR_CAMPAIGN / 3),
                tags = ctx.tParam('tags'),
                tagsLength = tags.length;
            ctx
                // в зависимости от колличества меток меняем шарину нашего попапа
                .mod('size', tagsLength > 2 * maxThird ? 'l' : tagsLength > maxThird ? 'm' : 's')
                .content(
                    tagsLength ?
                        $.map(tags, function(el){
                            return {
                                tag: 'span',
                                content: [{ elem: 'tag-link', data: el }, ' ']
                            }
                        }) :
                        { tag: 'span', content: iget('У вас ещё нет ни одной метки.') }
                )
        },

        'tag-link': function(ctx){
            var data = ctx.param('data'),
                escapedValue = direct.utils.escapeHTML(data.value);

            ctx
                .tag('span')
                .content([
                    +data.uses_count ? // если метка используется 0 раз, рисуем не ссылку а спан
                        { tag: 'a', content: escapedValue, attrs: { title: iget('Отбор по метке'), href: ctx.tParam('tagUrl') + '&tag=' + data.tag_id } } :
                        { tag: 'span', content: escapedValue },
                    { elem: 'tag-link-counter', tag: 'span', cls: 'g-common__gray', content: data.uses_count }, ' '
                ])
        },

        'edit-link': function(ctx){
            var haveTags = !!ctx.tParam('tags').length;
            ctx
                .tag('a')
                .cls('b-link' + (haveTags ? ' g-common__gray' : ''))
                .attrs({ href: ctx.param('editCampaignTagsLink') })
                .content(haveTags ? iget('Редактировать метки') : iget('Задать метки'))
        },

        'untagged-link': function(ctx){
            ctx
                .tag('span')
                .content([
                    { tag: 'a', cls: 'g-common__gray', content: iget('Показать объявления без меток'), attrs: { href: ctx.tParam('tagUrl') + '&tag=-1' } },
                    { elem: 'untagged-count', tag: 'span', content: ctx.param('untaggedBannersNum') }, ' '
                ])
        }

    }

});


})(jQuery);
