include('../../js/json2.js');


(function($, Lego) {
    Lego.block['b-campaigninfo-show'] = function(params) {
        var $this = $(this),
            curpage = $this.find('.b-campaigninfo-show_curpage'),
            save_selected = params.save_selected,
            actionSelector = $this.find('.b-campaigninfo-show__action-select'),
            actionSubmit = $this.find('.b-campaigninfo-show__action-submit'),
            actionSubmitBem = actionSubmit.hasClass('i-bem') ? $this.find('.b-campaigninfo-show__action-submit').bem('b-form-button') : undefined,
            actionForm = $('.b-campaigninfo-show__action-form'),
            actionFormCmd = actionForm.find('.b-campaigninfo-show__action-form__cmd'),
            actionFormBids = actionForm.find('.b-campaigninfo-show__action-form__bids'),
            actionFormBid = actionForm.find('.b-campaigninfo-show__action-form__bid'),
            actionFormIsCopy = actionForm.find('.b-campaigninfo-show__action-form__is-copy'),
            campModel = BEM.blocks['i-models-manager'].get('campaign', 'b-campaign-view'),
            checkboxes = $this.bem('b-checkboxes-group'),

            popupa = $this.find('.b-campaigninfo-show__popupa'),

        //команды для которых нужно открывать новое окно
            blankTargets = ['sendOptimize', 'copyBannersToMediaplan', 'multieditMediaplan', 'multicopyMediaplan'],
            cmdValues = {
                'edit': 'showCampMultiEdit',
                'editText': 'showCampMultiEditLight',
                'delete': 'delBanner',
                'copy': 'showCampMultiEdit',
                'stop': 'stopBanner',
                'resume': 'resumeBanner',
                'sendBK': 'admSendBK',
                'sendMD': 'admSendMD',
                'archive': 'archiveBanner',
                'unarchive': 'unarchiveBanner'
            };

        // там где попапа нету в ДОМе не пытаемся инитить его в bem
        popupa[0] &&
            (popupa = popupa.bem('b-popupa')).on('outside-click', function(e) { e.preventDefault() }) &&
            (popupa.camp = popupa.findBlockOutside('i-campaign-tags'));

        if (save_selected) {
            var b_s = direct.CampOptions.get('banners_selected'),
                ban_sel = direct.banners_selected = b_s ? JSON.parse(b_s) : {}; // шоткат
        }

        $(document).bind('banners-filter:copyToMediaplan', onCopyEcternalAction);
        if (actionSubmitBem) {
            actionSubmitBem.on('click', onActionSubmit);
        } else {
            actionSubmit.click(onActionSubmit);
        }
        campModel.onField('places_strategy', 'change', $.proxy(onStrategyModeSwitch, this));
        checkboxes.on('change', function(e, data) {


            if (data.mode == 'all') {
                // инитим блок b-banner-tags, для мультиредактирования меток
                var bannerTags = $.find('.b-banner-tags');
                bannerTags[0] &&
                $.each(bannerTags,function(i, elem) {
                    var bannerTagsPopupa = $(elem).bem('b-banner-tags').findBlockInside('b-popupa');
                    bannerTagsPopupa && bannerTagsPopupa._getUnder();
                })
            } else {
                var bannerTags = data.elem.parents('.b-banner-list__layout').find('.b-banner-tags'),
                    bannerTagsPopupa;

                bannerTags[0] &&
                (bannerTagsPopupa = bannerTags.bem('b-banner-tags').findBlockInside('b-popupa'));
                // для DIRECT-14609 перемещаем попап в боди, чтобы его хиден инпуты не замусоривали родительскую форму (конкретно cid)
                bannerTagsPopupa && bannerTagsPopupa._getUnder();
            }

            save_selected && onBannerCheckedChange(checkboxes.getChecked());
        })



        function onStrategyModeSwitch() {
            var selected = campModel.get('places_strategy');
            $this.toggleClass('b-campaigninfo-show_mode_search', 'search' == selected);
            $this.toggleClass('b-campaigninfo-show_mode_context', 'context' == selected);

        }

        function submit(data) {

            if (data.page) {
                curpage.val(data.page);
            }
            $this.submit();
        }

        // Если нужно сохранять выделенные баннеры на сервере
        if (save_selected) {
            // Выделяем сохранённые баннеры
            for (var banner in ban_sel) {
                BEM.blocks['i-models-manager'].get('campaign&banner:' + banner, 'b-banners-list-banner').set('selected', 1);
            }
            BEM.blocks['i-models-manager'].eachModel(function(i, model) {
                model.onField('status', 'change', function(model, bid, phrId) {
                    return function(e) {
                        onPhraseCheckedChange(e, model, bid, phrId)
                    }
                } (model, model.get('bannerId'), model.get('phraseId')), this)
            }, 'campaign&banner:*&phrase:*, campaign&banner:*&retargeting:*', 'b-phrases-list-phrase');
        }

        function onPhraseCheckedChange(e, model, bid, phId) {
            if (e.source == $this) { return; }
            var inArrayPos = $.inArray(phId, ban_sel[bid]);
            if (model.get('status')) {
                if (!ban_sel[bid] || inArrayPos == -1) {
                    return;
                }
                ban_sel[bid].splice(inArrayPos, 1);
            } else {
                if (ban_sel[bid] && inArrayPos != -1) {
                    return;
                }
                if (!ban_sel[bid]) {ban_sel[bid] = []}
                ban_sel[bid].push(phId);
            }
            saveSelectedBanners();

        }

        function onBannerCheckedChange(checked) {
            var _this = $(this);

            ban_sel = {};

            $.each(checked, function(i, bid) {
                ban_sel[bid] = [];
            })


//            BEM.blocks['i-models-manager'].eachModel(function(i, model) {
//                if (ban_sel[model.get('bannerId')] && ban_sel[model.get('bannerId')][model.get('phraseId')]) {
//                    model.set('status', 1)
//                }
//            }, 'campaign&banner:*&phrase:*, campaign&banner:*&retargeting:*,campaign&banner:*&category:*', 'b-phrases-list-phrase');

            saveSelectedBanners();
        }

        function saveSelectedBanners() {
            if ($.stringify(ban_sel) != '{}') {
                direct.CampOptions.set('banners_selected', $.stringify(ban_sel));
            } else {
                direct.CampOptions.remove('banners_selected');
            }
        }




        function onCopyEcternalAction(e, data) {
            actionForm.attr('target', '_blank');
            actionFormCmd.val('copyBannersToMediaplan');
            actionFormBid.val(data.bids);
            actionForm.submit();
            actionForm.removeAttr('target');
        }

        function onActionSubmit() {
            var bids = checkboxes.getChecked(),
                cmd = actionSelector.val(),
                cmdValue = cmdValues[cmd] || cmd,
                overflow;
            if (bids.length == 0) {
                alert(iget('Не выбрано ни одно объявление.'));
                return;
            } else if ((overflow = cmd == 'copy' ? bids.length + params.bannersCount - params.bannersLimit : 0) > 0) {
                alert(iget('Внимание! В результате копирования ограничение в %s объявлений будет превышено на %s. Необходимо уменьшить количество копируемых объявлений.', params.bannersLimit, overflow));
                return;
            } else if (cmd == 'editTags') {
                var jsParams = { bids: bids, cid: params.cid, multiedit: 1, ulogin: params.ulogin };
                popupa
                    .setContent(
                        BEM.HTML.build($.extend({ block: 'b-banners-tags-popup-content', js: jsParams }, jsParams)),
                        function(){ popupa.show() });

                return;
            } else if (cmd == 'editAgeLabels') {
                var jsParams = { bids: bids, cid: params.cid, multiedit: 1 };
                popupa
                    .setContent(
                    BEM.HTML.build($.extend({ block: 'b-age-labels-multiedit', js: jsParams }, jsParams)),
                    function(){ popupa.show() });

                return;
            } else if (cmd == 'editChildAgeLabels') {
                var jsParams = { bids: bids, cid: params.cid, multiedit: 1 };
                popupa
                    .setContent(
                    BEM.HTML.build($.extend({ block: 'b-child-food-labels-multiedit', js: jsParams }, jsParams)),
                    function(){ popupa.show() });

                return;
            } else {
                actionFormBids.add(actionFormBid).val(bids.join(',')); //todo - разобарться что это за остатки от прошлой жизни (двум полям присваивается одно и тоже значение)
            }

            actionFormCmd.val(cmdValue);

            if ( cmd == 'delete' ) {
                if ( ! confirm(iget("Вы действительно хотите удалить объявления?"))) return;
            } else if ( cmd == 'copy' ) {
                actionFormIsCopy.val(1);
            } else if ( cmd == 'multidelMediaplan' ) {
                if ( ! confirm(iget("Вы действительно хотите удалить блок?"))) return;
            } else if ( cmd == 'sendMD' ) {
                if ( ! confirm(iget("Вы действительно хотите отправить выбранные объявления заново на модерацию?"))) return;
            } else if ( cmd == 'sendModerate' ) {
                if ( ! confirm(iget("Вы действительно хотите отправить выбранные объявления на модерацию?"))) return;
            } else if ( cmd == 'clientSendModerate' ) {
                if ( ! confirm(iget("Вы действительно хотите отправить выбранные объявления на модерацию?")) ) return;
            } else if ( cmd == 'moderateAccept' ) {
                if ( ! confirm(iget("Вы действительно хотите ПРИНЯТЬ объявления БЕЗ модерации?")) ) return;
            } else if ( cmd == 'stopAndRemoderateBanner' ) {
                if ( ! confirm(iget("Вы действительно хотите ОСТАНОВИТЬ и ПЕРЕМОДЕРИРОВАТЬ выбранные объявления?")) ) return;
            }
            if ($.inArray(cmd, blankTargets) != -1) {
                actionForm.attr('target', '_blank');
            }

            actionForm.submit();
        }

    };
})(jQuery, window.Lego);


direct.banners_selected = {};
