(function($, Lego) {
    Lego.block['b-campaigninfo-show__optimize__accept'] = function(params) {
        var $this = $(this),
            phraseModels = params.phraseModels || {},
            isEasy = params.easy,
            position = params.position,
            retpath = params.retpath,
            optimizeForm = $this.find('.accept-form'),
            optimizedCampForm = $this.find('.optimized-camp-form'),
            acceptButton = $this.find('.accept__accept-button'),
            acceptOptimizedCampButton = $this.find('.accept__accept-optimized-camp-button'),
            rejectButton = $this.find('.accept__reject-button'),
            postponeButton = $this.find('.accept__postpone-button'),
            retidsHidden = $this.find('.b-campaigninfo-show__optimize__accept__retids'),
            phidsHidden = $this.find('.b-campaigninfo-show__optimize__accept__phids'),
            bidsHidden = $this.find('.b-campaigninfo-show__optimize__accept__bids'),
            bidHidden = $this.find('.b-campaigninfo-show__optimize__accept__bid');

        $this
            .bind('b-campaigninfo-show__optimize__accept-popup_type_first-aid_submit', isEasy ? onSubmitAcceptEasy : onSubmitAccept)
            .bind('b-campaigninfo-show__optimize__accept-popup_type_optimized-camp_submit', onAcceptOptimizedCampMediaplan)
            .bind('b-campaigninfo-show__optimize__reject-popup_type_first-aid_submit', onRejectFirstAid)
            .bind('b-campaigninfo-show__optimize__reject-popup_type_optimized-camp_submit', onRejectOptimizedCampMediaplan);


        acceptButton.click(createPopupHandler('b-campaigninfo-show__optimize__accept-popup_type_first-aid_open'));
        acceptOptimizedCampButton.click(createPopupHandler('b-campaigninfo-show__optimize__accept-popup_type_optimized-camp_open'));
        rejectButton.click(createPopupHandler('b-campaigninfo-show__optimize__reject-popup_type_first-aid_open'));
        rejectButton.click(createPopupHandler('b-campaigninfo-show__optimize__reject-popup_type_optimized-camp_open'));
        postponeButton.click(postponeOptimize);


        function postponeOptimize() {
            addSubmitData(optimizeForm, {
                'cmd': 'ajaxPostponeOptimize',
                'retpath': retpath
            });
            optimizeForm.submit();
        }

        /**
         * Обработчик отправки попапа отклонения медиаплана первой помощи
         * @param {Event} event
         * @param {Object} data Данные формы
         */
        function onRejectFirstAid(event, data) {
            addSubmitData(optimizeForm, data);
            optimizeForm.submit();
        }

        function addSubmitData(form, data) {
            var htmlStr = '';
            for (var i in data) {
                htmlStr += '<input type="hidden" name="' + i + '" value = "' + data[i] + '"></input>'
            }
            form.append(htmlStr);
        }



        function onSubmitAccept(event, data) {
            var bannersNum = 0,
                bids = [], phids = [], retids = [], phrasesNumError,
                bannersModelsGroup = BEM.blocks['i-models-manager'].getGroup('campaign&banner:*', 'b-banners-list-banner');

            $.each(bannersModelsGroup, function(i, bannerModel) {
                var phrasesNum = 0,
                    bid = bannerModel.get('bannerId');

                if (bannerModel.get('selected')) {
                    bannersNum += 1;
                    bids.push(bid);
                }

                BEM.blocks['i-models-manager'].eachModel(function(i, model) {
                    if (model.get('status')) {
                        if (model.get('is_retargeting')) {
                            retids.push(model.get('phraseId'));
                        } else {
                            if (model.get('numword') > 0) {
                               phrasesNum += 1;
                            }
                            phids.push(model.get('phraseId'));
                        }
                    }
                }, 'campaign&banner:' + bid + '&phrase:*,campaign&banner:' + bid + '&retargeting:*', 'b-phrases-list-phrase');

                if ((phrasesNum == 0 && retids.length == 0) && (bannerModel.get('selected') || data['acceptType'] == 'all')) {
                    alert(iget('Ни одна фраза для баннера № П-%s не выбрана!', bid));
                    phrasesNumError = true;
                    return;
                }

            });

            if (phrasesNumError) {
                return;
            }
            if (bannersNum == 0 && data['acceptType'] != 'all') {
                alert(iget('Не выбрано ни одно объявление!'));
                //$this.bind('b-campaigninfo-show__optimize__accept__submitAccept', onSubmitAccept);
                return;
            }

            retidsHidden.val(retids.join(','));
            phidsHidden.val(phids.join(','));
            bidsHidden.add(bidHidden).val(bids.join(','));

            addSubmitData(optimizeForm, data);

            if (direct.CampOptions.get('banners_selected')) {
                direct.CampOptions.remove('banners_selected', function() {
                    optimizeForm.submit();
                });
            } else {
                optimizeForm.submit();
            }

        }

        function onSubmitAcceptEasy(event, data) {
            addSubmitData(optimizeForm, data);
            optimizeForm.submit();
        }



        function createPopupHandler(eventName) {
            return function() {
                $(document)
                    .trigger('b-window_close-all')
                    .trigger(eventName, {id: $this.attr('id'), position: position})
            }
        }

        /**
         * Обработчик отправки попапа принятия медиаплана Оптимизированная кампания
         * @param {Event} e
         * @param {Object} data Данные формы попапа
         */
        function onAcceptOptimizedCampMediaplan(e, data) {
            if (data.is_lego_mediaplan == '1') {
                try {
                    window.yaCounter34.reachGoal('Accept_Lego_Mediaplan');
                } catch (e) {}
            }
            addSubmitData(optimizedCampForm, data);
            optimizedCampForm.submit();
        }

        /**
         * Обработчик отправки попапа принятия медиаплана Оптимизированная кампания
         * @param {Event} e
         * @param {Object} data Данные формы попапа
         */
        function onRejectOptimizedCampMediaplan(e, data) {
            addSubmitData(optimizedCampForm, data);
            optimizedCampForm.submit();
        }

    }


})(jQuery, window.Lego);
