(function($) {

    BEM.DOM.decl('b-campaigninfo-show__optimize__popup', {

        onSetMod: {
            'js': function() {
                this._popup = this.findElem('popup');

                this._popup.bind('b-window_submit', this._onSubmit.bind(this));
                $(document).bind(this._getEventName('open'), this._onOpenPopup.bind(this));
            }
        },

        /**
         * Обработчик открытия попапа
         * @param {Event} e
         * @param {Object} data
         * @returns {Boolean}
         * @private
         */
        _onOpenPopup: function(e, data) {
            this._parent = $('#' + data.id);
            this._popup
                .removeClass('g-hidden')
                .data('api')
                .attach(this._parent[0], data.position == 'top' ?  'right' : 'right top')
                .show();

            return false;
        },

        /**
         * Обработчик принятия формы
         * @private
         */
        _onSubmit: function() {
            this._parent.trigger(this._getEventName('submit'), this._getData());
        },

        /**
         * Возвращает полное имя с учетом имени попапа
         * @param {String} eventName
         * @returns {string}
         * @private
         */
        _getEventName: function(eventName) {
            return this._getName() + '_' + eventName;
        },

        /**
         * Имя контроллера на который отсылаем данные
         * @private
         */
        _getCmd: function() {
            throw 'must be implemented in child';
        },

        /**
         * Имя попапа. Используется для вызова события ее принятия
         * @private
         */
        _getName: function() {
            throw 'must be implemented in child';
        },

        /**
         * Дополнительные поля для запроса принятия медиаплана
         * @private
         */
        _getAdditionalData: function() {
            throw 'must be implemented in child';
        },

        /**
         * Полный список полей для запроса принятия медиаплана
         * @private
         */
        _getData: function() {
            return $.extend({
                cmd: this._getCmd()
            }, this._getAdditionalData());
        }

    });

})(jQuery);
