(function($) {
    BEM.DOM.decl({ name: 'b-campaigninfo-show__optimize__reject-popup', modName: 'type', modVal: 'optimized-camp' }, {

        onSetMod: {
            'js': function() {
                this.__base();

                this._reasonSelect = this.findElem('reason-select');
                this._reasonText = this.findElem('reason-text');
                this._submitButton = this.findElem('submit-button');

                this._reasonSelect.change(this._handleReasonChange.bind(this));
            }
        },

        /**
         * Обработчик выбора значения в селекте причин отказа
         * @private
         */
        _handleReasonChange: function() {
            var rejectReasons = this.params.reject_reasons,
                selectedReasonValue = this._reasonSelect.val();

            rejectReasons.some(function(rejectReason) {
                if (rejectReason.value == selectedReasonValue) {
                    this._showReason(rejectReason);
                    return true;
                }
            }, this);
        },

        /**
         * Показываем данные выбранной причины отклонения
         * @param {Object} rejectReason причина отклонения
         * @private
         */
        _showReason: function(rejectReason) {
            var text = rejectReason.text ?
                rejectReason.text.join('<br>') :
                '';

            this._reasonText.html(text);
            this._setDisabled(false);
            this._resetComment();
            this.setMod(this._reasonText, 'visible', !!text ? 'yes' : 'no');
            this.setMod(this._comment, 'visible', !!text ? 'no' : 'yes');
        },

        /**
         * Дизейблин / активизируем кнопку отправки формы попапа
         * @param disabled
         * @private
         */
        _setDisabled: function(disabled) {
             this._submitButton.prop('disabled', disabled);
        },

        /**
         * Сбрасываем комментарий введенный пользователем
         * @private
         */
        _resetComment: function() {
            this._comment.val('');
        },

        /**
         * Имя попапа
         * @returns {string}
         * @private
         */
        _getName: function() {
            return 'b-campaigninfo-show__optimize__reject-popup_type_optimized-camp';
        },

        /**
         * Название контроллера
         * @returns {string}
         * @private
         */
        _getCmd: function() {
            return 'rejectMediaplan';
        },

        /**
         * Данные для запроса отказа от медиаплана
         * @returns {Object}
         * @private
         */
        _getAdditionalData: function() {
            return {
                reject_comment: this._comment.val(),
                reject_reason: this._reasonSelect.val()
            };
        }

    });
})(jQuery);
