(function($, Lego) {

Lego.block['b-campaigninfo-show__popups__banners-filter__popup'] = function(params) {
    var dataFields = ['cid', 'ulogin', 'has_ctr', 'has_phrases_count', 'has_one_word_phrase', 'has_one_word_phrase', 'has_absent_phrases', 'has_forecast', 'ctr_value', 'phrases_count_value', 'forecast_value']
    var $this = $(this),
        popup = $this.find('.b-campaigninfo-show__popups__banners-filter__popup__popup-container'),
        cancel = popup.find('.b-campaigninfo-show__popups__banners-filter__popup__cancel'),
        submit = popup.find('.b-campaigninfo-show__popups__banners-filter__popup__submit');
    $(document).bind('b-campaigninfo-show__popups__banners-filter_open', openPopup);

    popup.bind('b-window_close', setDefaultValues);
    cancel.click(onCancel);
    submit.click(onSubmit);

    $('#ctr_value').bind('click', {type: 'ctr'}, onSelectValueChange)
    $('#phrases_count_value').bind('click', {type: 'phrases_count'}, onSelectValueChange)
    $('#forecast_value').bind('click', {type: 'forecast'}, onSelectValueChange)

    function onSelectValueChange(event) {
        var type = event.data.type;
        if (type) {
            $('#has_' + type).prop('checked', true)
        }
    }

    function openPopup() {
        popup.removeClass('g-hidden').data('api').show(); return false;
    }

    function setDefaultValues() {
        $('#ctr_value').val(1);
        $('#phrases_count_value').val(25);
        $('#forecast_value').val(500);

        $('#has_ctr').prop('checked', false);
        $('#has_phrases_count').prop('checked', false);
        $('#has_one_word_phrase').prop('checked', false);
        $('#has_absent_phrases').prop('checked', false);
        $('#has_forecast').prop('checked', false);
    }



    function getData() {
        var data = {'cmd' : 'ajaxGetFilteredBanners'}, node;
        $.each(dataFields, function(i, val) {
           node = $this.find('[name=' + val  + ']');
            data[val] = (node.is('[type=checkbox]')) ? +node.prop('checked') : node.val();
        })
        return data;
    }

    function onCancel() {
        popup.data('api').close();
        setDefaultValues();
    }

    function onSubmit() {
        var data = getData()
        $.getJSON('/registered/main.pl', data, onResultLoaded)

        return false;
    }

    function onResultLoaded(res) {
        if (res.count == 0) {
            alert(iget('Не найдено ни одного объявления'));
        } else {

            var resText = res.count + ' ' + common.inflector.pluralizeWord([iget('объявление'), iget('объявления'), iget('объявлений')], res.count)
            if (confirm(iget('%s будет скопировано в медиаплан', resText))) {
                $(document).trigger('banners-filter:copyToMediaplan', {'bids': res.bids});
            }

            popup.hide();
        }
    }

};
})(jQuery, window.Lego);
