/**
 * Created by IntelliJ IDEA.
 * User: heliarian
 * Date: 07.09.2010
 * Time: 15:44:32
 * To change this template use File | Settings | File Templates.
 *
 */

(function($, Lego) {

Lego.block['b-campaigninfo-show__popups__banners-search__popup'] = function(params) {
    var $this = $(this),
        cid = params.cid + params.uidUrl,
        popup = $this.find('.b-campaigninfo-show__popups__banners-search__popup__popup-container'),
        form = $this.find('.banners-search__popup__form'),
        input = $this.find('.banners-search__popup__input'),
        text = $this.find('.banners-search__popup__text'),
        radio = $this.find('.banners-search__popup__radio'),
        cancel = popup.find('.b-campaigninfo-show__popups__banners-search__popup__cancel'),
        submit = popup.find('.b-campaigninfo-show__popups__banners-search__popup__submit');


    var selectSearch = { prev: "num", vals: {} }, 
        texts = {
            num: iget('Номер&nbsp;объявления:&nbsp;М-') + '&nbsp;',
            context: iget('Текст:') + '&nbsp;',
            phrase: iget('Фраза:') + '&nbsp;',
            group: iget('Группа:') + '&nbsp;'
        };

    $(document).bind('b-campaigninfo-show__popups__banners-search_open', openPopup);
    popup.bind('b-window_close', setDefaultValues);
    cancel.click(onCancel);
    submit.click(onSubmit);
    radio.click(doSelectSearch)

    function doSelectSearch(e) {
          var target = $(e.target)
          if (target.prop('checked')) {
              var value = target.val();
              text.html(texts[value]);
              selectSearch.vals[ selectSearch.prev ] = input.val();
              selectSearch.prev = value;
              input.val(selectSearch.vals[value] == null ? '' : selectSearch.vals[value]);
              input.focus();
          }
    }

    function openPopup() {
        popup.removeClass('g-hidden').data('api').show(); return false;
    }

    function setDefaultValues() {
        input.val('');
    }

    function checkSearchForm() {
        var checkedVal = radio.filter(':checked').val(),
            str = input.val();

        if (checkedVal == 'num' && !str.match(/\d+/)) {
            alert(iget('Вы должны ввести номер объявления как число'));
            return false;
        }  else if ((checkedVal == 'context' || checkedVal == 'phrase') && !str.match(/.+/)) {
            alert(iget('Вы должны ввести текст'));
            return false;
        }
        return true;
    }




    function onCancel() {
        popup.data('api').close();
        setDefaultValues();
    }
    function getData() {
        var data = {
            'cmd': 'ajaxGetBannersCount',
            'cid': cid,
            'search_by': radio.filter(':checked').val(),
            'search_banner': input.val()
        };

        var ulogin = form.find('[name=ulogin]');
        if (ulogin.length > 0) {
            data['ulogin'] = ulogin.val();
        }
        return data;


    }

    function onSubmit(e) {
        e.preventDefault();
        if (!checkSearchForm()) {
            return false;
        }
        var data = getData();
        $.getJSON('/registered/main.pl', data, onResultLoaded)
        return false;
    }

    function onResultLoaded(response) {
        if (response != 0) {
            form.submit()
        } else {
            searchAgain()
        }
    }

    function searchAgain() {
        if (! confirm(iget("Ничего не найдено, продолжать поиск?"))) {
          input.val('');
          $(radio.get(0)).prop('checked', true)
          doSelectSearch({target: radio.get(0)});
          $(document).trigger('b-window_close-all');

      }
    }



};
})(jQuery, window.Lego);
