(function($) {

BEM.DOM.decl('b-campaigns-list', {

    onSetMod: {

        'js' : function() {
            this.checkedCamps = [];

            this.multiCheckbox = this.findBlockInside('item-multicheckbox', 'b-form-checkbox');

            //для красоты, чтобы не было пустоты снизу группы
            if (this.domElem.height() < 300)
                this.setMod('height', 'auto');

            //хитрая обработка событий группы чекбоксов
            this.checkBlocks = $.map(this.findBlocksInside('b-form-checkbox'), $.proxy(function(el){
                el.on('change', function (e) {
                    if (el.hasMod('control')) {
                        if ( this.multiCheckbox.val() )
                            this._onMultiChange(e);
                    }
                    else
                        this._onItemChange(e);
                }, this);

                return el;
            }, this));
        }

    },

    /**
     * Изменение состояния чекбокса
     * Когда значение управлящего чекбокса = all - значит текущий меняется по изменению управляющего
     * @param {Event} e
     * @private
     */
    _onItemChange: function(e) {
        var itemElem = this.findBlockInside(e.block.domElem, 'b-form-checkbox');

        if (itemElem.isChecked())
            this.checkedCamps.push(+itemElem.val());
        else
            this.checkedCamps.splice(this.checkedCamps.indexOf(+itemElem.val()), 1);

        //отмечаем/снимаем галку управляющего чекбокса
        this.multiCheckbox.val('');

        if (this.checkedCamps.length == this.checkBlocks.length - 1)
            this.multiCheckbox.setMod('checked', 'yes');
        else
            this.multiCheckbox.setMod('checked', '');

        this.afterCurrentEvent(function () {
            this.multiCheckbox.val('all');
        });
    },

    /**
     * Изменение управляющего чекбокса
     * @param {Event} e
     * @private
     */
    _onMultiChange: function(e) {
        var itemElem = this.findBlockInside(e.block.domElem, 'b-form-checkbox');

        this.multiChange(itemElem.isChecked() ? 'yes' : '');
    },

    /**
     * Мультиуправление чекбоксами
     * @param {Boolean} status Устанавлиемое состояние
     */
    multiChange: function(status) {
        $.each(this.checkBlocks, $.proxy(function(i, v){
            if (v.hasMod('control'))
                return true;

            v.setMod('checked', status);
        }, this));
    }

})
})(jQuery);
