(function($, Lego) {
    Lego.block['b-campinfo__end-mediaplan'] = function(params) {
        var $this = $(this),
            endMediaplanCommentId = params.endMediaplanCommentId,
            barId = params.barId,
            errorText = params.error,
            endMediaplanFormId = params.endMediaplanFormId,
            endMediaplanForm = $('#' + endMediaplanFormId),
            endMediaplanPopupId = params.endMediaplanPopupId,
            endMediaplanPopup = $('#' + endMediaplanPopupId),
            button = $this.find('.b-campinfo__end-mediaplan__btn').bem('b-form-button'),
            error = endMediaplanPopup.find('.b-campinfo__end-mediaplan__error');

        button.on('click', showPopup);
        endMediaplanPopup.bind('b-window_submit', onSubmit);

        function onSubmit() {
            var acceptType = $('#' + params.endMediaplanAcceptTypeId).val() || '',
                mediaplanInfo = params.mediaplanInfo;

            if (mediaplanInfo.has_max_campaign_groups && acceptType == 'replace') {
                error.text(iget(
                    'Достигнуто максимальное количество групп объявлений в кампании - %s',
                    mediaplanInfo.max_campaign_groups));
                return false;
            }
            
            if (confirm(iget('Вы действительно хотите закончить работу с медиапланом?'))) {
                endMediaplanForm[0].comment.value = $('#' + endMediaplanCommentId).val();
                endMediaplanForm[0].accept_type.value = acceptType;
                endMediaplanForm[0].is_lego_mediaplan.value = $('#' + params.endMediaplanIsLegoTypeId).prop('checked') ? 1 : 0;
                endMediaplanForm.submit();
            }
        }

        function showPopup() {
            error.text('');
            if (errorText) { alert(errorText);  return; }
            $(document).trigger('b-window_close-all');
            endMediaplanPopup.removeClass('g-hidden').data('api').attach($('#' + barId)[0], 'top');
            endMediaplanPopup.data('api').show();
            $(document).trigger('b-comment-form-template_open');
        }
    }

})(jQuery, window.Lego);

