(function($, Lego) {
    Lego.block['b-campinfo__optimize-request'] = function(params) {
        var $this = $(this),
            limit = 300,
            budget = $this.find('.b-campinfo__oreq__budget'),
            form = $this.find('.b-campinfo__oreq__form'),
            popup = $this.find('.b-campinfo__oreq__popup'),
            comment = $this.find('.b-campinfo__oreq__comment'),
            counter = $this.find('.b-campinfo__oreq__counter'),
            submit = $this.find('.b-campinfo__oreq__submit'),
            link = $this.find('.b-campinfo__oreq__link');

        link.click(togglePopup);
        comment.bind('keyup blur', onCommentChange)
        submit.click(onSubmit);
        onCommentChange();


        function onSubmit(e) {
            if (direct.utils.isEmpty(budget.val())) {
                alert(iget('Введите бюджет для первой помощи!'));
                return;
            }
            var value = comment.val();
            value = direct.utils.clearString(value);
            if (value.length > 300) {
                alert(iget('Пожелания клиента не должны превышать 300 символов'));
                return;
            }
            form.submit();
        }

        function onCommentChange() {
            var value = comment.val();
            value = direct.utils.clearString(value);
            var length =  value.length;
            counter.html(limit - length);
            counter.toggleClass('b-campinfo__oreq__counter-error', length > limit)
        }


        function togglePopup(e) {
            e.preventDefault();
            if (!popup.data('api').visible()) {
                $(document).trigger('b-window_close-all');
                popup.removeClass('g-hidden').data('api').show();
            } else {
                popup.data('api').close();
            }


        }

    }


})(jQuery, window.Lego);

