(function($, Lego) {
    Lego.block['b-campinfo__optimize'] = function(params) {
        var $this = $(this),
            error = params.error,
            formName = params.formName,
            barId = params.barId,
            acceptPopupId = params.acceptPopupId,
            acceptCommentId = params.acceptCommentId,
            declineCommentId = params.declineCommentId,
            declinePopupId = params.declinePopupId,
            posAccept = params.posAccept,
            posDecline = params.posDecline,
            acceptPopup = $('#' + acceptPopupId),
            declinePopup = $('#' + declinePopupId),
            acceptBtn = $this.find('.b-campinfo__optimize__accept-button'),
            declineBtn = $this.find('.b-campinfo__optimize__decline-button'),
            declineReasonSelect = declinePopup.find('.b-decline-popup__reason-select'),
            declineComment = declinePopup.find('.b-decline-popup__comment');

        acceptBtn.click(showAcceptPopup);
        declineBtn.click(showDeclinePopup);
        acceptPopup.bind('b-window_submit', onAcceptSubmit);
        declinePopup.bind('b-window_submit', onDeclineSubmit);

        declineReasonSelect.change(function() {
            declineComment.val(({
                dontNeed: iget('По мнению наших специалистов Ваша кампания составлена корректно и не нуждается в "Первой помощи"'),
                notAvailable: iget('К сожалению, сайт, на который ведет ссылка из объявления, недоступен. Это мешает нам провести комплексный анализ Вашей рекламной кампании и дать полезные советы по её улучшению. Пожалуйста, при возможности устраните проблему и направьте заявку повторно.'),
                tooBig: iget('Структура Вашей рекламной кампании требует большего внимания, чем мы можем предложить в рамках «Первой помощи». Для получения подробных советов по повышению эффективности Вашей рекламы мы рекомендуем воспользоваться услугой «Персональный менеджер»'),
                policyDiscrepancy: iget('К сожалению, мы не можем принять Вашу заявку, так как рекламные материалы, необходимые для размещения в Директе, не соответствуют политике Яндекса. С правилами, которые ограничивают размещение рекламы товаров и услуг на наших сервисах, Вы можете ознакомиться здесь: http://legal.yandex.ru/general_adv_rules/'),
                lowDiscrepancy: iget('К сожалению, мы не можем принять Вашу заявку, так как Ваша реклама не соответствуют действующему законодательству. С правилами, которые ограничивают размещение рекламы товаров и услуг, Вы можете ознакомиться здесь: http://legal.yandex.ru/general_adv_rules/'),
                notRelevant: iget('В связи с потерей актуальности Вашей рекламной информации, услуга "Первая помощь" не может быть предоставлена.')
            })[this.value])
        });

        function onAcceptSubmit() {
            if(confirm(iget('Вы действительно хотите закончить оптимизацию?'))){
                var form = $('[name=' + formName + ']')[0];
                form.optType.value = 'completeOptimizing';
                form.optimizationComment.value = $('#' + acceptCommentId).val();
                form.cmd.value = 'completeOptimizing';
                form.submit();
            }
        }

        function onDeclineSubmit() {
                if(confirm(iget('Вы действительно хотите закончить оптимизацию?'))){
                    var form = $('[name=' + formName + ']')[0];
                    form.optType.value = 'declineOptimizing';
                    form.optimizationDeclineComment.value = $('#' + declineCommentId).val();
                    form.cmd.value = 'declineOptimizing';
                    form.submit();
                }
        }


        function showAcceptPopup() {
            if (error) {
                alert(error); return;
            }

            $(document).trigger('b-window_close-all');

            acceptPopup.removeClass('g-hidden').data('api').attach($('#' + barId)[0], posAccept);

            acceptPopup.data('api').show();
            $(document).trigger('b-comment-form-template_open');
        }

        function showDeclinePopup() {
            $(document).trigger('b-window_close-all');
            declinePopup.removeClass('g-hidden').data('api').attach($('#' + barId)[0], posDecline)
            declinePopup.data('api').show();
        }
    }


})(jQuery, window.Lego);

