Lego.block['b-carefree-form'] = function(params) {
    var $this = $(this),
        geo = params.geo,
        fio = $this.find('input[name=fio]'),
        phone = $this.find('input[name=phone]'),
        email = $this.find('input[name=email]'),
        city = $this.find('input[name=city]'),
        referrer = $this.find('.b-carefree-form__referrer'),
        from = $this.find('.b-carefree-form__from'),
        details = $this.find('.b-carefree-form__details'),
        details_link = $this.find('.b-carefree-form__details-link');

    city.val(geo);
    from.val(getFromValue());
    referrer.val(encodeURI(document.referrer));
    details.addClass('g-hidden');

    details_link.click(function() {
        details.toggleClass('g-hidden');
        if (details.css('display') != 'none') {
            details_link.html(iget('Свернуть поля с детальной информацией'));
        } else {
            details_link.html(iget('Заполнить поля с детальной информацией'));
        }
    });

    $this.bind('submit', function() {
        return checkForm();
    });

    function getFromValue() {
       var search = location.search,
           match = search ? search.match(/\?([a-zA-Z0-9]*=[a-zA-Z0-9]*&)?from=([a-zA-Z0-9]*)(&[a-zA-Z0-9]*=[a-zA-Z0-9]*)*?/) : '';

       return match ? match[2] : '';

    }

    function checkForm() {
        if (fio.val().match(/^\s*$/)) {
            alert(iget('Ошибка: не указано имя.'));
            fio.focus();
            return false;
        }
        if (phone.val().match(/^\s*$/i)) {
            alert(iget('Ошибка: не указан телефон.'));
            phone.focus();
            return false;
        }
        if (email.val().match(/^\s*$/i)) {
            alert(iget('Ошибка: не указан адрес электронной почты.'));
            email.focus();
            return false;
        }
        if (!direct.utils.validateEmail(email.val())) {
            alert(iget('Ошибка: неверно указан адрес электронной почты.'));
            email.focus();
            return false;
        }
        send_event("send_servicing_letter");
        return true;
    }

};