
(function($) {
    var WARNING_MESSAGE =  iget('Эта страница просит вас подтвердить, что вы хотите уйти — при этом введённые вами данные могут не сохраниться.');

    BEM.DOM.decl({name:'b-changing-warning'}, {}, {

        bindEvents: function(hasChangesFunc) {
            var _this = this;
            _this.hasChangesFunc = hasChangesFunc;
            if ($.browser.opera || direct.mobile.isAppleMobile()) {
                $('a').bind('click', $.proxy(_this.showWarning, _this));
            } else {
                window.onbeforeunload = function(e) {
                    e || (e = window.event);

                    if (typeof _this.hasChangesFunc == 'function' && _this.hasChangesFunc()) {
                        e && (e.returnValue = WARNING_MESSAGE);

                        return WARNING_MESSAGE;
                    }
                };
            }
        },

        showWarning: function(e) {
            if (this.saveChanges()) {
                e.preventDefault()
            }
        },

        unbindEvents: function() {

            if ($.browser.opera || direct.mobile.isAppleMobile()) {
                $('a').unbind('click');
            } else if (!($.browser.msie && $.browser.version < 9)) {
                window.onbeforeunload = false;
            }
        },

        saveChanges: function() {
            return typeof this.hasChangesFunc == 'function' && this.hasChangesFunc() && !confirm(WARNING_MESSAGE)
        }
    })

})(jQuery);



