(function($){

BEM.DOM.decl({name: 'b-checkboxes-group', modName: 'mode', modVal: 'checkbox'}, {
    onSetMod: {
        'js': function(){
            //иногда на странице может быть несколько вложенных групп чекбоксов - их надо различать
            this.name = this.params.name;
            this.allCbx = this.findBlockInside((this.name ? this.elem('cbx-all', 'name', this.name) : this.elem('cbx-all')), 'b-form-checkbox');
            this.allCbx && this.allCbx.on('change', this.toggleAll, this);
            this.__base()
        }
    },

    refreshHash: function(e, isFirst) {

        this.__base(e, isFirst);

        this.allCbx && this.allCbx.setMod('checked', this.getCommonState() ? 'yes' : 'no');
    },

    toggleAll: function(e) {
        if (!this.allCbx || this.allCbx.getMod('focused') != 'yes') { return; }
        var checked = this.allCbx.getMod('checked');
        this.setAllState(checked);
        this.trigger('change', { mode: 'all', checked: checked });
        this.__base();
    },

    setAllState: function(checked) {
        this.__base(checked);
        this.allCbx && this.allCbx.setMod('checked', checked);
    },

    toggleOne: function(bemElem) {
        if (bemElem.getMod('focused') != 'yes') { return; }
        this.allCbx && this.allCbx.setMod('checked', this.getCommonState() ? 'yes' : 'no');
        this.__base(bemElem);
    }
});

})(jQuery);
